/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;

public class DfaPsiType {
    private final PsiType myPsiType;
    private final DfaValueFactory myFactory;
    private final int myID;

    DfaPsiType(int id, @NotNull PsiType psiType, DfaValueFactory factory) {
        if (psiType == null) {
            DfaPsiType.$$$reportNull$$$0(0);
        }
        this.myID = id;
        this.myPsiType = psiType;
        this.myFactory = factory;
    }

    @NotNull
    public PsiType getPsiType() {
        PsiType psiType = this.myPsiType;
        if (psiType == null) {
            DfaPsiType.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    @NotNull
    public TypeConstraint asConstraint() {
        TypeConstraint constraint = TypeConstraint.EMPTY.withInstanceofValue(this);
        assert (constraint != null);
        TypeConstraint typeConstraint = constraint;
        if (typeConstraint == null) {
            DfaPsiType.$$$reportNull$$$0(2);
        }
        return typeConstraint;
    }

    public boolean isAssignableFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        return this.myFactory.myAssignableCache.computeIfAbsent((Pair<DfaPsiType, DfaPsiType>)key2, k -> this.myPsiType.isAssignableFrom(other.myPsiType));
    }

    public boolean isConvertibleFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key2 = Pair.create((Object)this, (Object)other);
        return this.myFactory.myConvertibleCache.computeIfAbsent((Pair<DfaPsiType, DfaPsiType>)key2, k -> this.myPsiType.isConvertibleFrom(other.myPsiType));
    }

    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    public String toString() {
        return this.myPsiType.getPresentableText();
    }

    public int getID() {
        return this.myID;
    }

    @NotNull
    public static PsiType normalizeType(@NotNull PsiType psiType) {
        if (psiType == null) {
            DfaPsiType.$$$reportNull$$$0(3);
        }
        int dimensions = psiType.getArrayDimensions();
        if ((psiType = psiType.getDeepComponentType()) instanceof PsiCapturedWildcardType) {
            psiType = ((PsiCapturedWildcardType)psiType).getUpperBound();
        }
        if (psiType instanceof PsiWildcardType) {
            psiType = ((PsiWildcardType)psiType).getExtendsBound();
        }
        if (psiType instanceof PsiClassType) {
            psiType = ((PsiClassType)psiType).rawType();
        }
        while (dimensions-- > 0) {
            psiType = psiType.createArrayType();
        }
        PsiType psiType2 = psiType;
        if (psiType2 == null) {
            DfaPsiType.$$$reportNull$$$0(4);
        }
        return psiType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaPsiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaPsiType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asConstraint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalizeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

