/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class AssignInstruction
extends Instruction {
    private final PsiExpression myRExpression;
    private final PsiExpression myLExpression;
    @Nullable
    private final DfaValue myAssignedValue;

    public AssignInstruction(PsiExpression rExpression, @Nullable DfaValue assignedValue) {
        this(AssignInstruction.getLeftHandOfAssignment(rExpression), rExpression, assignedValue);
    }

    public AssignInstruction(PsiExpression lExpression, PsiExpression rExpression, @Nullable DfaValue assignedValue) {
        this.myLExpression = lExpression;
        this.myRExpression = rExpression;
        this.myAssignedValue = assignedValue;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitAssign(this, runner, stateBefore);
    }

    @Nullable
    public PsiExpression getRExpression() {
        return this.myRExpression;
    }

    @Nullable
    public PsiExpression getLExpression() {
        return this.myLExpression;
    }

    public boolean isVariableInitializer() {
        return this.myRExpression != null && this.myRExpression.getParent() instanceof PsiVariable;
    }

    @Nullable
    public DfaValue getAssignedValue() {
        return this.myAssignedValue;
    }

    public String toString() {
        return "ASSIGN";
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiExpression getLeftHandOfAssignment(PsiExpression rExpression) {
        if (rExpression == null) {
            return null;
        }
        if (rExpression.getParent() instanceof PsiAssignmentExpression) {
            return ((PsiAssignmentExpression)rExpression.getParent()).getLExpression();
        }
        return null;
    }
}

