/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.inliner.InlinerUtil;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.function.BiConsumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OptionalChainInliner
implements CallInliner {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1), CallMatcher.instanceCall("com.google.common.base.Optional", "or").parameterTypes("T"));
    private static final CallMatcher OPTIONAL_OR_NULL = CallMatcher.instanceCall("com.google.common.base.Optional", "orNull").parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1), CallMatcher.instanceCall("com.google.common.base.Optional", "or").parameterTypes("com.google.common.base.Supplier"));
    private static final CallMatcher OPTIONAL_OR = CallMatcher.instanceCall("java.util.Optional", "or").parameterCount(1);
    private static final CallMatcher OPTIONAL_IF_PRESENT = CallMatcher.instanceCall("java.util.Optional", "ifPresent").parameterCount(1);
    private static final CallMatcher OPTIONAL_FILTER = CallMatcher.instanceCall("java.util.Optional", "filter").parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);
    private static final CallMatcher GUAVA_TRANSFORM = CallMatcher.instanceCall("com.google.common.base.Optional", "transform").parameterCount(1);
    private static final CallMatcher OPTIONAL_FLAT_MAP = CallMatcher.instanceCall("java.util.Optional", "flatMap").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Optional", "of", "ofNullable").parameterCount(1), CallMatcher.staticCall("com.google.common.base.Optional", "of", "fromNullable").parameterCount(1));
    private static final CallMatcher OPTIONAL_EMPTY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Optional", "empty").parameterCount(0), CallMatcher.staticCall("com.google.common.base.Optional", "absent").parameterCount(0));
    private static final CallMatcher GUAVA_TO_JAVA = CallMatcher.instanceCall("com.google.common.base.Optional", "toJavaUtil").parameterCount(0);
    private static final CallMapper<BiConsumer<CFGBuilder, PsiMethodCallExpression>> TERMINAL_MAPPER = new CallMapper<BiConsumer<CFGBuilder, PsiMethodCallExpression>>().register(OPTIONAL_OR_ELSE, (builder, call) -> {
        PsiExpression argument = call.getArgumentList().getExpressions()[0];
        if (ExpressionUtils.isNullLiteral(argument)) {
            return;
        }
        builder.pushExpression(argument).boxUnbox(argument, call.getType()).splice(2, 0, 1, 1).ifNotNull().swap().end().pop();
    }).register(OPTIONAL_OR_NULL, (builder, call) -> {}).register(OPTIONAL_OR_ELSE_GET, (builder, call) -> {
        PsiExpression fn = call.getArgumentList().getExpressions()[0];
        builder.evaluateFunction(fn).dup().ifNull().pop().invokeFunction(0, fn).end();
    }).register(OPTIONAL_IF_PRESENT, (builder, call) -> {
        PsiExpression fn = call.getArgumentList().getExpressions()[0];
        builder.evaluateFunction(fn).dup().ifNotNull().invokeFunction(1, fn).elseBranch().pop().pushUnknown().end();
    });
    private static final CallMapper<BiConsumer<CFGBuilder, PsiExpression>> INTERMEDIATE_MAPPER = new CallMapper<BiConsumer<CFGBuilder, PsiExpression>>().register(OPTIONAL_MAP, (builder, function) -> OptionalChainInliner.inlineMap(builder, function, Nullability.NULLABLE)).register(GUAVA_TRANSFORM, (builder, function) -> OptionalChainInliner.inlineMap(builder, function, Nullability.NOT_NULL)).register(OPTIONAL_FILTER, (builder, function) -> builder.evaluateFunction((PsiExpression)function).dup().ifNotNull().dup().invokeFunction(1, (PsiExpression)function).ifConditionIs(false).pop().pushNull().end().end()).register(OPTIONAL_FLAT_MAP, (builder, function) -> builder.dup().ifNotNull().chain(b -> OptionalChainInliner.invokeAndUnwrapOptional(b, 1, function)).end()).register(OPTIONAL_OR, (builder, function) -> builder.dup().ifNull().pop().chain(b -> OptionalChainInliner.invokeAndUnwrapOptional(b, 0, function)).end()).register(GUAVA_TO_JAVA, (builder, stub) -> {});

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        BiConsumer<CFGBuilder, PsiMethodCallExpression> terminalInliner;
        if (builder == null) {
            OptionalChainInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            OptionalChainInliner.$$$reportNull$$$0(1);
        }
        if ((terminalInliner = TERMINAL_MAPPER.mapFirst(call)) != null) {
            PsiExpression qualifierExpression2 = call.getMethodExpression().getQualifierExpression();
            if (!OptionalChainInliner.pushOptionalValue(builder, PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierExpression2), call, NullabilityProblemKind.callNPE)) {
                return false;
            }
            terminalInliner.accept(builder, call);
            return true;
        }
        DfaValueFactory factFactory = builder.getFactory();
        if (OptionalChainInliner.pushIntermediateOperationValue(builder, call)) {
            builder.ifNotNull().push(factFactory.getFactValue(DfaFactType.OPTIONAL_PRESENCE, true)).elseBranch().push(factFactory.getFactValue(DfaFactType.OPTIONAL_PRESENCE, false)).end();
            return true;
        }
        if (OPTIONAL_EMPTY.test(call)) {
            builder.push(factFactory.getFactValue(DfaFactType.OPTIONAL_PRESENCE, false));
            return true;
        }
        return false;
    }

    @Contract(value="null -> null")
    private static PsiType getOptionalElementType(PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)expression2.getType(), PsiClassType.class);
        if (type2 == null) {
            return null;
        }
        String rawName = type2.rawType().getCanonicalText();
        if (!rawName.equals("java.util.Optional") && !rawName.equals("com.google.common.base.Optional")) {
            return null;
        }
        PsiType[] parameters2 = type2.getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        return parameters2[0];
    }

    private static <T extends PsiElement> boolean pushOptionalValue(CFGBuilder builder, PsiExpression expression2, T dereferenceContext, NullabilityProblemKind<T> problem) {
        PsiType optionalElementType = OptionalChainInliner.getOptionalElementType(expression2);
        if (optionalElementType == null) {
            return false;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)expression2;
            if (OPTIONAL_EMPTY.test(qualifierCall)) {
                builder.pushNull();
                return true;
            }
            if (OptionalChainInliner.pushIntermediateOperationValue(builder, qualifierCall)) {
                builder.assignTo(builder.createTempVariable(optionalElementType));
                return true;
            }
        }
        DfaValue presentOptional = builder.getFactory().getFactValue(DfaFactType.OPTIONAL_PRESENCE, true);
        builder.pushExpression(expression2).checkNotNull(dereferenceContext, problem).push(presentOptional).ifCondition(JavaTokenType.INSTANCEOF_KEYWORD).push(builder.getFactory().createTypeValue(optionalElementType, Nullability.NOT_NULL)).elseBranch().pushNull().end().assignTo(builder.createTempVariable(optionalElementType));
        return true;
    }

    private static boolean pushIntermediateOperationValue(CFGBuilder builder, PsiMethodCallExpression call) {
        if (OPTIONAL_OF.test(call)) {
            PsiType optionalElementType = OptionalChainInliner.getOptionalElementType((PsiExpression)call);
            OptionalChainInliner.inlineOf(builder, optionalElementType, call);
            return true;
        }
        BiConsumer<CFGBuilder, PsiExpression> intermediateInliner = INTERMEDIATE_MAPPER.mapFirst(call);
        if (intermediateInliner == null) {
            return false;
        }
        PsiExpression argument = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
        PsiExpression qualifierExpression2 = call.getMethodExpression().getQualifierExpression();
        if (!OptionalChainInliner.pushOptionalValue(builder, PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierExpression2), call, NullabilityProblemKind.callNPE)) {
            return false;
        }
        intermediateInliner.accept(builder, argument);
        return true;
    }

    private static void invokeAndUnwrapOptional(CFGBuilder builder, int argCount, PsiExpression function) {
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)function), PsiLambdaExpression.class);
        if (lambda2 != null) {
            Object[] parameters2 = lambda2.getParameterList().getParameters();
            PsiExpression lambdaBody = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (parameters2.length == argCount && lambdaBody != null) {
                StreamEx.ofReversed((Object[])parameters2).forEach(p -> builder.assignTo((PsiVariable)p).pop());
                if (OptionalChainInliner.pushOptionalValue(builder, lambdaBody, lambdaBody, NullabilityProblemKind.nullableFunctionReturn)) {
                    return;
                }
                StreamEx.of((Object[])parameters2).map(builder.getFactory().getVarFactory()::createVariableValue).forEach(builder::push);
            }
        }
        builder.evaluateFunction(function).invokeFunction(argCount, function, Nullability.NOT_NULL).pop().pushUnknown();
    }

    private static void inlineMap(CFGBuilder builder, PsiExpression function, Nullability resultNullability) {
        builder.evaluateFunction(function).dup().ifNotNull().invokeFunction(1, function, resultNullability).end();
    }

    private static void inlineOf(CFGBuilder builder, PsiType optionalElementType, PsiMethodCallExpression qualifierCall) {
        PsiExpression argument = qualifierCall.getArgumentList().getExpressions()[0];
        builder.pushExpression(argument).boxUnbox(argument, optionalElementType).pushUnknown().splice(2, 1, 0, 1).invoke(qualifierCall).pop();
        if ("of".equals(qualifierCall.getMethodExpression().getReferenceName())) {
            builder.checkNotNull(argument, NullabilityProblemKind.passingNullableToNotNullParameter);
        }
    }

    @Override
    public boolean mayInferPreciseType(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            OptionalChainInliner.$$$reportNull$$$0(2);
        }
        return InlinerUtil.isLambdaChainParameterReference(expression2, TypeUtils::isOptional);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inliner/OptionalChainInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mayInferPreciseType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

