/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceVisitor;
import com.intellij.codeInspection.dataFlow.inference.ParameterNullityInferenceKt;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceVisitor;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J<\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0019H\u0002J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0019H\u0016J$\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00192\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020&0-H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/InferenceVisitor;", "Lcom/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor;", "tree", "Lcom/intellij/lang/LighterAST;", "(Lcom/intellij/lang/LighterAST;)V", "methodIndex", "", "getMethodIndex", "()I", "setMethodIndex", "(I)V", "result", "Ljava/util/HashMap;", "Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "getResult", "()Ljava/util/HashMap;", "getTree", "()Lcom/intellij/lang/LighterAST;", "volatileFieldNames", "Ljava/util/HashSet;", "", "getVolatileFieldNames", "()Ljava/util/HashSet;", "calcData", "method", "Lcom/intellij/lang/LighterASTNode;", "createData", "body", "contracts", "", "Lcom/intellij/codeInspection/dataFlow/inference/PreContract;", "methodReturn", "Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "purity", "Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "notNullParams", "Ljava/util/BitSet;", "gatherFields", "", "aClass", "visitNode", "element", "walkMethodBody", "root", "processor", "Lkotlin/Function1;", "intellij.java.analysis.impl"})
final class InferenceVisitor
extends RecursiveLighterASTNodeWalkingVisitor {
    private int methodIndex;
    @NotNull
    private final HashSet<String> volatileFieldNames;
    @NotNull
    private final HashMap<Integer, MethodData> result;
    @NotNull
    private final LighterAST tree;

    public final int getMethodIndex() {
        return this.methodIndex;
    }

    public final void setMethodIndex(int n) {
        this.methodIndex = n;
    }

    @NotNull
    public final HashSet<String> getVolatileFieldNames() {
        return this.volatileFieldNames;
    }

    @NotNull
    public final HashMap<Integer, MethodData> getResult() {
        return this.result;
    }

    public void visitNode(@NotNull LighterASTNode element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        IElementType iElementType = element.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.CLASS)) {
            this.gatherFields(element);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.METHOD)) {
            MethodData methodData = this.calcData(element);
            if (methodData != null) {
                MethodData methodData2;
                MethodData data = methodData2 = methodData;
                Map map = this.result;
                Integer n = this.methodIndex;
                MethodData methodData3 = data;
                map.put(n, methodData3);
            }
            int n = this.methodIndex;
            this.methodIndex = n + 1;
        }
        if (JavaLightStubBuilder.isCodeBlockWithoutStubs(element)) {
            return;
        }
        super.visitNode(element);
    }

    private final void gatherFields(LighterASTNode aClass) {
        List list = LightTreeUtil.getChildrenOfType((LighterAST)this.tree, (LighterASTNode)aClass, (IElementType)JavaElementType.FIELD);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"LightTreeUtil.getChildre\u2026Type(tree, aClass, FIELD)");
        List fields = list;
        for (LighterASTNode field : fields) {
            String fieldName = JavaLightTreeUtil.getNameIdentifierText(this.tree, field);
            if (fieldName == null || !JavaLightTreeUtil.hasExplicitModifier(this.tree, field, JavaTokenType.VOLATILE_KEYWORD)) continue;
            this.volatileFieldNames.add(fieldName);
        }
    }

    private final MethodData calcData(LighterASTNode method) {
        LighterASTNode lighterASTNode = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)((IElementType)JavaElementType.CODE_BLOCK));
        if (lighterASTNode == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"LightTreeUtil.firstChild\u2026ODE_BLOCK) ?: return null");
        LighterASTNode body2 = lighterASTNode;
        List<LighterASTNode> list = ContractInferenceInterpreter.getStatements(body2, this.tree);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"ContractInferenceInterpr\u2026getStatements(body, tree)");
        List<LighterASTNode> statements = list;
        List<PreContract> list2 = new ContractInferenceInterpreter(this.tree, method, body2).inferContracts(statements);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ContractInferenceInterpr\u2026nferContracts(statements)");
        List<PreContract> contracts2 = list2;
        MethodReturnInferenceVisitor nullityVisitor = new MethodReturnInferenceVisitor(this.tree, body2);
        PurityInferenceVisitor purityVisitor = new PurityInferenceVisitor(this.tree, body2, (Set<String>)this.volatileFieldNames);
        Iterator<LighterASTNode> iterator = statements.iterator();
        while (iterator.hasNext()) {
            LighterASTNode statement;
            LighterASTNode lighterASTNode2 = statement = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode2, (String)"statement");
            this.walkMethodBody(lighterASTNode2, (Function1<? super LighterASTNode, Unit>)((Function1)new Function1<LighterASTNode, Unit>(nullityVisitor, purityVisitor){
                final /* synthetic */ MethodReturnInferenceVisitor $nullityVisitor;
                final /* synthetic */ PurityInferenceVisitor $purityVisitor;

                public final void invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$nullityVisitor.visitNode(it);
                    this.$purityVisitor.visitNode(it);
                }
                {
                    this.$nullityVisitor = methodReturnInferenceVisitor;
                    this.$purityVisitor = purityInferenceVisitor;
                    super(1);
                }
            }));
        }
        BitSet notNullParams = ParameterNullityInferenceKt.inferNotNullParameters(this.tree, method, statements);
        return this.createData(body2, contracts2, nullityVisitor.getResult(), purityVisitor.getResult(), notNullParams);
    }

    private final void walkMethodBody(LighterASTNode root, Function1<? super LighterASTNode, Unit> processor) {
        new RecursiveLighterASTNodeWalkingVisitor(this, processor, this.tree){
            final /* synthetic */ InferenceVisitor this$0;
            final /* synthetic */ Function1 $processor;

            public void visitNode(@NotNull LighterASTNode element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                IElementType type2 = element.getTokenType();
                if (type2 == JavaElementType.CLASS || type2 == JavaElementType.FIELD || type2 == JavaElementType.METHOD || type2 == JavaElementType.ANNOTATION_METHOD || type2 == JavaElementType.LAMBDA_EXPRESSION) {
                    return;
                }
                this.$processor.invoke((Object)element);
                super.visitNode(element);
            }
            {
                this.this$0 = $outer;
                this.$processor = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.visitNode(root);
    }

    private final MethodData createData(LighterASTNode body2, List<? extends PreContract> contracts2, MethodReturnInferenceResult methodReturn, PurityInferenceResult purity2, BitSet notNullParams) {
        if (methodReturn == null && purity2 == null && contracts2.isEmpty() && notNullParams.isEmpty()) {
            return null;
        }
        return new MethodData(methodReturn, purity2, contracts2, notNullParams, body2.getStartOffset(), body2.getEndOffset());
    }

    @NotNull
    public final LighterAST getTree() {
        return this.tree;
    }

    public InferenceVisitor(@NotNull LighterAST tree) {
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        super(tree);
        this.tree = tree;
        this.volatileFieldNames = new HashSet();
        this.result = new HashMap();
    }
}

