/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeConstraint {
    public static final TypeConstraint EMPTY = new TypeConstraint(Collections.emptySet(), Collections.emptySet());
    @NotNull
    private final Set<DfaPsiType> myInstanceofValues;
    @NotNull
    private final Set<DfaPsiType> myNotInstanceofValues;

    private TypeConstraint(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
        if (instanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(0);
        }
        if (notInstanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(1);
        }
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
    }

    @NotNull
    public String getPresentationText(@Nullable PsiType type2) {
        Set instanceOfTypes = this.myInstanceofValues;
        if (type2 != null) {
            instanceOfTypes = StreamEx.of(instanceOfTypes).removeBy(DfaPsiType::getPsiType, (Object)DfaPsiType.normalizeType(type2)).toSet();
        }
        String string = EntryStream.of((Object)"instanceof ", instanceOfTypes, (Object)"not instanceof ", this.myNotInstanceofValues).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> ((StreamEx)StreamEx.of((Collection)set).map(DfaPsiType::toString).sorted()).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)"\n");
        if (string == null) {
            TypeConstraint.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static TypeConstraint create(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues) {
        if (instanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(3);
        }
        if (notInstanceofValues == null) {
            TypeConstraint.$$$reportNull$$$0(4);
        }
        if (instanceofValues.isEmpty() && notInstanceofValues.isEmpty()) {
            return EMPTY;
        }
        if (instanceofValues.isEmpty()) {
            instanceofValues = Collections.emptySet();
        } else if (instanceofValues.size() == 1) {
            instanceofValues = Collections.singleton(instanceofValues.iterator().next());
        }
        if (notInstanceofValues.isEmpty()) {
            notInstanceofValues = Collections.emptySet();
        } else if (notInstanceofValues.size() == 1) {
            notInstanceofValues = Collections.singleton(notInstanceofValues.iterator().next());
        }
        return new TypeConstraint(instanceofValues, notInstanceofValues);
    }

    boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType == null) {
            TypeConstraint.$$$reportNull$$$0(5);
        }
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public TypeConstraint withInstanceofValue(@NotNull DfaPsiType type2) {
        PsiType psiType;
        if (type2 == null) {
            TypeConstraint.$$$reportNull$$$0(6);
        }
        if ((psiType = type2.getPsiType()) instanceof PsiPrimitiveType || LambdaUtil.notInferredType((PsiType)psiType)) {
            return this;
        }
        if (!this.checkInstanceofValue(type2)) {
            return null;
        }
        ArrayList<DfaPsiType> moreGeneric = new ArrayList<DfaPsiType>();
        for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
            if (type2.isAssignableFrom(alreadyInstanceof)) {
                return this;
            }
            if (!alreadyInstanceof.isAssignableFrom(type2)) continue;
            moreGeneric.add(alreadyInstanceof);
        }
        HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
        newInstanceof.removeAll(moreGeneric);
        newInstanceof.add(type2);
        return TypeConstraint.create(newInstanceof, this.myNotInstanceofValues);
    }

    @Nullable
    public TypeConstraint withNotInstanceofValue(DfaPsiType type2) {
        if (this.myNotInstanceofValues.contains(type2)) {
            return this;
        }
        for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
            if (!type2.isAssignableFrom(dfaPsiType)) continue;
            return null;
        }
        ArrayList<DfaPsiType> moreSpecific = new ArrayList<DfaPsiType>();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(type2)) {
                return this;
            }
            if (!type2.isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet hashSet = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        hashSet.removeAll(moreSpecific);
        hashSet.add(type2);
        return TypeConstraint.create(this.myInstanceofValues, hashSet);
    }

    @NotNull
    TypeConstraint withoutType(@NotNull DfaPsiType type2) {
        if (type2 == null) {
            TypeConstraint.$$$reportNull$$$0(7);
        }
        if (this.myInstanceofValues.contains(type2)) {
            HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type2);
            TypeConstraint typeConstraint = TypeConstraint.create(newInstanceof, this.myNotInstanceofValues);
            if (typeConstraint == null) {
                TypeConstraint.$$$reportNull$$$0(8);
            }
            return typeConstraint;
        }
        if (this.myNotInstanceofValues.contains(type2)) {
            HashSet newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type2);
            TypeConstraint typeConstraint = TypeConstraint.create(this.myInstanceofValues, newNotInstanceof);
            if (typeConstraint == null) {
                TypeConstraint.$$$reportNull$$$0(9);
            }
            return typeConstraint;
        }
        TypeConstraint typeConstraint = this;
        if (typeConstraint == null) {
            TypeConstraint.$$$reportNull$$$0(10);
        }
        return typeConstraint;
    }

    @Nullable
    public PsiType getPsiType() {
        PsiType[] conjuncts = (PsiType[])StreamEx.of(this.myInstanceofValues).map(DfaPsiType::getPsiType).toArray((Object[])PsiType.EMPTY_ARRAY);
        return conjuncts.length == 0 ? null : PsiIntersectionType.createIntersection((boolean)true, (PsiType[])conjuncts);
    }

    boolean isSuperStateOf(@NotNull TypeConstraint that) {
        if (that == null) {
            TypeConstraint.$$$reportNull$$$0(11);
        }
        if (that.myNotInstanceofValues.containsAll(this.myNotInstanceofValues) && that.myInstanceofValues.containsAll(this.myInstanceofValues)) {
            return true;
        }
        if (this.myNotInstanceofValues.isEmpty() && that.myNotInstanceofValues.isEmpty()) {
            return that.myInstanceofValues.stream().allMatch(thatType -> this.myInstanceofValues.stream().allMatch(thisType -> thisType.isAssignableFrom((DfaPsiType)thatType)));
        }
        return false;
    }

    @Nullable
    public TypeConstraint union(@NotNull TypeConstraint other) {
        Set<DfaPsiType> instanceOfTypes;
        if (other == null) {
            TypeConstraint.$$$reportNull$$$0(12);
        }
        if (this.isSuperStateOf(other)) {
            return this;
        }
        if (other.isSuperStateOf(this)) {
            return other;
        }
        HashSet<DfaPsiType> notTypes = new HashSet<DfaPsiType>(this.myNotInstanceofValues);
        notTypes.retainAll(other.myNotInstanceofValues);
        if (this.myInstanceofValues.containsAll(other.myInstanceofValues)) {
            instanceOfTypes = other.myInstanceofValues;
        } else if (other.myInstanceofValues.containsAll(this.myInstanceofValues)) {
            instanceOfTypes = this.myInstanceofValues;
        } else {
            instanceOfTypes = TypeConstraint.withSuper(this.myInstanceofValues);
            instanceOfTypes.retainAll(TypeConstraint.withSuper(other.myInstanceofValues));
        }
        TypeConstraint constraint = EMPTY;
        for (DfaPsiType type2 : instanceOfTypes) {
            if ((constraint = constraint.withInstanceofValue(type2)) != null) continue;
            return EMPTY;
        }
        for (DfaPsiType type2 : notTypes) {
            if ((constraint = constraint.withNotInstanceofValue(type2)) != null) continue;
            return EMPTY;
        }
        return constraint;
    }

    private static Set<DfaPsiType> withSuper(Set<DfaPsiType> instanceofValues) {
        HashSet<DfaPsiType> result = new HashSet<DfaPsiType>(instanceofValues);
        for (DfaPsiType type2 : instanceofValues) {
            InheritanceUtil.processSuperTypes((PsiType)type2.getPsiType(), (boolean)false, t -> result.add(type2.getFactory().createDfaType((PsiType)t)));
        }
        return result;
    }

    @NotNull
    public Set<DfaPsiType> getInstanceofValues() {
        Set<DfaPsiType> set = Collections.unmodifiableSet(this.myInstanceofValues);
        if (set == null) {
            TypeConstraint.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Set<DfaPsiType> getNotInstanceofValues() {
        Set<DfaPsiType> set = Collections.unmodifiableSet(this.myNotInstanceofValues);
        if (set == null) {
            TypeConstraint.$$$reportNull$$$0(14);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myInstanceofValues.isEmpty() && this.myNotInstanceofValues.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeConstraint that = (TypeConstraint)o;
        return Objects.equals(this.myInstanceofValues, that.myInstanceofValues) && Objects.equals(this.myNotInstanceofValues, that.myNotInstanceofValues);
    }

    public int hashCode() {
        return Objects.hash(this.myInstanceofValues, this.myNotInstanceofValues);
    }

    public String toString() {
        return EntryStream.of((Object)"instanceof ", this.myInstanceofValues, (Object)"not instanceof ", this.myNotInstanceofValues).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
    }

    @Nullable
    public static DfaFactMap withInstanceOf(@NotNull DfaFactMap map, @NotNull DfaPsiType type2) {
        TypeConstraint constraint;
        if (map == null) {
            TypeConstraint.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            TypeConstraint.$$$reportNull$$$0(16);
        }
        if ((constraint = map.get(DfaFactType.TYPE_CONSTRAINT)) == null) {
            constraint = EMPTY;
        }
        return (constraint = constraint.withInstanceofValue(type2)) == null ? null : map.with(DfaFactType.TYPE_CONSTRAINT, constraint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceofValues";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notInstanceofValues";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaType";
                break;
            }
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceofValues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInstanceofValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkInstanceofValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceofValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withoutType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSuperStateOf";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

