/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableSource;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpecialField implements DfaVariableSource
{
    ARRAY_LENGTH(null, "length", true, LongRangeSet.indexRange()){

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiField && "length".equals(accessor.getName()) && JavaPsiFacade.getElementFactory((Project)accessor.getProject()).getArrayClass(PsiUtil.getLanguageLevel((PsiElement)accessor)) == accessor.getContainingClass();
        }

        @Override
        DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
            if (initializer instanceof PsiArrayInitializerExpression) {
                return factory.getInt(((PsiArrayInitializerExpression)initializer).getInitializers().length);
            }
            if (initializer instanceof PsiNewExpression) {
                Object length;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                if (arrayInitializer != null) {
                    return factory.getInt(arrayInitializer.getInitializers().length);
                }
                PsiExpression[] dimensions = ((PsiNewExpression)initializer).getArrayDimensions();
                if (dimensions.length > 0 && (length = ExpressionUtils.computeConstantExpression(dimensions[0])) instanceof Integer) {
                    return factory.getInt((Integer)length);
                }
            }
            return null;
        }
    }
    ,
    STRING_LENGTH("java.lang.String", "length", true, LongRangeSet.indexRange()){

        @Override
        DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
            Object value2 = ExpressionUtils.computeConstantExpression(initializer);
            if (value2 instanceof String) {
                return factory.getInt(((String)value2).length());
            }
            return null;
        }

        @Override
        public DfaValue fromConstant(DfaValueFactory factory, @NotNull Object obj) {
            if (obj == null) {
                2.$$$reportNull$$$0(0);
            }
            return obj instanceof String ? factory.getInt(((String)obj).length()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/codeInspection/dataFlow/SpecialField$2", "fromConstant"));
        }
    }
    ,
    COLLECTION_SIZE("java.util.Collection", "size", false, LongRangeSet.indexRange()),
    MAP_SIZE("java.util.Map", "size", false, LongRangeSet.indexRange());

    private final String myClassName;
    private final String myMethodName;
    private final boolean myFinal;
    private final LongRangeSet myRange;

    private SpecialField(String className, String methodName, boolean isFinal, LongRangeSet range) {
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myFinal = isFinal;
        this.myRange = range;
    }

    @Override
    public boolean isStable() {
        return this.myFinal;
    }

    public LongRangeSet getRange() {
        return this.myRange;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    boolean isMyAccessor(PsiMember accessor) {
        return accessor instanceof PsiMethod && MethodUtils.methodMatches((PsiMethod)accessor, this.myClassName, null, this.myMethodName, new PsiType[0]);
    }

    @Contract(value="null -> null")
    @Nullable
    public static SpecialField findSpecialField(PsiElement accessor) {
        if (!(accessor instanceof PsiMember)) {
            return null;
        }
        return StreamEx.of((Object[])SpecialField.values()).findFirst(sf -> sf.isMyAccessor((PsiMember)accessor)).orElse(null);
    }

    public DfaValue createValue(DfaValueFactory factory, DfaValue qualifier) {
        DfaValue value2;
        Object obj;
        if (qualifier instanceof DfaVariableValue) {
            DfaValue value3;
            PsiExpression initializer;
            DfaVariableValue variableValue = (DfaVariableValue)qualifier;
            PsiModifierListOwner psiVariable = variableValue.getPsiVariable();
            if (psiVariable instanceof PsiField && factory.canTrustFieldInitializer((PsiField)psiVariable) && psiVariable.hasModifierProperty("static") && psiVariable.hasModifierProperty("final") && (initializer = ((PsiField)psiVariable).getInitializer()) != null && (value3 = this.fromInitializer(factory, initializer)) != null) {
                return value3;
            }
            return factory.getVarFactory().createVariableValue(this, (PsiType)PsiType.INT, variableValue);
        }
        if (qualifier instanceof DfaConstValue && (obj = ((DfaConstValue)qualifier).getValue()) != null && (value2 = this.fromConstant(factory, obj)) != null) {
            return value2;
        }
        return factory.getFactValue(DfaFactType.RANGE, this.myRange);
    }

    DfaValue fromInitializer(DfaValueFactory factory, PsiExpression initializer) {
        return null;
    }

    DfaValue fromConstant(DfaValueFactory factory, @NotNull Object obj) {
        if (obj == null) {
            SpecialField.$$$reportNull$$$0(0);
        }
        return null;
    }

    public List<MethodContract> getEmptyContracts() {
        ContractValue thisValue = ContractValue.qualifier().specialField(this);
        return Arrays.asList(MethodContract.singleConditionContract(thisValue, DfaRelationValue.RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse()));
    }

    public List<MethodContract> getEqualsContracts() {
        return Arrays.asList(new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(this), DfaRelationValue.RelationType.NE, ContractValue.argument(0).specialField(this), ContractReturnValue.returnFalse()));
    }

    @Override
    public String toString() {
        return this.myMethodName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/codeInspection/dataFlow/SpecialField", "fromConstant"));
    }
}

