/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullabilityUtil {
    static Boolean calcCanBeNull(DfaVariableValue value2) {
        PsiType itemType;
        PsiExpression iteratedValue2;
        if (value2.getSource() instanceof DfaExpressionFactory.ThisSource) {
            return false;
        }
        PsiModifierListOwner var = value2.getPsiVariable();
        Nullability nullability = DfaPsiUtil.getElementNullabilityIgnoringParameterInference(value2.getVariableType(), var);
        if (nullability != Nullability.UNKNOWN) {
            return NullabilityUtil.toBoolean(nullability);
        }
        if (var == null) {
            return null;
        }
        Nullability defaultNullability = value2.getFactory().suggestNullabilityForNonAnnotatedMember(var);
        if (var instanceof PsiParameter && var.getParent() instanceof PsiForeachStatement && (iteratedValue2 = ((PsiForeachStatement)var.getParent()).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2)) != null) {
            return NullabilityUtil.toBoolean(DfaPsiUtil.getElementNullability(itemType, var));
        }
        if (var instanceof PsiField && value2.getFactory().canTrustFieldInitializer((PsiField)var)) {
            return NullabilityUtil.toBoolean(NullabilityUtil.getNullabilityFromFieldInitializers((PsiField)var, defaultNullability));
        }
        return NullabilityUtil.toBoolean(defaultNullability);
    }

    private static Nullability getNullabilityFromFieldInitializers(PsiField field, Nullability defaultNullability) {
        if (DfaPsiUtil.isFinalField((PsiVariable)field)) {
            PsiExpression initializer = field.getInitializer();
            if (initializer != null) {
                return NullabilityUtil.getExpressionNullability(initializer);
            }
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            if (initializers.isEmpty()) {
                return defaultNullability;
            }
            for (PsiExpression expression2 : initializers) {
                if (NullabilityUtil.getExpressionNullability(expression2) != Nullability.NULLABLE) continue;
                return Nullability.NULLABLE;
            }
            if (DfaPsiUtil.isInitializedNotNull(field)) {
                return Nullability.NOT_NULL;
            }
        } else if (NullabilityUtil.isOnlyImplicitlyInitialized(field)) {
            return Nullability.NOT_NULL;
        }
        return defaultNullability;
    }

    private static boolean isOnlyImplicitlyInitialized(PsiField field) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)(NullabilityUtil.isImplicitlyInitializedNotNull(field) && NullabilityUtil.weAreSureThereAreNoExplicitWrites(field) ? 1 : 0), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isImplicitlyInitializedNotNull(PsiField field) {
        return ContainerUtil.exists((Object[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME), p -> p.isImplicitlyNotNullInitialized((PsiElement)field));
    }

    private static boolean weAreSureThereAreNoExplicitWrites(PsiField field) {
        String name = field.getName();
        if (name == null || field.getInitializer() != null) {
            return false;
        }
        if (!NullabilityUtil.isCheapEnoughToSearch(field, name)) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)field).forEach(reference -> reference instanceof PsiReferenceExpression && !PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)reference)));
    }

    private static boolean isCheapEnoughToSearch(PsiField field, String name) {
        SearchScope scope = field.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)field.getProject());
        PsiSearchHelper.SearchCostResult result = helper.isCheapEnoughToSearch(name, (GlobalSearchScope)scope, field.getContainingFile(), null);
        return result != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    public static Nullability getExpressionNullability(@Nullable PsiExpression expression2) {
        return NullabilityUtil.getExpressionNullability(expression2, false);
    }

    public static Nullability getExpressionNullability(@Nullable PsiExpression expression2, boolean useDataflow) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return Nullability.UNKNOWN;
        }
        if (expression2.textMatches((CharSequence)"null")) {
            return Nullability.NULLABLE;
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiPolyadicExpression || expression2 instanceof PsiFunctionalExpression || expression2.getType() instanceof PsiPrimitiveType) {
            return Nullability.NOT_NULL;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expression2).getThenExpression();
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expression2).getElseExpression();
            if (thenExpression2 == null || elseExpression2 == null) {
                return Nullability.UNKNOWN;
            }
            PsiExpression condition2 = ((PsiConditionalExpression)expression2).getCondition();
            PsiReferenceExpression ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, true);
            if (ref != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)ref, elseExpression2)) {
                return NullabilityUtil.getExpressionNullability(thenExpression2, useDataflow);
            }
            ref = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, false);
            if (ref != null && JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)ref, thenExpression2)) {
                return NullabilityUtil.getExpressionNullability(elseExpression2, useDataflow);
            }
            if (useDataflow) {
                return NullabilityUtil.fromBoolean(CommonDataflow.getExpressionFact(expression2, DfaFactType.CAN_BE_NULL));
            }
            Nullability left = NullabilityUtil.getExpressionNullability(thenExpression2, false);
            if (left == Nullability.UNKNOWN) {
                return Nullability.UNKNOWN;
            }
            Nullability right = NullabilityUtil.getExpressionNullability(elseExpression2, false);
            return left == right ? left : Nullability.UNKNOWN;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            return NullabilityUtil.getExpressionNullability(((PsiTypeCastExpression)expression2).getOperand(), useDataflow);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                return NullabilityUtil.getExpressionNullability(assignment.getRExpression(), useDataflow);
            }
            return Nullability.NOT_NULL;
        }
        if (useDataflow) {
            return NullabilityUtil.fromBoolean(CommonDataflow.getExpressionFact(expression2, DfaFactType.CAN_BE_NULL));
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression2).resolve();
            return DfaPsiUtil.getElementNullability(expression2.getType(), (PsiModifierListOwner)target);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)expression2).resolveMethod();
            return method != null ? DfaPsiUtil.getElementNullability(expression2.getType(), (PsiModifierListOwner)method) : Nullability.UNKNOWN;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public static Nullability fromBoolean(@Nullable Boolean fact) {
        Nullability nullability = fact == null ? Nullability.UNKNOWN : (fact != false ? Nullability.NULLABLE : Nullability.NOT_NULL);
        if (nullability == null) {
            NullabilityUtil.$$$reportNull$$$0(0);
        }
        return nullability;
    }

    @Nullable
    public static Boolean toBoolean(@NotNull Nullability nullability) {
        if (nullability == null) {
            NullabilityUtil.$$$reportNull$$$0(1);
        }
        return nullability == Nullability.UNKNOWN ? null : Boolean.valueOf(nullability == Nullability.NULLABLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullabilityUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromBoolean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullabilityUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toBoolean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

