/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationSignature {
    public static final String ATTR_MUTATES = "mutates";
    static final MutationSignature UNKNOWN = new MutationSignature(false, new boolean[0]);
    static final MutationSignature PURE = new MutationSignature(false, new boolean[0]);
    public static final String INVALID_TOKEN_MESSAGE = "Invalid token: %s; supported are 'this', 'param1', 'param2', etc.";
    private final boolean myThis;
    private final boolean[] myParameters;

    private MutationSignature(boolean mutatesThis, boolean[] params) {
        this.myThis = mutatesThis;
        this.myParameters = params;
    }

    public boolean mutatesThis() {
        return this.myThis;
    }

    public boolean mutatesArg(int n) {
        return n < this.myParameters.length && this.myParameters[n];
    }

    public boolean preservesThis() {
        return this != UNKNOWN && !this.myThis;
    }

    public boolean preservesArg(int n) {
        return this != UNKNOWN && !this.mutatesArg(n);
    }

    public static MutationSignature parse(@NotNull String signature) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(0);
        }
        if (signature.trim().isEmpty()) {
            return UNKNOWN;
        }
        boolean mutatesThis = false;
        boolean[] args = new boolean[]{};
        for (String part : signature.split(",")) {
            if ((part = part.trim()).equals("this")) {
                mutatesThis = true;
                continue;
            }
            if (part.equals("param")) {
                if (args.length == 0) {
                    args = new boolean[]{true};
                    continue;
                }
                args[0] = true;
                continue;
            }
            if (part.startsWith("param")) {
                int argNum = Integer.parseInt(part.substring("param".length()));
                if (argNum < 0 || argNum > 255) {
                    throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
                }
                if (args.length < argNum) {
                    args = Arrays.copyOf(args, argNum);
                }
                args[argNum - 1] = true;
                continue;
            }
            if (part.isEmpty()) continue;
            throw new IllegalArgumentException(String.format(INVALID_TOKEN_MESSAGE, part));
        }
        return new MutationSignature(mutatesThis, args);
    }

    @Nullable
    public static String checkSignature(@NotNull String signature, @NotNull PsiMethod method) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(1);
        }
        if (method == null) {
            MutationSignature.$$$reportNull$$$0(2);
        }
        try {
            MutationSignature ms = MutationSignature.parse(signature);
            if (ms.myThis && method.hasModifierProperty("static")) {
                return "Static method cannot mutate 'this'";
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (ms.myParameters.length > parameters2.length) {
                return "Reference to parameter #" + ms.myParameters.length + " is invalid";
            }
            for (int i = 0; i < ms.myParameters.length; ++i) {
                PsiType type2;
                if (!ms.myParameters[i] || !ClassUtils.isImmutable(type2 = parameters2[i].getType())) continue;
                return "Parameter #" + (i + 1) + " has immutable type '" + type2.getPresentableText() + "'";
            }
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @NotNull
    public static MutationSignature fromMethod(@Nullable PsiMethod method) {
        if (method == null) {
            MutationSignature mutationSignature = UNKNOWN;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(3);
            }
            return mutationSignature;
        }
        MutationSignature mutationSignature = JavaMethodContractUtil.getContractInfo(method).getMutationSignature();
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(4);
        }
        return mutationSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkSignature";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

