/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.InferredAnnotationsManagerImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Mutability {
    UNKNOWN("unknown", null),
    MUTABLE("modifiable", null),
    UNMODIFIABLE("unmodifiable", "org.jetbrains.annotations.Unmodifiable"),
    UNMODIFIABLE_VIEW("unmodifiable view", "org.jetbrains.annotations.UnmodifiableView");

    @NotNull
    public static final String UNMODIFIABLE_ANNOTATION;
    @NotNull
    public static final String UNMODIFIABLE_VIEW_ANNOTATION;
    private final String myName;
    private final String myAnnotation;
    private final Key<CachedValue<PsiAnnotation>> myKey;

    private Mutability(String name, String annotation) {
        this.myName = name;
        this.myAnnotation = annotation;
        this.myKey = annotation == null ? null : Key.create((String)annotation);
    }

    public String toString() {
        return this.myName;
    }

    public boolean isUnmodifiable() {
        return this == UNMODIFIABLE || this == UNMODIFIABLE_VIEW;
    }

    @NotNull
    public Mutability union(Mutability other) {
        if (this == other) {
            Mutability mutability = this;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(0);
            }
            return mutability;
        }
        if (this == MUTABLE || other == MUTABLE) {
            Mutability mutability = MUTABLE;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(1);
            }
            return mutability;
        }
        if (this == UNKNOWN || other == UNKNOWN) {
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(2);
            }
            return mutability;
        }
        if (this == UNMODIFIABLE_VIEW || other == UNMODIFIABLE_VIEW) {
            Mutability mutability = UNMODIFIABLE_VIEW;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(3);
            }
            return mutability;
        }
        Mutability mutability = UNMODIFIABLE;
        if (mutability == null) {
            Mutability.$$$reportNull$$$0(4);
        }
        return mutability;
    }

    @Nullable
    public PsiAnnotation asAnnotation(Project project) {
        if (this.myAnnotation == null) {
            return null;
        }
        return (PsiAnnotation)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.myKey, () -> {
            PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@" + this.myAnnotation, null);
            InferredAnnotationsManagerImpl.markInferred(annotation);
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            return CachedValueProvider.Result.create((Object)annotation, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        }, false);
    }

    @NotNull
    public static Mutability getMutability(@NotNull PsiModifierListOwner owner) {
        PsiParameterList list;
        PsiMethod method;
        if (owner == null) {
            Mutability.$$$reportNull$$$0(5);
        }
        if (owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && (method = (PsiMethod)ObjectUtils.tryCast((Object)(list = (PsiParameterList)owner.getParent()).getParent(), PsiMethod.class)) != null) {
            int index = list.getParameterIndex((PsiParameter)owner);
            MutationSignature signature = MutationSignature.fromMethod(method);
            if (signature.mutatesArg(index)) {
                Mutability mutability = MUTABLE;
                if (mutability == null) {
                    Mutability.$$$reportNull$$$0(6);
                }
                return mutability;
            }
            if (signature.preservesArg(index) && PsiTreeUtil.findChildOfAnyType((PsiElement)method.getBody(), (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == null) {
                Mutability mutability = UNMODIFIABLE_VIEW;
                if (mutability == null) {
                    Mutability.$$$reportNull$$$0(7);
                }
                return mutability;
            }
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(8);
            }
            return mutability;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton(UNMODIFIABLE_ANNOTATION), (int)7)) {
            Mutability mutability = UNMODIFIABLE;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(9);
            }
            return mutability;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, Collections.singleton(UNMODIFIABLE_VIEW_ANNOTATION), (int)7)) {
            Mutability mutability = UNMODIFIABLE_VIEW;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(10);
            }
            return mutability;
        }
        if (owner instanceof PsiField && owner.hasModifierProperty("final")) {
            PsiField field = (PsiField)owner;
            List<PsiExpression> initializers = ContainerUtil.createMaybeSingletonList((Object)field.getInitializer());
            if (initializers.isEmpty() && !owner.hasModifierProperty("static")) {
                initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            }
            if ((initializers = StreamEx.of((Collection)initializers).flatMap(ExpressionUtils::nonStructuralChildren).toList()).isEmpty()) {
                Mutability mutability = UNKNOWN;
                if (mutability == null) {
                    Mutability.$$$reportNull$$$0(11);
                }
                return mutability;
            }
            Mutability mutability = UNMODIFIABLE;
            for (PsiExpression initializer : initializers) {
                Mutability newMutability = UNKNOWN;
                if (ClassUtils.isImmutable(initializer.getType())) {
                    newMutability = UNMODIFIABLE;
                } else if (initializer instanceof PsiMethodCallExpression) {
                    PsiMethod method2 = ((PsiMethodCallExpression)initializer).resolveMethod();
                    Mutability mutability2 = newMutability = method2 == null ? UNKNOWN : Mutability.getMutability((PsiModifierListOwner)method2);
                }
                if ((mutability = mutability.union(newMutability)).isUnmodifiable()) continue;
                break;
            }
            Mutability mutability3 = mutability;
            if (mutability3 == null) {
                Mutability.$$$reportNull$$$0(12);
            }
            return mutability3;
        }
        Mutability mutability = owner instanceof PsiMethodImpl ? JavaSourceInference.inferMutability((PsiMethodImpl)owner) : UNKNOWN;
        if (mutability == null) {
            Mutability.$$$reportNull$$$0(13);
        }
        return mutability;
    }

    static {
        UNMODIFIABLE_ANNOTATION = Mutability.UNMODIFIABLE.myAnnotation;
        UNMODIFIABLE_VIEW_ANNOTATION = Mutability.UNMODIFIABLE_VIEW.myAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/Mutability";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/Mutability";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutability";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMutability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

