/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodContractUtil {
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();

    private JavaMethodContractUtil() {
    }

    @NotNull
    public static List<? extends MethodContract> getMethodCallContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        List<MethodContract> contracts2;
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(0);
        }
        List<MethodContract> list = !(contracts2 = HardcodedContracts.getHardcodedContracts(method, call)).isEmpty() ? contracts2 : JavaMethodContractUtil.getMethodContracts(method);
        if (list == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<StandardMethodContract> getMethodContracts(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(2);
        }
        List<StandardMethodContract> list = JavaMethodContractUtil.getContractInfo(method).getContracts();
        if (list == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static boolean hasExplicitContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(4);
        }
        return JavaMethodContractUtil.getContractInfo(method).isExplicit();
    }

    @NotNull
    static ContractInfo getContractInfo(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(5);
        }
        ContractInfo contractInfo = (ContractInfo)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                JavaMethodContractUtil.$$$reportNull$$$0(9);
            }
            PsiAnnotation contractAnno = JavaMethodContractUtil.findContractAnnotation(method);
            ContractInfo info = ContractInfo.EMPTY;
            if (contractAnno != null) {
                String text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, null);
                List<StandardMethodContract> contracts2 = Collections.emptyList();
                if (text2 != null) {
                    try {
                        int paramCount = method.getParameterList().getParametersCount();
                        List<StandardMethodContract> collection = StandardMethodContract.parseContract(text2);
                        if (collection.stream().allMatch(c -> c.getParameterCount() == paramCount)) {
                            contracts2 = collection;
                        }
                    }
                    catch (StandardMethodContract.ParseException paramCount) {
                        // empty catch block
                    }
                }
                boolean pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)contractAnno, (String)"pure"));
                MutationSignature mutationSignature = MutationSignature.UNKNOWN;
                if (pure) {
                    mutationSignature = MutationSignature.PURE;
                } else {
                    String mutationText = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, (String)"mutates");
                    if (mutationText != null) {
                        try {
                            mutationSignature = MutationSignature.parse(mutationText);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                boolean explicit = !AnnotationUtil.isInferredAnnotation((PsiAnnotation)contractAnno);
                info = new ContractInfo(contracts2, pure, explicit, mutationSignature);
            }
            return CachedValueProvider.Result.create((Object)info, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (contractInfo == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(6);
        }
        return contractInfo;
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(7);
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
    }

    public static boolean isPure(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodContractUtil.$$$reportNull$$$0(8);
        }
        return JavaMethodContractUtil.getContractInfo(method).myPure;
    }

    @Nullable
    public static ContractReturnValue getNonFailingReturnValue(List<? extends MethodContract> contracts2) {
        ArrayList<ContractValue> failConditions = new ArrayList<ContractValue>();
        for (MethodContract methodContract : contracts2) {
            List<ContractValue> conditions = methodContract.getConditions();
            if (conditions.isEmpty() || conditions.stream().allMatch(c -> failConditions.stream().anyMatch(c::isExclusive))) {
                return methodContract.getReturnValue();
            }
            if (!methodContract.getReturnValue().isFail()) break;
            if (conditions.size() != 1) continue;
            failConditions.add(conditions.get(0));
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiExpression findReturnedValue(@Nullable PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, call);
        ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
        if (returnValue == null) {
            return null;
        }
        if (returnValue.equals(ContractReturnValue.returnThis())) {
            return ExpressionUtils.getQualifierOrThis(call.getMethodExpression());
        }
        if (returnValue instanceof ContractReturnValue.ParameterReturnValue) {
            int number = ((ContractReturnValue.ParameterReturnValue)returnValue).getParameterNumber();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length <= number) {
                return null;
            }
            if (args.length == number + 1 && MethodCallUtils.isVarArgCall(call)) {
                return null;
            }
            return args[number];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodCallContracts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodContracts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCallContracts";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodContracts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitContractAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContractInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findContractAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPure";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContractInfo$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ContractInfo {
        static final ContractInfo EMPTY = new ContractInfo(Collections.emptyList(), false, false, MutationSignature.UNKNOWN);
        @NotNull
        private final List<StandardMethodContract> myContracts;
        private final boolean myPure;
        private final boolean myExplicit;
        @NotNull
        private final MutationSignature myMutationSignature;

        ContractInfo(@NotNull List<StandardMethodContract> contracts2, boolean pure, boolean explicit, @NotNull MutationSignature signature) {
            if (contracts2 == null) {
                ContractInfo.$$$reportNull$$$0(0);
            }
            if (signature == null) {
                ContractInfo.$$$reportNull$$$0(1);
            }
            this.myContracts = contracts2;
            this.myPure = pure;
            this.myExplicit = explicit;
            this.myMutationSignature = signature;
        }

        @NotNull
        List<StandardMethodContract> getContracts() {
            List<StandardMethodContract> list = this.myContracts;
            if (list == null) {
                ContractInfo.$$$reportNull$$$0(2);
            }
            return list;
        }

        boolean isPure() {
            return this.myPure;
        }

        boolean isExplicit() {
            return this.myExplicit;
        }

        @NotNull
        MutationSignature getMutationSignature() {
            MutationSignature mutationSignature = this.myMutationSignature;
            if (mutationSignature == null) {
                ContractInfo.$$$reportNull$$$0(3);
            }
            return mutationSignature;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contracts";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil$ContractInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/JavaMethodContractUtil$ContractInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContracts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMutationSignature";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

