/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DereferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ObjectOfInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class InstructionVisitor {
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        DfaValue dest = memState.pop();
        memState.push(dest);
        this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dest, memState);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void flushArrayOnUnknownAssignment(AssignInstruction instruction, DfaValueFactory factory, DfaValue dest, DfaMemoryState memState) {
        PsiExpression array;
        DfaValue value2;
        if (dest instanceof DfaVariableValue) {
            return;
        }
        PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)instruction.getLExpression()), PsiArrayAccessExpression.class);
        if (arrayAccess != null && (value2 = factory.createValue(array = arrayAccess.getArrayExpression())) instanceof DfaVariableValue) {
            for (DfaVariableValue qualified : ((DfaVariableValue)value2).getDependentVariables()) {
                if (!qualified.isFlushableByCalls()) continue;
                memState.flushVariable(qualified);
            }
        }
    }

    public DfaInstructionState[] visitCheckNotNull(CheckNotNullInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @NotNull
    public DfaInstructionState[] visitControlTransfer(@NotNull ControlTransferInstruction controlTransferInstruction, @NotNull DataFlowRunner runner, @NotNull DfaMemoryState state) {
        if (controlTransferInstruction == null) {
            InstructionVisitor.$$$reportNull$$$0(0);
        }
        if (runner == null) {
            InstructionVisitor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            InstructionVisitor.$$$reportNull$$$0(2);
        }
        DfaInstructionState[] dfaInstructionStateArray = controlTransferInstruction.getTransfer().dispatch(state, runner).toArray(DfaInstructionState.EMPTY_ARRAY);
        if (dfaInstructionStateArray == null) {
            InstructionVisitor.$$$reportNull$$$0(3);
        }
        return dfaInstructionStateArray;
    }

    public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    public DfaInstructionState[] visitEscapeInstruction(EscapeInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    protected static DfaInstructionState[] nextInstruction(Instruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState)};
    }

    public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return this.visitBinop(instruction, runner, memState);
    }

    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        memState.pop();
        memState.push(DfaUnknownValue.getInstance());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitObjectOfInstruction(ObjectOfInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        DfaValue value2 = state.pop();
        DfaConstValue constant = value2 instanceof DfaConstValue ? (DfaConstValue)value2 : (value2 instanceof DfaVariableValue ? state.getConstantValue((DfaVariableValue)value2) : null);
        PsiType type2 = constant == null ? null : (PsiType)ObjectUtils.tryCast((Object)constant.getValue(), PsiType.class);
        state.push(runner.getFactory().createTypeValue(type2, Nullability.NOT_NULL));
        return InstructionVisitor.nextInstruction(instruction, runner, state);
    }

    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitLambdaExpression(LambdaInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitConditionalGoto(ConditionalGotoInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue condTrue;
        DfaValue condFalse;
        DfaValue cond = memState.pop();
        if (instruction.isNegated()) {
            condFalse = cond;
            condTrue = cond.createNegated();
        } else {
            condTrue = cond;
            condFalse = cond.createNegated();
        }
        if (condTrue == runner.getFactory().getConstFactory().getTrue()) {
            InstructionVisitor.markBranchReachable(instruction, true);
            return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getOffset()), memState)};
        }
        if (condFalse == runner.getFactory().getConstFactory().getTrue()) {
            InstructionVisitor.markBranchReachable(instruction, false);
            return InstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>(2);
        DfaMemoryState elseState = memState.createCopy();
        if (memState.applyCondition(condTrue)) {
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getOffset()), memState));
            InstructionVisitor.markBranchReachable(instruction, true);
        }
        if (elseState.applyCondition(condFalse)) {
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), elseState));
            InstructionVisitor.markBranchReachable(instruction, false);
        }
        return result.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private static void markBranchReachable(ConditionalGotoInstruction instruction, boolean isTrueBranch) {
        if (isTrueBranch ^ instruction.isNegated()) {
            instruction.setTrueReachable();
        } else {
            instruction.setFalseReachable();
        }
    }

    public DfaInstructionState[] visitFieldReference(DereferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitFlushVariable(FlushVariableInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.flushVariable(instruction.getVariable());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitFlushFields(FlushFieldsInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.flushFields();
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        for (int i = instruction.getArgCount(); i > 0; --i) {
            memState.pop();
        }
        memState.pop();
        memState.push(DfaUnknownValue.getInstance());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitCast(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return this.visitMethodCall(instruction, runner, memState);
    }

    public DfaInstructionState[] visitNot(NotInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue = memState.pop();
        dfaValue = dfaValue.createNegated();
        memState.push(dfaValue);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(instruction.getValue());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        memState.pop();
        memState.push(instruction.getValue());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitEmptyInstruction(EmptyInstruction instruction, DataFlowRunner runner, DfaMemoryState before) {
        return InstructionVisitor.nextInstruction(instruction, runner, before);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlTransferInstruction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/InstructionVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/InstructionVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "visitControlTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitControlTransfer";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

