/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.ValuableDataFlowRunner;
import com.intellij.codeInspection.dataFlow.inference.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Collection<PsiExpression> getCachedVariableValues(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Collection concatenations;
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        if (codeBlock == null) {
            return Collections.emptyList();
        }
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> value2 = DfaUtil.getCachedPlaceResults(codeBlock);
        if (value2 == null) {
            return null;
        }
        ValuableInstructionVisitor.PlaceResult placeResult = value2.get(context);
        Collection collection = concatenations = placeResult == null ? null : placeResult.myValues.get((Object)variable);
        if (concatenations != null) {
            return ContainerUtil.map((Collection)concatenations, DfaUtil::concatenateExpressions);
        }
        return Collections.emptyList();
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    private static Map<PsiElement, ValuableInstructionVisitor.PlaceResult> getCachedPlaceResults(@NotNull PsiElement codeBlock) {
        if (codeBlock == null) {
            DfaUtil.$$$reportNull$$$0(0);
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)codeBlock, () -> {
            ValuableInstructionVisitor visitor;
            RunnerResult runnerResult;
            if (codeBlock == null) {
                DfaUtil.$$$reportNull$$$0(22);
            }
            return CachedValueProvider.Result.create((runnerResult = new ValuableDataFlowRunner().analyzeMethod(codeBlock, visitor = new ValuableInstructionVisitor())) == RunnerResult.OK ? visitor.myResults : null, (Object[])new Object[]{codeBlock});
        });
    }

    @Deprecated
    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Nullness nullness = Nullness.fromNullability(DfaUtil.checkNullability(variable, context));
        if (nullness == null) {
            DfaUtil.$$$reportNull$$$0(1);
        }
        return nullness;
    }

    @NotNull
    public static Nullability checkNullability(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Nullability nullability = DfaUtil.tryCheckNullability(variable, context, null);
        Nullability nullability2 = nullability != null ? nullability : Nullability.UNKNOWN;
        if (nullability2 == null) {
            DfaUtil.$$$reportNull$$$0(2);
        }
        return nullability2;
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Nullability tryCheckNullability(@Nullable PsiVariable variable, @Nullable PsiElement context, @Nullable PsiElement outerBlock) {
        ValuableInstructionVisitor.PlaceResult placeResult;
        if (variable == null || context == null) {
            return null;
        }
        PsiElement codeBlock = outerBlock == null ? DfaPsiUtil.getEnclosingCodeBlock(variable, context) : outerBlock;
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> results = codeBlock == null ? null : DfaUtil.getCachedPlaceResults(codeBlock);
        ValuableInstructionVisitor.PlaceResult placeResult2 = placeResult = results == null ? null : results.get(context);
        if (placeResult == null) {
            return null;
        }
        if (placeResult.myNulls.contains(variable) && !placeResult.myNotNulls.contains(variable)) {
            return Nullability.NULLABLE;
        }
        if (placeResult.myNotNulls.contains(variable) && !placeResult.myNulls.contains(variable)) {
            return Nullability.NOT_NULL;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public static Collection<PsiExpression> getPossibleInitializationElements(@NotNull PsiElement qualifierExpression2) {
        if (qualifierExpression2 == null) {
            DfaUtil.$$$reportNull$$$0(3);
        }
        if (qualifierExpression2 instanceof PsiMethodCallExpression) {
            List<PsiMethodCallExpression> list = Collections.singletonList((PsiMethodCallExpression)qualifierExpression2);
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (!(targetElement instanceof PsiVariable)) {
                List<PsiExpression> list = Collections.emptyList();
                if (list == null) {
                    DfaUtil.$$$reportNull$$$0(5);
                }
                return list;
            }
            Collection<PsiExpression> variableValues = DfaUtil.getCachedVariableValues((PsiVariable)targetElement, qualifierExpression2);
            if (variableValues == null || variableValues.isEmpty()) {
                Collection<PsiExpression> collection = DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false, qualifierExpression2);
                if (collection == null) {
                    DfaUtil.$$$reportNull$$$0(6);
                }
                return collection;
            }
            Collection<PsiExpression> collection = variableValues;
            if (collection == null) {
                DfaUtil.$$$reportNull$$$0(7);
            }
            return collection;
        }
        if (qualifierExpression2 instanceof PsiLiteralExpression) {
            List<PsiLiteralExpression> list = Collections.singletonList((PsiLiteralExpression)qualifierExpression2);
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<PsiExpression> list = Collections.emptyList();
        if (list == null) {
            DfaUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    static PsiElement getClosureInside(Instruction instruction) {
        if (instruction instanceof MethodCallInstruction) {
            PsiCall anchor = ((MethodCallInstruction)instruction).getCallExpression();
            if (anchor instanceof PsiNewExpression) {
                return ((PsiNewExpression)anchor).getAnonymousClass();
            }
        } else {
            PsiElement anchor;
            if (instruction instanceof LambdaInstruction) {
                return ((LambdaInstruction)instruction).getLambdaExpression();
            }
            if (instruction instanceof EmptyInstruction && (anchor = ((EmptyInstruction)instruction).getAnchor()) instanceof PsiClass) {
                return anchor;
            }
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static Nullness inferMethodNullity(PsiMethod method) {
        Nullness nullness = Nullness.fromNullability(DfaUtil.inferMethodNullability(method));
        if (nullness == null) {
            DfaUtil.$$$reportNull$$$0(10);
        }
        return nullness;
    }

    @NotNull
    public static Nullability inferMethodNullability(PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || PsiUtil.resolveClassInType((PsiType)method.getReturnType()) == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaUtil.$$$reportNull$$$0(11);
            }
            return nullability;
        }
        Nullability nullability = DfaUtil.inferBlockNullability((PsiElement)body2, InferenceFromSourceUtil.suppressNullable(method));
        if (nullability == null) {
            DfaUtil.$$$reportNull$$$0(12);
        }
        return nullability;
    }

    @NotNull
    public static Nullability inferLambdaNullability(PsiLambdaExpression lambda2) {
        PsiElement body2 = lambda2.getBody();
        if (body2 == null || LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2) == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                DfaUtil.$$$reportNull$$$0(13);
            }
            return nullability;
        }
        Nullability nullability = DfaUtil.inferBlockNullability(body2, false);
        if (nullability == null) {
            DfaUtil.$$$reportNull$$$0(14);
        }
        return nullability;
    }

    @NotNull
    private static Nullability inferBlockNullability(final PsiElement body2, boolean suppressNullable) {
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner();
        final AtomicBoolean hasNulls = new AtomicBoolean();
        final AtomicBoolean hasNotNulls = new AtomicBoolean();
        final AtomicBoolean hasUnknowns = new AtomicBoolean();
        RunnerResult rc = dfaRunner.analyzeMethod(body2, new StandardInstructionVisitor(){

            @Override
            public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                if (PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)instruction.getReturn(), (boolean)false)) {
                    DfaValue returned = memState.peek();
                    if (memState.isNull(returned)) {
                        hasNulls.set(true);
                    } else if (memState.isNotNull(returned)) {
                        hasNotNulls.set(true);
                    } else {
                        hasUnknowns.set(true);
                    }
                }
                return super.visitCheckReturnValue(instruction, runner, memState);
            }
        });
        if (rc == RunnerResult.OK) {
            if (hasNulls.get()) {
                Nullability nullability = suppressNullable ? Nullability.UNKNOWN : Nullability.NULLABLE;
                if (nullability == null) {
                    DfaUtil.$$$reportNull$$$0(15);
                }
                return nullability;
            }
            if (hasNotNulls.get() && !hasUnknowns.get()) {
                Nullability nullability = Nullability.NOT_NULL;
                if (nullability == null) {
                    DfaUtil.$$$reportNull$$$0(16);
                }
                return nullability;
            }
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            DfaUtil.$$$reportNull$$$0(17);
        }
        return nullability;
    }

    static DfaValue getPossiblyNonInitializedValue(@NotNull DfaValueFactory factory, @NotNull PsiField target, @NotNull PsiElement context) {
        if (factory == null) {
            DfaUtil.$$$reportNull$$$0(18);
        }
        if (target == null) {
            DfaUtil.$$$reportNull$$$0(19);
        }
        if (context == null) {
            DfaUtil.$$$reportNull$$$0(20);
        }
        if (target.getType() instanceof PsiPrimitiveType) {
            return null;
        }
        PsiMethod placeMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (placeMethod == null) {
            return null;
        }
        PsiClass placeClass = placeMethod.getContainingClass();
        if (placeClass == null || placeClass != target.getContainingClass()) {
            return null;
        }
        if (!placeMethod.hasModifierProperty("static") && target.hasModifierProperty("static")) {
            return null;
        }
        if (DfaUtil.getAccessOffset(placeMethod) >= DfaUtil.getWriteOffset(target)) {
            return null;
        }
        return factory.createTypeValue(target.getType(), Nullability.NULLABLE);
    }

    private static int getWriteOffset(PsiField target) {
        boolean isFinal = target.hasModifierProperty("final");
        int offset = Integer.MAX_VALUE;
        if (target.getInitializer() != null) {
            offset = target.getInitializer().getTextRange().getStartOffset();
            if (isFinal) {
                return offset;
            }
        }
        PsiClass aClass = Objects.requireNonNull(target.getContainingClass());
        PsiClassInitializer[] initializers = aClass.getInitializers();
        Predicate<PsiElement> writesToTarget = element -> !PsiTreeUtil.processElements((PsiElement)element, e -> !(e instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)e)) || !ExpressionUtils.isReferenceTo((PsiExpression)e, (PsiVariable)target));
        Predicate<PsiElement> hasSideEffectCall = element -> !PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiMethodCallExpression.class).stream().map(PsiCall::resolveMethod).allMatch(method -> method != null && JavaMethodContractUtil.isPure(method));
        for (PsiClassInitializer psiClassInitializer : initializers) {
            if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static")) continue;
            if (!isFinal && hasSideEffectCall.test((PsiElement)psiClassInitializer)) {
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
            if (!writesToTarget.test((PsiElement)psiClassInitializer)) continue;
            offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
            if (!isFinal) break;
            return offset;
        }
        if (!isFinal) {
            for (PsiClassInitializer psiClassInitializer : aClass.getFields()) {
                if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static") || !hasSideEffectCall.test((PsiElement)psiClassInitializer.getInitializer()) && !writesToTarget.test((PsiElement)psiClassInitializer)) continue;
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
        }
        return offset;
    }

    private static int getAccessOffset(PsiMethod referrer) {
        PsiClass aClass = Objects.requireNonNull(referrer.getContainingClass());
        boolean isStatic = referrer.hasModifierProperty("static");
        for (PsiField field : aClass.getFields()) {
            Predicate<PsiExpression> callToMethod;
            PsiExpression initializer;
            if (field.hasModifierProperty("static") != isStatic || !ExpressionUtils.isMatchingChildAlwaysExecuted(initializer = field.getInitializer(), callToMethod = e -> {
                if (!(e instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                return call.getMethodExpression().isReferenceTo((PsiElement)referrer) && (isStatic || ExpressionUtil.isEffectivelyUnqualified(call.getMethodExpression()));
            })) continue;
            return field.getTextRange().getStartOffset();
        }
        return Integer.MAX_VALUE;
    }

    public static boolean hasInitializationHacks(@NotNull PsiField field) {
        PsiClass containingClass;
        if (field == null) {
            DfaUtil.$$$reportNull$$$0(21);
        }
        return (containingClass = field.getContainingClass()) != null && System.class.getName().equals(containingClass.getQualifiedName());
    }

    public static boolean ignoreInitializer(PsiVariable variable) {
        PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
        return initializer != null && variable instanceof PsiField && variable.hasModifierProperty("final") && variable.getType().equals(PsiType.BOOLEAN) && (ExpressionUtils.isLiteral((PsiElement)initializer, Boolean.TRUE) || ExpressionUtils.isLiteral((PsiElement)initializer, Boolean.FALSE));
    }

    static boolean isEffectivelyUnqualified(DfaVariableValue variableValue) {
        return variableValue.getQualifier() == null || variableValue.getQualifier().getSource() instanceof DfaExpressionFactory.ThisSource;
    }

    public static boolean hasImplicitImpureSuperCall(PsiClass aClass, PsiMethod constructor) {
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return false;
        }
        PsiElement superCtor = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)constructor, constructor.getProject(), superClass);
        if (!(superCtor instanceof PsiMethod)) {
            return false;
        }
        return !JavaMethodContractUtil.isPure((PsiMethod)superCtor);
    }

    @Nullable
    static PsiElement getDataflowContext(PsiExpression expression2) {
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class);
        if (member instanceof PsiField || member instanceof PsiClassInitializer) {
            return member.getContainingClass();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).isConstructor() ? member.getContainingClass() : ((PsiMethod)member).getBody();
        }
        return null;
    }

    @Nullable
    public static Boolean evaluateCondition(@Nullable PsiExpression condition2) {
        if ((condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)) == null || !PsiType.BOOLEAN.equals((Object)condition2.getType())) {
            return null;
        }
        Object o = ExpressionUtils.computeConstantExpression(condition2);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (!(condition2 instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)condition2;
        PsiElement context = DfaUtil.getDataflowContext(condition2);
        if (context == null) {
            return null;
        }
        class MyVisitor
        extends StandardInstructionVisitor {
            boolean myTrueReachable = false;
            boolean myFalseReachable = false;
            final /* synthetic */ PsiBinaryExpression val$binOp;

            MyVisitor(PsiBinaryExpression psiBinaryExpression) {
                this.val$binOp = psiBinaryExpression;
            }

            @Override
            public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                DfaInstructionState[] states = super.visitBinop(instruction, runner, memState);
                if (instruction.getPsiAnchor() == this.val$binOp) {
                    this.myTrueReachable |= instruction.isTrueReachable();
                    this.myFalseReachable |= instruction.isFalseReachable();
                    if (this.myTrueReachable && this.myFalseReachable) {
                        runner.cancel();
                    }
                }
                return states;
            }
        }
        MyVisitor visitor = new MyVisitor(binOp);
        if (new DataFlowRunner().analyzeMethodRecursively(context, visitor) == RunnerResult.OK && visitor.myTrueReachable != visitor.myFalseReachable) {
            return visitor.myTrueReachable;
        }
        return null;
    }

    private static PsiExpression concatenateExpressions(FList<PsiExpression> concatenation) {
        if (concatenation.size() == 1) {
            return (PsiExpression)concatenation.getHead();
        }
        String text2 = StringUtil.join((Collection)ContainerUtil.reverse(new ArrayList<PsiExpression>((Collection<PsiExpression>)concatenation)), PsiElement::getText, (String)"+");
        try {
            return JavaPsiFacade.getElementFactory((Project)((PsiExpression)concatenation.getHead()).getProject()).createExpressionFromText(text2, (PsiElement)concatenation.getHead());
        }
        catch (IncorrectOperationException e) {
            return (PsiExpression)concatenation.getHead();
        }
    }

    public static boolean isNaN(Object value2) {
        if (value2 instanceof Double && ((Double)value2).isNaN()) {
            return true;
        }
        return value2 instanceof Float && ((Float)value2).isNaN();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNullness";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNullability";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleInitializationElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodNullity";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodNullability";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "inferLambdaNullability";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "inferBlockNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPlaceResults";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleInitializationElements";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPossiblyNonInitializedValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasInitializationHacks";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCachedPlaceResults$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ValuableInstructionVisitor
    extends StandardInstructionVisitor {
        final Map<PsiElement, PlaceResult> myResults = ContainerUtil.newHashMap();

        private ValuableInstructionVisitor() {
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression place = instruction.getPlace();
            if (place != null) {
                PsiModifierListOwner element;
                PlaceResult result = this.myResults.computeIfAbsent((PsiElement)place, __ -> new PlaceResult());
                ((ValuableDataFlowRunner.MyDfaMemoryState)memState).forVariableStates((variableValue, value2) -> {
                    PsiModifierListOwner element;
                    ValuableDataFlowRunner.ValuableDfaVariableState state = (ValuableDataFlowRunner.ValuableDfaVariableState)value2;
                    FList<PsiExpression> concatenation = state.myConcatenation;
                    if (!concatenation.isEmpty() && DfaUtil.isEffectivelyUnqualified(variableValue) && (element = variableValue.getPsiVariable()) instanceof PsiVariable) {
                        result.myValues.put((Object)((PsiVariable)element), concatenation);
                    }
                });
                DfaValue value3 = instruction.getValue();
                if (value3 instanceof DfaVariableValue && DfaUtil.isEffectivelyUnqualified((DfaVariableValue)value3) && (element = ((DfaVariableValue)value3).getPsiVariable()) instanceof PsiVariable) {
                    if (memState.isNotNull(value3)) {
                        result.myNotNulls.add((PsiVariable)element);
                    }
                    if (memState.isNull(value3)) {
                        result.myNulls.add((PsiVariable)element);
                    }
                }
            }
            return super.visitPush(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState _memState) {
            Instruction nextInstruction = runner.getInstruction(instruction.getIndex() + 1);
            ValuableDataFlowRunner.MyDfaMemoryState memState = (ValuableDataFlowRunner.MyDfaMemoryState)_memState;
            DfaValue dfaSource = memState.pop();
            DfaValue dfaDest = memState.pop();
            if (dfaDest instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)dfaDest;
                PsiExpression rightValue = instruction.getRExpression();
                PsiElement parent = rightValue == null ? null : rightValue.getParent();
                IElementType type2 = parent instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)parent).getOperationTokenType() : JavaTokenType.EQ;
                FList<PsiExpression> prevValue = ((ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState((DfaVariableValue)var)).myConcatenation;
                memState.setVarValue(var, dfaSource);
                ValuableDataFlowRunner.ValuableDfaVariableState curState = (ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState(var);
                FList curValue = curState.myConcatenation;
                FList nextValue = type2 == JavaTokenType.PLUSEQ && !prevValue.isEmpty() ? prevValue.prepend((Object)rightValue) : (curValue.isEmpty() && rightValue != null ? curValue.prepend((Object)rightValue) : curValue);
                memState.setVariableState(var, curState.withExpression((FList<PsiExpression>)nextValue));
            }
            memState.push(dfaDest);
            return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
        }

        static class PlaceResult {
            final MultiValuesMap<PsiVariable, FList<PsiExpression>> myValues = new MultiValuesMap(true);
            final Set<PsiVariable> myNulls = new THashSet();
            final Set<PsiVariable> myNotNulls = new THashSet();

            PlaceResult() {
            }
        }
    }
}

