/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableSource;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaFactType<T>
extends Key<T> {
    private static final List<DfaFactType<?>> ourFactTypes = new ArrayList();
    public static final DfaFactType<Boolean> CAN_BE_NULL = new DfaFactType<Boolean>("Nullability"){

        @Override
        @NotNull
        public String toString(@NotNull Boolean fact) {
            if (fact == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = fact != false ? "Nullable" : "NotNull";
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull Boolean fact, @Nullable PsiType type2) {
            if (fact == null) {
                1.$$$reportNull$$$0(2);
            }
            if (type2 instanceof PsiPrimitiveType) {
                if ("" == null) {
                    1.$$$reportNull$$$0(3);
                }
                return "";
            }
            String string = fact != false ? "nullable" : "non-null";
            if (string == null) {
                1.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        boolean isSuper(@Nullable Boolean superFact, @Nullable Boolean subFact) {
            return superFact == null && Boolean.FALSE.equals(subFact) || super.isSuper(superFact, subFact);
        }

        @Override
        @Nullable
        Boolean intersectFacts(@NotNull Boolean left, @NotNull Boolean right) {
            if (left == null) {
                1.$$$reportNull$$$0(5);
            }
            if (right == null) {
                1.$$$reportNull$$$0(6);
            }
            if (Boolean.FALSE.equals(left) || Boolean.FALSE.equals(right)) {
                return Boolean.FALSE;
            }
            return super.intersectFacts(left, right);
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value2) {
            DfaFactMapValue factValue;
            if (value2 instanceof DfaConstValue) {
                return ((DfaConstValue)value2).getValue() == null;
            }
            if (value2 instanceof DfaBoxedValue || value2 instanceof DfaUnboxedValue) {
                return false;
            }
            if (value2 instanceof DfaFactMapValue && ((factValue = (DfaFactMapValue)value2).get(OPTIONAL_PRESENCE) != null || factValue.get(RANGE) != null)) {
                return false;
            }
            return (Boolean)super.fromDfaValue(value2);
        }

        @Override
        @Nullable
        Boolean calcFromVariable(@NotNull DfaVariableValue value2) {
            if (value2 == null) {
                1.$$$reportNull$$$0(7);
            }
            return NullabilityUtil.calcCanBeNull(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectFacts";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<Mutability> MUTABILITY = new DfaFactType<Mutability>("Mutability"){

        @Override
        boolean isUnknown(@NotNull Mutability fact) {
            if (fact == null) {
                2.$$$reportNull$$$0(0);
            }
            return fact == Mutability.UNKNOWN;
        }

        @Override
        @NotNull
        Mutability unionFacts(@NotNull Mutability left, @NotNull Mutability right) {
            if (left == null) {
                2.$$$reportNull$$$0(1);
            }
            if (right == null) {
                2.$$$reportNull$$$0(2);
            }
            Mutability mutability = left.union(right);
            if (mutability == null) {
                2.$$$reportNull$$$0(3);
            }
            return mutability;
        }

        @Override
        @NotNull
        Mutability calcFromVariable(@NotNull DfaVariableValue value2) {
            PsiModifierListOwner variable;
            if (value2 == null) {
                2.$$$reportNull$$$0(4);
            }
            Mutability mutability = (variable = value2.getPsiVariable()) == null ? Mutability.UNKNOWN : Mutability.getMutability(variable);
            if (mutability == null) {
                2.$$$reportNull$$$0(5);
            }
            return mutability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unionFacts";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcFromVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "unionFacts";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<Boolean> OPTIONAL_PRESENCE = new DfaFactType<Boolean>("Optional"){

        @Override
        @NotNull
        public String toString(@NotNull Boolean fact) {
            if (fact == null) {
                3.$$$reportNull$$$0(0);
            }
            String string = fact != false ? "present Optional" : "absent Optional";
            if (string == null) {
                3.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<LongRangeSet> RANGE = new DfaFactType<LongRangeSet>("Range"){

        @Override
        boolean isSuper(@Nullable LongRangeSet superFact, @Nullable LongRangeSet subFact) {
            return superFact == null || subFact != null && superFact.contains(subFact);
        }

        @Override
        boolean isUnknown(@NotNull LongRangeSet fact) {
            if (fact == null) {
                4.$$$reportNull$$$0(0);
            }
            return LongRangeSet.all().equals(fact);
        }

        @Override
        @Nullable
        LongRangeSet fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaVariableValue) {
                return this.calcFromVariable((DfaVariableValue)value2);
            }
            return LongRangeSet.fromDfaValue(value2);
        }

        @Override
        @Nullable
        LongRangeSet calcFromVariable(@NotNull DfaVariableValue var) {
            DfaVariableSource source;
            if (var == null) {
                4.$$$reportNull$$$0(1);
            }
            if ((source = var.getSource()) instanceof SpecialField) {
                return ((SpecialField)source).getRange();
            }
            LongRangeSet fromType = LongRangeSet.fromType(var.getVariableType());
            return fromType == null ? null : LongRangeSet.fromPsiElement(var.getPsiVariable()).intersect(fromType);
        }

        @Override
        @Nullable
        LongRangeSet unionFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            if (left == null) {
                4.$$$reportNull$$$0(2);
            }
            if (right == null) {
                4.$$$reportNull$$$0(3);
            }
            return left.union(right);
        }

        @Override
        @Nullable
        LongRangeSet intersectFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            LongRangeSet intersection;
            if (left == null) {
                4.$$$reportNull$$$0(4);
            }
            if (right == null) {
                4.$$$reportNull$$$0(5);
            }
            return (intersection = left.intersect(right)).isEmpty() ? null : intersection;
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull LongRangeSet fact, @Nullable PsiType type2) {
            LongRangeSet fromType;
            if (fact == null) {
                4.$$$reportNull$$$0(6);
            }
            if (fact.equals(fromType = LongRangeSet.fromType(type2))) {
                if ("" == null) {
                    4.$$$reportNull$$$0(7);
                }
                return "";
            }
            String string = fact.toString();
            if (string == null) {
                4.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$4";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "calcFromVariable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "unionFacts";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectFacts";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<TypeConstraint> TYPE_CONSTRAINT = new DfaFactType<TypeConstraint>("Constraints"){

        @Override
        boolean isSuper(@Nullable TypeConstraint superFact, @Nullable TypeConstraint subFact) {
            return superFact == null || subFact != null && superFact.isSuperStateOf(subFact);
        }

        @Override
        boolean isUnknown(@NotNull TypeConstraint fact) {
            if (fact == null) {
                5.$$$reportNull$$$0(0);
            }
            return fact.equals(TypeConstraint.EMPTY);
        }

        @Override
        @Nullable
        TypeConstraint intersectFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                5.$$$reportNull$$$0(1);
            }
            if (right == null) {
                5.$$$reportNull$$$0(2);
            }
            for (DfaPsiType type2 : right.getInstanceofValues()) {
                if ((left = left.withInstanceofValue(type2)) != null) continue;
                return null;
            }
            for (DfaPsiType type2 : right.getNotInstanceofValues()) {
                if ((left = left.withNotInstanceofValue(type2)) != null) continue;
                return null;
            }
            return left;
        }

        @Override
        @Nullable
        TypeConstraint unionFacts(@NotNull TypeConstraint left, @NotNull TypeConstraint right) {
            if (left == null) {
                5.$$$reportNull$$$0(3);
            }
            if (right == null) {
                5.$$$reportNull$$$0(4);
            }
            return left.union(right);
        }

        @Override
        @NotNull
        public String getPresentationText(@NotNull TypeConstraint fact, @Nullable PsiType type2) {
            if (fact == null) {
                5.$$$reportNull$$$0(5);
            }
            String string = fact.getPresentationText(type2);
            if (string == null) {
                5.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$5";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectFacts";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "unionFacts";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentationText";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final DfaFactType<Boolean> LOCALITY = new DfaFactType<Boolean>("Locality"){

        @Override
        boolean isUnknown(@NotNull Boolean fact) {
            if (fact == null) {
                6.$$$reportNull$$$0(0);
            }
            return fact == false;
        }

        @Override
        @NotNull
        public String toString(@NotNull Boolean fact) {
            if (fact == null) {
                6.$$$reportNull$$$0(1);
            }
            String string = fact != false ? "local object" : "";
            if (string == null) {
                6.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType$6";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$6";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnknown";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final String myName;

    private DfaFactType(String name) {
        super("DfaFactType: " + name);
        this.myName = name;
        ourFactTypes.add(this);
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    T fromDfaValue(DfaValue value2) {
        return value2 instanceof DfaFactMapValue ? (T)((DfaFactMapValue)value2).get(this) : null;
    }

    @Nullable
    T calcFromVariable(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            DfaFactType.$$$reportNull$$$0(0);
        }
        return null;
    }

    boolean isSuper(@Nullable T superFact, @Nullable T subFact) {
        return Objects.equals(superFact, subFact);
    }

    boolean isUnknown(@NotNull T fact) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Nullable
    T intersectFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(2);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(3);
        }
        return (T)(left.equals(right) ? left : null);
    }

    @Nullable
    T unionFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(4);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(5);
        }
        return (T)(left.equals(right) ? left : null);
    }

    @NotNull
    public String toString(@NotNull T fact) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(6);
        }
        String string = fact.toString();
        if (string == null) {
            DfaFactType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getPresentationText(@NotNull T fact, @Nullable PsiType type2) {
        if (fact == null) {
            DfaFactType.$$$reportNull$$$0(8);
        }
        String string = this.toString(fact);
        if (string == null) {
            DfaFactType.$$$reportNull$$$0(9);
        }
        return string;
    }

    static List<DfaFactType<?>> getTypes() {
        return Collections.unmodifiableList(ourFactTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcFromVariable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "intersectFacts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unionFacts";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

