/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContractReturnValue {
    private static final int PARAMETER_ORDINAL_BASE = 10;
    private static final int MAX_SUPPORTED_PARAMETER = 100;
    private static final Function<PsiMethod, String> NOT_CONSTRUCTOR = method -> method.isConstructor() ? "not applicable for constructor" : null;
    private static final Function<PsiMethod, String> NOT_STATIC = method -> method.hasModifierProperty("static") ? "not applicable for static method" : null;
    private static final Function<PsiMethod, String> NOT_PRIMITIVE_RETURN = method -> {
        PsiType returnType = method.getReturnType();
        return returnType instanceof PsiPrimitiveType ? "not applicable for primitive return type '" + returnType.getPresentableText() + "'" : null;
    };
    private static final Function<PsiMethod, String> BOOLEAN_RETURN = method -> PsiType.BOOLEAN.equals((Object)method.getReturnType()) ? null : "method return type must be 'boolean'";
    @NotNull
    private final String myName;
    private final int myOrdinal;
    private static final ContractReturnValue ANY_VALUE = new ContractReturnValue("_", 0){

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.of(NOT_CONSTRUCTOR);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return defaultValue;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return true;
        }
    };
    private static final ContractReturnValue FAIL_VALUE = new ContractReturnValue("fail", 5){

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.empty();
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return factory.getConstFactory().getContractFail();
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return false;
        }
    };
    private static final ContractReturnValue NULL_VALUE = new ContractReturnValue("null", 1){

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return factory.getConstFactory().getNull();
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNotNull(value2);
        }
    };
    private static final ContractReturnValue NOT_NULL_VALUE = new ContractReturnValue("!null", 2){

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            if (defaultValue instanceof DfaVariableValue) {
                callState.myMemoryState.forceVariableFact((DfaVariableValue)defaultValue, DfaFactType.CAN_BE_NULL, false);
                return defaultValue;
            }
            return factory.withFact(defaultValue, DfaFactType.CAN_BE_NULL, false);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNull(value2);
        }
    };
    private static final ContractReturnValue NEW_VALUE = new ContractReturnValue("new", 6){

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            if (defaultValue instanceof DfaVariableValue) {
                callState.myMemoryState.forceVariableFact((DfaVariableValue)defaultValue, DfaFactType.CAN_BE_NULL, false);
                return defaultValue;
            }
            DfaValue value2 = factory.withFact(defaultValue, DfaFactType.CAN_BE_NULL, false);
            if (callState.myCallArguments.myPure) {
                boolean unmodifiableView;
                boolean bl = unmodifiableView = value2 instanceof DfaFactMapValue && ((DfaFactMapValue)value2).get(DfaFactType.MUTABILITY) == Mutability.UNMODIFIABLE_VIEW;
                if (!unmodifiableView) {
                    value2 = factory.withFact(value2, DfaFactType.LOCALITY, true);
                }
            }
            return value2;
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNull(value2);
        }
    };
    private static final ContractReturnValue THIS_VALUE = new ContractReturnValue("this", 7){

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_STATIC, NOT_PRIMITIVE_RETURN, method -> {
                PsiClass aClass;
                PsiType returnType = method.getReturnType();
                if (returnType instanceof PsiClassType && (aClass = method.getContainingClass()) != null && JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(aClass).isConvertibleFrom(returnType)) {
                    return null;
                }
                return "method return type should be compatible with method containing class";
            });
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            DfaValue qualifier = callState.myCallArguments.myQualifier;
            if (qualifier != null && qualifier != DfaUnknownValue.getInstance()) {
                return 6.merge(defaultValue, qualifier, callState.myMemoryState);
            }
            return factory.withFact(defaultValue, DfaFactType.CAN_BE_NULL, false);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNull(value2);
        }
    };

    private ContractReturnValue(@NotNull String name, int ordinal) {
        if (name == null) {
            ContractReturnValue.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myOrdinal = ordinal;
    }

    public int hashCode() {
        return this.myOrdinal;
    }

    public String toString() {
        return this.myName;
    }

    public final String getMethodCompatibilityProblem(PsiMethod method) {
        return this.validators().map(fn -> (String)fn.apply(method)).filter(Objects::nonNull).findFirst().map(("Contract return value '" + this + "': ")::concat).orElse(null);
    }

    public final boolean isMethodCompatible(PsiMethod method) {
        return this.validators().map(fn -> (String)fn.apply(method)).allMatch(Objects::isNull);
    }

    abstract Stream<Function<PsiMethod, String>> validators();

    public ContractReturnValue intersect(ContractReturnValue other) {
        if (this.equals(other) || other == ANY_VALUE) {
            return this;
        }
        if (this == ANY_VALUE) {
            return other;
        }
        if (this.isNotNull() && other.isNotNull()) {
            return NOT_NULL_VALUE;
        }
        return FAIL_VALUE;
    }

    static DfaValue merge(DfaValue defaultValue, DfaValue newValue, DfaMemoryState memState) {
        if (defaultValue == null || defaultValue == DfaUnknownValue.getInstance()) {
            return newValue;
        }
        if (newValue == null || newValue == DfaUnknownValue.getInstance()) {
            return defaultValue;
        }
        if (defaultValue instanceof DfaFactMapValue) {
            DfaFactMap intersection;
            DfaFactMap defaultFacts = ((DfaFactMapValue)defaultValue).getFacts();
            if (newValue instanceof DfaFactMapValue && (intersection = defaultFacts.intersect(((DfaFactMapValue)newValue).getFacts())) != null) {
                return defaultValue.getFactory().getFactFactory().createValue(intersection);
            }
            if (newValue instanceof DfaVariableValue) {
                defaultFacts.facts(Pair::create).forEach(fact -> memState.applyFact(newValue, (DfaFactType)((Object)((Object)fact.getFirst())), fact.getSecond()));
            }
        }
        return newValue;
    }

    public abstract DfaValue getDfaValue(DfaValueFactory var1, DfaValue var2, DfaCallState var3);

    public abstract boolean isValueCompatible(DfaMemoryState var1, DfaValue var2);

    public int ordinal() {
        return this.myOrdinal;
    }

    public boolean isNotNull() {
        return false;
    }

    public boolean isNull() {
        return this == NULL_VALUE;
    }

    public boolean isFail() {
        return this == FAIL_VALUE;
    }

    public boolean isBoolean() {
        return this instanceof BooleanReturnValue;
    }

    @NotNull
    public static ContractReturnValue valueOf(int ordinal) {
        switch (ordinal) {
            case 0: 
            case 1: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnNull();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(1);
                }
                return contractReturnValue;
            }
            case 2: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnNotNull();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(2);
                }
                return contractReturnValue;
            }
            case 3: {
                BooleanReturnValue booleanReturnValue = ContractReturnValue.returnTrue();
                if (booleanReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(3);
                }
                return booleanReturnValue;
            }
            case 4: {
                BooleanReturnValue booleanReturnValue = ContractReturnValue.returnFalse();
                if (booleanReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(4);
                }
                return booleanReturnValue;
            }
            case 5: {
                ContractReturnValue contractReturnValue = ContractReturnValue.fail();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(5);
                }
                return contractReturnValue;
            }
            case 6: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnNew();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(6);
                }
                return contractReturnValue;
            }
            case 7: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnThis();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(7);
                }
                return contractReturnValue;
            }
        }
        if (ordinal >= 10 && ordinal <= 110) {
            ContractReturnValue contractReturnValue = ContractReturnValue.returnParameter(ordinal - 10);
            if (contractReturnValue == null) {
                ContractReturnValue.$$$reportNull$$$0(8);
            }
            return contractReturnValue;
        }
        ContractReturnValue contractReturnValue = ContractReturnValue.returnAny();
        if (contractReturnValue == null) {
            ContractReturnValue.$$$reportNull$$$0(9);
        }
        return contractReturnValue;
    }

    @Nullable
    public static ContractReturnValue valueOf(@NotNull String value2) {
        if (value2 == null) {
            ContractReturnValue.$$$reportNull$$$0(10);
        }
        switch (value2) {
            case "_": {
                return ContractReturnValue.returnAny();
            }
            case "fail": {
                return ContractReturnValue.fail();
            }
            case "true": {
                return ContractReturnValue.returnTrue();
            }
            case "false": {
                return ContractReturnValue.returnFalse();
            }
            case "null": {
                return ContractReturnValue.returnNull();
            }
            case "!null": {
                return ContractReturnValue.returnNotNull();
            }
            case "new": {
                return ContractReturnValue.returnNew();
            }
            case "this": {
                return ContractReturnValue.returnThis();
            }
        }
        if (value2.startsWith("param")) {
            String suffix = value2.substring("param".length());
            try {
                int paramNumber = Integer.parseInt(suffix) - 1;
                if (paramNumber >= 0 && paramNumber <= 100) {
                    return new ParameterReturnValue(paramNumber);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ContractReturnValue returnAny() {
        return ANY_VALUE;
    }

    public static ContractReturnValue fail() {
        return FAIL_VALUE;
    }

    public static BooleanReturnValue returnBoolean(boolean value2) {
        return value2 ? ContractReturnValue.returnTrue() : ContractReturnValue.returnFalse();
    }

    public static BooleanReturnValue returnTrue() {
        return BooleanReturnValue.TRUE_VALUE;
    }

    public static BooleanReturnValue returnFalse() {
        return BooleanReturnValue.FALSE_VALUE;
    }

    public static ContractReturnValue returnNull() {
        return NULL_VALUE;
    }

    public static ContractReturnValue returnNotNull() {
        return NOT_NULL_VALUE;
    }

    public static ContractReturnValue returnNew() {
        return NEW_VALUE;
    }

    public static ContractReturnValue returnThis() {
        return THIS_VALUE;
    }

    public static ContractReturnValue returnParameter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative parameter: " + n);
        }
        if (n > 100) {
            return ANY_VALUE;
        }
        return new ParameterReturnValue(n);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractReturnValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractReturnValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "valueOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "valueOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ParameterReturnValue
    extends ContractReturnValue {
        private final int myParamNumber;

        public ParameterReturnValue(int n) {
            super("param" + (n + 1), n + 10);
            this.myParamNumber = n;
        }

        public int getParameterNumber() {
            return this.myParamNumber;
        }

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.of(NOT_CONSTRUCTOR, method -> {
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length <= this.myParamNumber) {
                    return "not applicable for method which has " + parameters2.length + " parameter" + (parameters2.length == 1 ? "" : "s");
                }
                PsiType parameterType = parameters2[this.myParamNumber].getType();
                PsiType returnType = method.getReturnType();
                if (returnType != null && !returnType.isAssignableFrom(parameterType)) {
                    return "return type '" + returnType.getPresentableText() + "' must be assignable from parameter type '" + parameterType.getPresentableText() + "'";
                }
                return null;
            });
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ParameterReturnValue && ((ParameterReturnValue)obj).myParamNumber == this.myParamNumber;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            if (callState.myCallArguments.myArguments != null && callState.myCallArguments.myArguments.length > this.myParamNumber) {
                DfaValue argument = callState.myCallArguments.myArguments[this.myParamNumber];
                return ParameterReturnValue.merge(defaultValue, argument, callState.myMemoryState);
            }
            return defaultValue;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return true;
        }
    }

    public static final class BooleanReturnValue
    extends ContractReturnValue {
        static final BooleanReturnValue TRUE_VALUE = new BooleanReturnValue(true, 3);
        static final BooleanReturnValue FALSE_VALUE = new BooleanReturnValue(false, 4);
        private final boolean myValue;

        private BooleanReturnValue(boolean value2, int ordinal) {
            super(String.valueOf(value2), ordinal);
            this.myValue = value2;
        }

        public boolean getValue() {
            return this.myValue;
        }

        public BooleanReturnValue negate() {
            return this.myValue ? FALSE_VALUE : TRUE_VALUE;
        }

        @Override
        Stream<Function<PsiMethod, String>> validators() {
            return Stream.of(NOT_CONSTRUCTOR, BOOLEAN_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return factory.getBoolean(this.myValue);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            if (value2 instanceof DfaVariableValue) {
                value2 = state.getConstantValue((DfaVariableValue)value2);
            }
            if (value2 instanceof DfaConstValue) {
                Object constant = ((DfaConstValue)value2).getValue();
                return Boolean.valueOf(this.myValue).equals(constant);
            }
            return true;
        }
    }
}

