/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractChecker;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ContractInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiAnnotation annotation = JavaMethodContractUtil.findContractAnnotation(method);
                if (annotation == null || !ApplicationManager.getApplication().isInternal() && AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) {
                    return;
                }
                boolean ownContract = annotation.getOwner() == method.getModifierList();
                for (StandardMethodContract contract : JavaMethodContractUtil.getMethodContracts(method)) {
                    Map<PsiElement, String> errors = ContractChecker.checkContractClause(method, contract, ownContract);
                    for (Map.Entry<PsiElement, String> entry : errors.entrySet()) {
                        PsiElement element = entry.getKey();
                        holder.registerProblem(element, entry.getValue(), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                StandardMethodContract.ParseException error;
                if (!JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
                if (method == null) {
                    return;
                }
                String text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
                if (StringUtil.isNotEmpty((String)text2) && (error = ContractInspection.checkContract(method, text2)) != null) {
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue(null);
                    assert (value2 != null);
                    TextRange actualRange = null;
                    if (value2 instanceof PsiExpression && error.getRange() != null) {
                        actualRange = ExpressionUtils.findStringLiteralRange((PsiExpression)value2, error.getRange().getStartOffset(), error.getRange().getEndOffset());
                    }
                    holder.registerProblem((PsiElement)value2, actualRange, error.getMessage(), new LocalQuickFix[0]);
                }
                this.checkMutationContract(annotation, method);
            }

            private void checkMutationContract(PsiAnnotation annotation, PsiMethod method) {
                boolean pure;
                String error;
                String mutationContract = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"mutates");
                if (StringUtil.isNotEmpty((String)mutationContract) && (error = (pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure"))) ? "Pure method cannot have mutation contract" : MutationSignature.checkSignature(mutationContract, method)) != null) {
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue("mutates");
                    assert (value2 != null);
                    holder.registerProblem((PsiElement)value2, error, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            ContractInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable
    public static StandardMethodContract.ParseException checkContract(PsiMethod method, String text2) {
        List<StandardMethodContract> contracts2;
        try {
            contracts2 = StandardMethodContract.parseContract(text2);
        }
        catch (StandardMethodContract.ParseException e) {
            return e;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        int paramCount = parameters2.length;
        List possibleContracts = Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.returnAny()));
        for (int clauseIndex = 0; clauseIndex < contracts2.size(); ++clauseIndex) {
            StandardMethodContract contract = contracts2.get(clauseIndex);
            if (contract.getParameterCount() != paramCount) {
                return StandardMethodContract.ParseException.forClause("Method takes " + paramCount + " parameters, while contract clause '" + contract + "' expects " + contract.getParameterCount(), text2, clauseIndex);
            }
            block8: for (int i = 0; i < parameters2.length; ++i) {
                StandardMethodContract.ValueConstraint constraint = contract.getParameterConstraint(i);
                PsiType type2 = parameters2[i].getType();
                switch (constraint) {
                    case ANY_VALUE: {
                        continue block8;
                    }
                    case NULL_VALUE: 
                    case NOT_NULL_VALUE: {
                        if (!(type2 instanceof PsiPrimitiveType)) continue block8;
                        String message2 = "Contract clause '" + contract + "': parameter #" + (i + 1) + " has primitive type '" + type2.getPresentableText() + "'";
                        return StandardMethodContract.ParseException.forConstraint(message2, text2, clauseIndex, i);
                    }
                    case TRUE_VALUE: 
                    case FALSE_VALUE: {
                        if (PsiType.BOOLEAN.equals((Object)type2) || type2.equalsToText("java.lang.Boolean")) continue block8;
                        String message3 = "Contract clause '" + contract + "': parameter #" + (i + 1) + " has '" + type2.getPresentableText() + "' type (expected boolean)";
                        return StandardMethodContract.ParseException.forConstraint(message3, text2, clauseIndex, i);
                    }
                }
            }
            String problem = contract.getReturnValue().getMethodCompatibilityProblem(method);
            if (problem != null) {
                return StandardMethodContract.ParseException.forReturnValue(problem, text2, clauseIndex);
            }
            if (possibleContracts == null) continue;
            if (possibleContracts.isEmpty()) {
                return StandardMethodContract.ParseException.forClause("Contract clause '" + contract + "' is unreachable: previous contracts cover all possible cases", text2, clauseIndex);
            }
            if (StreamEx.of(possibleContracts).allMatch(c -> c.intersect(contract) == null)) {
                return StandardMethodContract.ParseException.forClause("Contract clause '" + contract + "' is never satisfied as its conditions are covered by previous contracts", text2, clauseIndex);
            }
            if ((possibleContracts = ((StreamEx)StreamEx.of(possibleContracts).flatMap(c -> c.excludeContract(contract)).limit(300L)).toList()).size() < 300) continue;
            possibleContracts = null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

