/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonDataflow {
    @Contract(value="null -> null")
    @Nullable
    private static DataflowResult runDFA(@Nullable PsiElement block) {
        if (block == null) {
            return null;
        }
        DataFlowRunner runner = new DataFlowRunner(false, block);
        CommonDataflowVisitor visitor = new CommonDataflowVisitor(runner);
        RunnerResult result = runner.analyzeMethodRecursively(block, visitor);
        if (result != RunnerResult.OK) {
            return null;
        }
        if (!(block instanceof PsiClass)) {
            return visitor.myResult;
        }
        DataflowResult dfr = visitor.myResult.copy();
        List states = visitor.myEndOfInitializerStates;
        for (PsiMethod method : ((PsiClass)block).getConstructors()) {
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) continue;
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall((PsiClass)block, method) ? Collections.singletonList(runner.createMemoryState()) : StreamEx.of((Collection)states).map(DfaMemoryState::createCopy).toList();
            if (runner.analyzeBlockRecursively((PsiElement)body2, initialStates, visitor) == RunnerResult.OK) {
                dfr = visitor.myResult.copy();
                continue;
            }
            visitor.myResult = dfr;
        }
        return dfr;
    }

    @Nullable
    public static DataflowResult getDataflowResult(PsiExpression context) {
        PsiElement body2 = DfaUtil.getDataflowContext(context);
        if (body2 == null) {
            return null;
        }
        return (DataflowResult)CachedValuesManager.getCachedValue((PsiElement)body2, () -> {
            DataflowResult result = CommonDataflow.runDFA(body2);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
        DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        if (result == null) {
            return null;
        }
        return result.getExpressionFact(PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), type2);
    }

    private static class CommonDataflowVisitor
    extends StandardInstructionVisitor {
        private DataflowResult myResult;
        private final DfaConstValue myFail;
        private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();

        public CommonDataflowVisitor(DataFlowRunner runner) {
            this.myFail = runner.getFactory().getConstFactory().getContractFail();
            this.myResult = new DataflowResult();
        }

        @Override
        public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
            if (!instruction.isStatic()) {
                this.myEndOfInitializerStates.add(state.createCopy());
            }
            return super.visitEndOfInitializer(instruction, runner, state);
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaInstructionState[] states = super.visitPush(instruction, runner, memState);
            PsiExpression place = instruction.getPlace();
            if (place != null && !instruction.isReferenceWrite()) {
                for (DfaInstructionState state : states) {
                    DfaMemoryState afterState = state.getMemoryState();
                    this.myResult.add(place, (DfaMemoryStateImpl)afterState, instruction.getValue());
                }
            }
            return states;
        }

        @Override
        public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaInstructionState[] states = super.visitArrayAccess(instruction, runner, memState);
            PsiArrayAccessExpression anchor = instruction.getExpression();
            for (DfaInstructionState state : states) {
                DfaMemoryState afterState = state.getMemoryState();
                this.myResult.add((PsiExpression)anchor, (DfaMemoryStateImpl)afterState, afterState.peek());
            }
            return states;
        }

        @Override
        public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaInstructionState[] states = super.visitBinop(instruction, runner, memState);
            PsiElement anchor = instruction.getPsiAnchor();
            if (anchor instanceof PsiExpression) {
                for (DfaInstructionState state : states) {
                    DfaMemoryState afterState = state.getMemoryState();
                    this.myResult.add((PsiExpression)anchor, (DfaMemoryStateImpl)afterState, afterState.peek());
                }
            }
            return states;
        }

        @Override
        @NotNull
        protected DfaCallArguments popCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, boolean contractOnly) {
            PsiExpression qualifier;
            DfaCallArguments arguments = super.popCall(instruction, runner, memState, contractOnly);
            PsiElement context = instruction.getContext();
            if (instruction.getMethodType() == MethodCallInstruction.MethodType.REGULAR_METHOD_CALL && context instanceof PsiMethodCallExpression && (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiMethodCallExpression)context).getMethodExpression().getQualifierExpression())) != null) {
                this.myResult.add(qualifier, (DfaMemoryStateImpl)memState, arguments.myQualifier);
            }
            DfaCallArguments dfaCallArguments = arguments;
            if (dfaCallArguments == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(0);
            }
            return dfaCallArguments;
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
            PsiExpression context = (PsiExpression)ObjectUtils.tryCast((Object)instruction.getContext(), PsiExpression.class);
            if (context != null && ExpressionUtils.getCallForQualifier(context) == null) {
                for (DfaInstructionState state : states) {
                    DfaValue value2 = state.getMemoryState().peek();
                    if (value2 == this.myFail) continue;
                    this.myResult.add(context, (DfaMemoryStateImpl)state.getMemoryState(), value2);
                }
            }
            return states;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CommonDataflow$CommonDataflowVisitor", "popCall"));
        }
    }

    public static class DataflowResult {
        private final Map<PsiExpression, DfaFactMap> myFacts = new HashMap<PsiExpression, DfaFactMap>();
        private final Set<PsiExpression> myUnknowns = new HashSet<PsiExpression>();

        DataflowResult copy() {
            DataflowResult copy = new DataflowResult();
            copy.myFacts.putAll(this.myFacts);
            return copy;
        }

        void add(PsiExpression expression2, DfaMemoryStateImpl memState, DfaValue value2) {
            DfaFactMap existing;
            if (memState.isUnknownState(value2)) {
                this.myUnknowns.add(expression2);
            }
            if ((existing = this.myFacts.get(expression2)) != DfaFactMap.EMPTY) {
                DfaFactMap newMap = memState.getFactMap(value2);
                if (!Boolean.FALSE.equals(newMap.get(DfaFactType.CAN_BE_NULL)) && memState.isNotNull(value2)) {
                    newMap = newMap.with(DfaFactType.CAN_BE_NULL, false);
                }
                this.myFacts.put(expression2, existing == null ? newMap : existing.union(newMap));
            }
        }

        public boolean expressionWasAnalyzed(PsiExpression expression2) {
            assert (!(expression2 instanceof PsiParenthesizedExpression));
            return this.myFacts.containsKey(expression2) && !this.myUnknowns.contains(expression2);
        }

        @Nullable
        public <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
            DfaFactMap map = this.myFacts.get(expression2);
            return map == null ? null : (T)map.get(type2);
        }

        @Nullable
        public DfaFactMap getAllFacts(PsiExpression expression2) {
            return this.myFacts.get(expression2);
        }
    }
}

