/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.FramelessAnalyzer;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LiteFramelessAnalyzer;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

final class ControlFlowBuilder
implements FramelessAnalyzer.EdgeCreator {
    final String className;
    final MethodNode methodNode;
    final TIntArrayList[] transitions;
    final Set<ControlFlowGraph.Edge> errorTransitions;
    final TIntIntHashMap npeTransitions;
    final FramelessAnalyzer myAnalyzer;
    private final boolean[] errors;
    private int edgeCount;

    ControlFlowBuilder(String className, MethodNode methodNode, boolean jsr) {
        this.myAnalyzer = jsr ? new FramelessAnalyzer(this) : new LiteFramelessAnalyzer(this);
        this.className = className;
        this.methodNode = methodNode;
        this.transitions = new TIntArrayList[methodNode.instructions.size()];
        this.errors = new boolean[methodNode.instructions.size()];
        for (int i = 0; i < this.transitions.length; ++i) {
            this.transitions[i] = new TIntArrayList();
        }
        this.errorTransitions = new HashSet<ControlFlowGraph.Edge>();
        this.npeTransitions = new TIntIntHashMap();
    }

    final ControlFlowGraph buildCFG() throws AnalyzerException {
        if ((this.methodNode.access & 0x500) == 0) {
            this.myAnalyzer.analyze(this.methodNode);
        }
        int[][] resultTransitions = new int[this.transitions.length][];
        for (int i = 0; i < resultTransitions.length; ++i) {
            resultTransitions[i] = this.transitions[i].toNativeArray();
        }
        return new ControlFlowGraph(this.className, this.methodNode, resultTransitions, this.edgeCount, this.errors, this.errorTransitions, this.npeTransitions);
    }

    @Override
    public final void newControlFlowEdge(int insn, int successor) {
        if (!this.transitions[insn].contains(successor)) {
            this.transitions[insn].add(successor);
            ++this.edgeCount;
        }
    }

    @Override
    public final boolean newControlFlowExceptionEdge(int insn, int successor, boolean npe) {
        if (!this.transitions[insn].contains(successor)) {
            this.transitions[insn].add(successor);
            ++this.edgeCount;
            ControlFlowGraph.Edge edge = new ControlFlowGraph.Edge(insn, successor);
            this.errorTransitions.add(edge);
            if (npe && !this.npeTransitions.containsKey(insn)) {
                this.npeTransitions.put(insn, successor);
            }
            this.errors[successor] = true;
        }
        return true;
    }
}

