/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInsight.InferredAnnotationsManagerImpl;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.EquationsLimitException;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ParameterAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Solver;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ProjectBytecodeAnalysis {
    private static final boolean SKIP_INDEX = false;
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.bytecodeAnalysis");
    public static final String NULLABLE_METHOD = "java.annotations.inference.nullable.method";
    public static final String NULLABLE_METHOD_TRANSITIVITY = "java.annotations.inference.nullable.method.transitivity";
    public static final int EQUATIONS_LIMIT = 1000;
    private final Project myProject;
    private final boolean nullableMethod;
    private final boolean nullableMethodTransitivity;
    private final EquationProvider<?> myEquationProvider;

    public static ProjectBytecodeAnalysis getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(0);
        }
        return (ProjectBytecodeAnalysis)ServiceManager.getService((Project)project, ProjectBytecodeAnalysis.class);
    }

    public ProjectBytecodeAnalysis(Project project) {
        this.myProject = project;
        this.myEquationProvider = new IndexedEquationProvider(this.myProject);
        this.nullableMethod = Registry.is((String)NULLABLE_METHOD);
        this.nullableMethodTransitivity = Registry.is((String)NULLABLE_METHOD_TRANSITIVITY);
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(1);
        }
        if (annotationFQN == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(2);
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            return null;
        }
        if (annotationFQN.equals("org.jetbrains.annotations.NotNull") || annotationFQN.equals("org.jetbrains.annotations.Nullable") || annotationFQN.equals(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            PsiAnnotation[] annotations2;
            for (PsiAnnotation annotation : annotations2 = this.findInferredAnnotations(listOwner)) {
                if (!annotationFQN.equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(3);
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(4);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)listOwner, () -> {
            if (listOwner == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(36);
            }
            return CachedValueProvider.Result.create((Object)this.collectInferredAnnotations(listOwner), (Object[])new Object[]{listOwner});
        });
        if (psiAnnotationArray == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    @NotNull
    private PsiAnnotation[] collectInferredAnnotations(PsiModifierListOwner listOwner) {
        block15: {
            block14: {
                EKey primaryKey;
                block13: {
                    block11: {
                        block12: {
                            VirtualFile file;
                            PsiFile psiFile = listOwner.getContainingFile();
                            VirtualFile virtualFile = file = psiFile == null ? null : psiFile.getVirtualFile();
                            if (file != null && ClassDataIndexer.isFileExcluded(file)) {
                                if (PsiAnnotation.EMPTY_ARRAY == null) {
                                    ProjectBytecodeAnalysis.$$$reportNull$$$0(6);
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            try {
                                MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
                                primaryKey = this.getKey(listOwner, md);
                                if (primaryKey != null) break block11;
                                if (PsiAnnotation.EMPTY_ARRAY != null) break block12;
                            }
                            catch (EquationsLimitException e) {
                                if (LOG.isDebugEnabled()) {
                                    String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false, (int)Integer.MAX_VALUE);
                                    LOG.debug("Too many equations for " + externalName);
                                }
                                if (PsiAnnotation.EMPTY_ARRAY == null) {
                                    ProjectBytecodeAnalysis.$$$reportNull$$$0(11);
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            ProjectBytecodeAnalysis.$$$reportNull$$$0(7);
                        }
                        return PsiAnnotation.EMPTY_ARRAY;
                    }
                    if (!(listOwner instanceof PsiMethod)) break block13;
                    ArrayList<EKey> allKeys = ProjectBytecodeAnalysis.collectMethodKeys((PsiMethod)listOwner, primaryKey);
                    MethodAnnotations methodAnnotations = this.loadMethodAnnotations((PsiMethod)listOwner, primaryKey, allKeys);
                    PsiAnnotation[] psiAnnotationArray = this.toPsi(primaryKey, methodAnnotations);
                    if (psiAnnotationArray == null) {
                        ProjectBytecodeAnalysis.$$$reportNull$$$0(8);
                    }
                    return psiAnnotationArray;
                }
                if (!(listOwner instanceof PsiParameter)) break block14;
                ParameterAnnotations parameterAnnotations = this.loadParameterAnnotations(primaryKey);
                PsiAnnotation[] psiAnnotationArray = this.toPsi(parameterAnnotations);
                if (psiAnnotationArray == null) {
                    ProjectBytecodeAnalysis.$$$reportNull$$$0(9);
                }
                return psiAnnotationArray;
            }
            if (PsiAnnotation.EMPTY_ARRAY != null) break block15;
            ProjectBytecodeAnalysis.$$$reportNull$$$0(10);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    private PsiAnnotation[] toPsi(EKey primaryKey, MethodAnnotations methodAnnotations) {
        PsiAnnotation psiAnnotation;
        boolean notNull = methodAnnotations.notNulls.contains(primaryKey);
        boolean nullable = methodAnnotations.nullables.contains(primaryKey);
        boolean pure = methodAnnotations.pures.contains(primaryKey);
        String contractValues = methodAnnotations.contractsValues.get(primaryKey);
        String contractPsiText = null;
        if (contractValues != null) {
            contractPsiText = pure ? "value=" + contractValues + ",pure=true" : contractValues;
        } else if (pure) {
            contractPsiText = "pure=true";
        }
        PsiAnnotation psiAnnotation2 = psiAnnotation = contractPsiText == null ? null : this.createContractAnnotation(contractPsiText);
        if (notNull && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(12);
            }
            return psiAnnotationArray;
        }
        if (nullable && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(13);
            }
            return psiAnnotationArray;
        }
        if (notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(14);
            }
            return psiAnnotationArray;
        }
        if (nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(15);
            }
            return psiAnnotationArray;
        }
        if (psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{psiAnnotation};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(16);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(17);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    private PsiAnnotation[] toPsi(ParameterAnnotations parameterAnnotations) {
        if (parameterAnnotations.notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(18);
            }
            return psiAnnotationArray;
        }
        if (parameterAnnotations.nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                ProjectBytecodeAnalysis.$$$reportNull$$$0(19);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(20);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation getNotNullAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@org.jetbrains.annotations.NotNull"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
    }

    public PsiAnnotation getNullableAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@org.jetbrains.annotations.Nullable"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
    }

    public PsiAnnotation createContractAnnotation(String contractValue) {
        Map cache = (Map)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(attrs -> this.createAnnotationFromText("@org.jetbrains.annotations.Contract(" + attrs + ")"));
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        });
        return (PsiAnnotation)cache.get(contractValue);
    }

    @Nullable
    public EKey getKey(@NotNull PsiModifierListOwner owner, MessageDigest md) {
        PsiElement gParent;
        PsiElement parent;
        if (owner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(owner instanceof PsiCompiledElement, (Object)owner);
        if (owner instanceof PsiMethod) {
            EKey key2 = BytecodeAnalysisConverter.psiKey((PsiMethod)owner, Direction.Out);
            return key2 == null ? null : this.myEquationProvider.adaptKey(key2, md);
        }
        if (owner instanceof PsiParameter && (parent = owner.getParent()) instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod) {
            int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)owner);
            EKey key3 = BytecodeAnalysisConverter.psiKey((PsiMethod)gParent, new Direction.In(index, false));
            return key3 == null ? null : this.myEquationProvider.adaptKey(key3, md);
        }
        return null;
    }

    public static ArrayList<EKey> collectMethodKeys(@NotNull PsiMethod method, EKey primaryKey) {
        if (method == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(22);
        }
        return BytecodeAnalysisConverter.mkInOutKeys(method, primaryKey);
    }

    private ParameterAnnotations loadParameterAnnotations(@NotNull EKey notNullKey) throws EquationsLimitException {
        if (notNullKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(23);
        }
        Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(notNullKey), notNullSolver);
        Map<EKey, Value> notNullSolutions = notNullSolver.solve();
        boolean notNull = Value.NotNull == notNullSolutions.get(notNullKey) || Value.NotNull == notNullSolutions.get(notNullKey.mkUnstable());
        Solver nullableSolver = new Solver(new ELattice<Value>(Value.Null, Value.Top), Value.Top);
        EKey nullableKey = new EKey(notNullKey.member, notNullKey.dirKey + 1, true, false);
        this.collectEquations(Collections.singletonList(nullableKey), nullableSolver);
        Map<EKey, Value> nullableSolutions = nullableSolver.solve();
        boolean nullable = Value.Null == nullableSolutions.get(nullableKey) || Value.Null == nullableSolutions.get(nullableKey.mkUnstable());
        return new ParameterAnnotations(notNull, nullable);
    }

    private MethodAnnotations loadMethodAnnotations(@NotNull PsiMethod owner, @NotNull EKey key2, ArrayList<EKey> allKeys) throws EquationsLimitException {
        if (owner == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(24);
        }
        if (key2 == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(25);
        }
        MethodAnnotations result = new MethodAnnotations();
        PuritySolver puritySolver = new PuritySolver();
        this.collectPurityEquations(key2.withDirection(Direction.Pure), puritySolver);
        Map<EKey, Effects> puritySolutions = puritySolver.solve();
        int arity = owner.getParameterList().getParametersCount();
        BytecodeAnalysisConverter.addEffectAnnotations(puritySolutions, result, key2, owner.isConstructor());
        EKey failureKey = key2.withDirection(Direction.Throw);
        Solver failureSolver = new Solver(new ELattice<Value>(Value.Fail, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(failureKey), failureSolver);
        if (failureSolver.solve().get(failureKey) == Value.Fail) {
            result.contractsValues.put(key2, StreamEx.constant((Object)"_", (long)arity).joining((CharSequence)",", (CharSequence)"\"", (CharSequence)"->fail\""));
        } else {
            Solver outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
            this.collectEquations(allKeys, outSolver);
            Map<EKey, Value> solutions = outSolver.solve();
            this.addMethodAnnotations(solutions, result, key2, arity);
        }
        if (this.nullableMethod) {
            Solver nullableMethodSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Null), Value.Bot);
            EKey nullableKey = key2.withDirection(Direction.NullableOut);
            if (this.nullableMethodTransitivity) {
                this.collectEquations(Collections.singletonList(nullableKey), nullableMethodSolver);
            } else {
                this.collectSingleEquation(nullableKey, nullableMethodSolver);
            }
            Map<EKey, Value> nullableSolutions = nullableMethodSolver.solve();
            if (nullableSolutions.get(nullableKey) == Value.Null || nullableSolutions.get(nullableKey.invertStability()) == Value.Null) {
                result.nullables.add(key2);
            }
        }
        return result;
    }

    private static EKey withStability(EKey key2, boolean stability) {
        return new EKey(key2.member, key2.dirKey, stability, false);
    }

    private void collectPurityEquations(EKey key2, PuritySolver puritySolver) throws EquationsLimitException {
        HashSet<EKey> queued = new HashSet<EKey>();
        ArrayDeque<EKey> queue = new ArrayDeque<EKey>();
        queue.push(key2);
        queued.add(key2);
        while (!queue.isEmpty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey curKey = (EKey)queue.pop();
            boolean stable = true;
            Effects combined = null;
            for (Equations equations : this.myEquationProvider.getEquations(curKey.member)) {
                stable &= equations.stable;
                Effects effects = (Effects)equations.find(curKey.getDirection()).orElseGet(() -> new Effects(DataValue.UnknownDataValue1, Effects.TOP_EFFECTS));
                combined = combined == null ? effects : combined.combine(effects);
            }
            if (combined == null) continue;
            combined.dependencies().filter(queued::add).forEach(queue::push);
            puritySolver.addEquation(ProjectBytecodeAnalysis.withStability(curKey, stable), combined);
        }
        puritySolver.addPlainFieldEquations(md -> true);
    }

    private void collectEquations(List<EKey> keys, Solver solver) throws EquationsLimitException {
        HashSet<EKey> queued = new HashSet<EKey>();
        Stack queue = new Stack();
        for (EKey key2 : keys) {
            queue.push((Object)key2);
            queued.add(key2);
        }
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey curKey = (EKey)queue.pop();
            for (Equations equations : this.myEquationProvider.getEquations(curKey.member)) {
                Result result = equations.find(curKey.getDirection()).orElseGet(solver::getUnknownResult);
                solver.addEquation(new Equation(ProjectBytecodeAnalysis.withStability(curKey, equations.stable), result));
                result.dependencies().filter(queued::add).forEach(arg_0 -> ((Stack)queue).push(arg_0));
            }
        }
    }

    private void collectSingleEquation(EKey curKey, Solver solver) {
        ProgressManager.checkCanceled();
        for (Equations equations : this.myEquationProvider.getEquations(curKey.member)) {
            Result result = equations.find(curKey.getDirection()).orElseGet(solver::getUnknownResult);
            solver.addEquation(new Equation(ProjectBytecodeAnalysis.withStability(curKey, equations.stable), result));
        }
    }

    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(26);
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)this.myProject).createAnnotationFromText(text2, null);
        InferredAnnotationsManagerImpl.markInferred(annotation);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(27);
        }
        return psiAnnotation;
    }

    BitSet findAlwaysNotNullParameters(@NotNull EKey methodKey, BitSet possiblyNotNullParameters) throws EquationsLimitException {
        if (methodKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(28);
        }
        BitSet alwaysNotNullParameters = new BitSet();
        if (possiblyNotNullParameters.cardinality() != 0) {
            List keys = IntStreamEx.of((BitSet)possiblyNotNullParameters).mapToObj(idx -> {
                if (methodKey == null) {
                    ProjectBytecodeAnalysis.$$$reportNull$$$0(35);
                }
                return methodKey.withDirection(new Direction.In(idx, false));
            }).toList();
            Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
            this.collectEquations(keys, notNullSolver);
            Map<EKey, Value> notNullSolutions = notNullSolver.solve();
            alwaysNotNullParameters = IntStreamEx.of((BitSet)possiblyNotNullParameters).filter(idx -> {
                EKey key2;
                if (methodKey == null) {
                    ProjectBytecodeAnalysis.$$$reportNull$$$0(34);
                }
                return notNullSolutions.get(key2 = methodKey.withDirection(new Direction.In(idx, false))) == Value.NotNull || notNullSolutions.get(key2.mkUnstable()) == Value.NotNull;
            }).toBitSet();
        }
        return alwaysNotNullParameters;
    }

    private void addMethodAnnotations(@NotNull Map<EKey, Value> solution, @NotNull MethodAnnotations methodAnnotations, @NotNull EKey methodKey, int arity) throws EquationsLimitException {
        String result;
        StandardMethodContract contract;
        if (solution == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(29);
        }
        if (methodAnnotations == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(30);
        }
        if (methodKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(31);
        }
        ArrayList<StandardMethodContract> contractClauses = new ArrayList<StandardMethodContract>();
        Set<EKey> notNulls = methodAnnotations.notNulls;
        Set<EKey> pures = methodAnnotations.pures;
        Map<EKey, String> contracts2 = methodAnnotations.contractsValues;
        ContractReturnValue fullReturnValue = methodAnnotations.returnValue.asContractReturnValue();
        for (Map.Entry<EKey, Value> entry : solution.entrySet()) {
            Value value2 = entry.getValue();
            if (value2 == Value.Top || value2 == Value.Bot || value2 == Value.Fail && !pures.contains(methodKey)) continue;
            EKey key2 = entry.getKey().mkStable();
            Direction direction = key2.getDirection();
            EKey baseKey = key2.mkBase();
            if (!methodKey.equals(baseKey)) continue;
            if (value2 == Value.NotNull && direction == Direction.Out) {
                notNulls.add(methodKey);
                continue;
            }
            if (value2 == Value.Pure && direction == Direction.Pure) {
                pures.add(methodKey);
                continue;
            }
            if (!(direction instanceof Direction.ParamValueBasedDirection)) continue;
            ContractReturnValue contractReturnValue = fullReturnValue.equals(ContractReturnValue.returnAny()) ? value2.toReturnValue() : fullReturnValue;
            contractClauses.add(ProjectBytecodeAnalysis.contractElement(arity, (Direction.ParamValueBasedDirection)direction, contractReturnValue));
        }
        Map partition = StreamEx.of(contractClauses).partitioningBy(c -> c.getReturnValue().isFail());
        List<StandardMethodContract> failingContracts = ProjectBytecodeAnalysis.squashContracts((List)partition.get(true));
        List<StandardMethodContract> nonFailingContracts = ProjectBytecodeAnalysis.squashContracts((List)partition.get(false));
        if (nonFailingContracts.size() == 1 && (contract = nonFailingContracts.get(0)).getReturnValue().equals(ContractReturnValue.returnNotNull()) && contract.isTrivial()) {
            nonFailingContracts = Collections.emptyList();
            notNulls.add(methodKey);
        }
        List allContracts = StreamEx.of((Object[])new List[]{failingContracts, nonFailingContracts}).toFlatList(Function.identity());
        this.removeConstraintFromNonNullParameter(methodKey, allContracts);
        if (allContracts.isEmpty() && !fullReturnValue.equals(ContractReturnValue.returnAny())) {
            allContracts.add(StandardMethodContract.trivialContract(arity, fullReturnValue));
        }
        if (notNulls.contains(methodKey)) {
            allContracts.removeIf(smc -> smc.getReturnValue().equals(ContractReturnValue.returnNotNull()));
        }
        if (!(result = ((StreamEx)((StreamEx)StreamEx.of((Collection)allContracts).sorted(Comparator.comparingInt(smc -> smc.getReturnValue().isFail() ? 0 : 1).thenComparing(MethodContract::toString))).map(Object::toString).distinct()).map(str -> str.replace(" ", "")).joining((CharSequence)";")).isEmpty()) {
            contracts2.put(methodKey, '\"' + result + '\"');
        }
    }

    private void removeConstraintFromNonNullParameter(@NotNull EKey methodKey, List<StandardMethodContract> allContracts) throws EquationsLimitException {
        BitSet possiblyNotNullParameters;
        BitSet alwaysNotNullParameters;
        if (methodKey == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(32);
        }
        if ((alwaysNotNullParameters = this.findAlwaysNotNullParameters(methodKey, possiblyNotNullParameters = StreamEx.of(allContracts).flatMapToInt(smc -> IntStreamEx.range((int)smc.getParameterCount()).filter(idx -> smc.getParameterConstraint(idx) == StandardMethodContract.ValueConstraint.NOT_NULL_VALUE)).toBitSet())).cardinality() != 0) {
            allContracts.replaceAll(smc -> {
                StandardMethodContract.ValueConstraint[] constraints = smc.getConstraints().toArray(new StandardMethodContract.ValueConstraint[0]);
                alwaysNotNullParameters.stream().forEach(idx -> {
                    constraints[idx] = StandardMethodContract.ValueConstraint.ANY_VALUE;
                });
                return new StandardMethodContract(constraints, smc.getReturnValue());
            });
        }
    }

    @NotNull
    private static List<StandardMethodContract> squashContracts(List<StandardMethodContract> contractClauses) {
        StandardMethodContract soleContract = StreamEx.ofPairs(contractClauses, (c1, c2) -> {
            if (c1.getReturnValue() != c2.getReturnValue()) {
                return null;
            }
            int idx = -1;
            for (int i = 0; i < c1.getParameterCount(); ++i) {
                StandardMethodContract.ValueConstraint left = c1.getParameterConstraint(i);
                StandardMethodContract.ValueConstraint right = c2.getParameterConstraint(i);
                if (left == StandardMethodContract.ValueConstraint.ANY_VALUE && right == StandardMethodContract.ValueConstraint.ANY_VALUE) continue;
                if (idx >= 0 || !right.canBeNegated() || left != right.negate()) {
                    return null;
                }
                idx = i;
            }
            return c1;
        }).nonNull().findFirst().orElse(null);
        if (soleContract != null) {
            contractClauses = Collections.singletonList(StandardMethodContract.trivialContract(soleContract.getParameterCount(), soleContract.getReturnValue()));
        }
        List<StandardMethodContract> list = contractClauses;
        if (list == null) {
            ProjectBytecodeAnalysis.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static StandardMethodContract contractElement(int arity, Direction.ParamValueBasedDirection inOut, ContractReturnValue returnValue) {
        StandardMethodContract.ValueConstraint[] constraints = new StandardMethodContract.ValueConstraint[arity];
        Arrays.fill((Object[])constraints, (Object)StandardMethodContract.ValueConstraint.ANY_VALUE);
        constraints[inOut.paramIndex] = inOut.inValue.toValueConstraint();
        return new StandardMethodContract(constraints, returnValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullKey";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodKey";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "solution";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInferredAnnotations";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInferredAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsi";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "squashContracts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 33: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodKeys";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadParameterAnnotations";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadMethodAnnotations";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findAlwaysNotNullParameters";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addMethodAnnotations";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeConstraintFromNonNullParameter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findAlwaysNotNullParameters$8";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findAlwaysNotNullParameters$7";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findInferredAnnotations$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class IndexedEquationProvider
    extends EquationProvider<HMember> {
        IndexedEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key2, MessageDigest messageDigest) {
            if (key2 == null) {
                IndexedEquationProvider.$$$reportNull$$$0(0);
            }
            return key2.hashed(messageDigest);
        }

        @Override
        public List<Equations> getEquations(MemberDescriptor method) {
            HMember key2 = method.hashed(null);
            return this.myEquationCache.computeIfAbsent(key2, m -> BytecodeAnalysisIndex.getEquations(ProjectScope.getLibrariesScope((Project)this.myProject), m));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$IndexedEquationProvider", "adaptKey"));
        }
    }

    static class PlainEquationProvider
    extends EquationProvider<Member> {
        PlainEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key2, MessageDigest messageDigest) {
            if (key2 == null) {
                PlainEquationProvider.$$$reportNull$$$0(0);
            }
            assert (key2.member instanceof Member);
            return key2;
        }

        @Override
        public List<Equations> getEquations(MemberDescriptor memberDescriptor) {
            assert (memberDescriptor instanceof Member);
            Member method = (Member)memberDescriptor;
            List<Equations> equations = (List<Equations>)this.myEquationCache.get(method);
            return equations == null ? this.loadEquations(method) : equations;
        }

        private VirtualFile findClassFile(String internalClassName) {
            String packageName = StringUtil.getPackageName((String)internalClassName, (char)'/').replace('/', '.');
            String className = StringUtil.getShortName((String)internalClassName, (char)'/');
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            if (aPackage == null) {
                PsiModifierListOwner compiledClass;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(StringUtil.getQualifiedName((String)packageName, (String)className), GlobalSearchScope.allScope((Project)this.myProject));
                if (psiClass != null && (compiledClass = PsiUtil.preferCompiledElement((PsiModifierListOwner)psiClass)) instanceof ClsClassImpl) {
                    return compiledClass.getContainingFile().getVirtualFile();
                }
                return null;
            }
            String classFileName = className + ".class";
            for (PsiDirectory directory : aPackage.getDirectories()) {
                VirtualFile file = directory.getVirtualFile().findChild(classFileName);
                if (file == null || ClassDataIndexer.isFileExcluded(file)) continue;
                return file;
            }
            return null;
        }

        private List<Equations> loadEquations(Member method) {
            VirtualFile file = this.findClassFile(method.internalClassName);
            if (file == null) {
                return Collections.emptyList();
            }
            try {
                Map<EKey, Equations> map = ClassDataIndexer.processClass(new ClassReader(file.contentsToByteArray(false)), file.getPresentableUrl());
                Map groups = EntryStream.of(map).mapKeys(key2 -> (Member)key2.member).grouping();
                this.myEquationCache.putAll(groups);
                return groups.getOrDefault(method, Collections.emptyList());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$PlainEquationProvider", "adaptKey"));
        }
    }

    static abstract class EquationProvider<T extends MemberDescriptor> {
        final Map<T, List<Equations>> myEquationCache = ContainerUtil.createConcurrentSoftValueMap();
        final Project myProject;

        EquationProvider(Project project) {
            this.myProject = project;
            project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, this.myEquationCache::clear);
        }

        abstract EKey adaptKey(@NotNull EKey var1, MessageDigest var2);

        abstract List<Equations> getEquations(MemberDescriptor var1);
    }
}

