/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

class HardCodedPurity {
    static final boolean AGGRESSIVE_HARDCODED_PURITY = Registry.is((String)"java.annotations.inference.aggressive.hardcoded.purity", (boolean)true);
    private static final Set<Couple<String>> ownedFields = ContainerUtil.set((Object[])new Couple[]{new Couple((Object)"java/lang/AbstractStringBuilder", (Object)"value")});
    private static final Set<Member> thisChangingMethods = ContainerUtil.set((Object[])new Member[]{new Member("java/lang/Throwable", "fillInStackTrace", "()Ljava/lang/Throwable;")});
    private static final Set<Member> pureMethods = ContainerUtil.set((Object[])new Member[]{new Member("java/lang/Throwable", "toString", "()Ljava/lang/String;"), new Member("java/lang/StringUTF16", "newBytesFor", "(I)[B"), new Member("java/lang/StringBuilder", "toString", "()Ljava/lang/String;"), new Member("java/lang/StringBuffer", "toString", "()Ljava/lang/String;"), new Member("java/lang/Object", "getClass", "()Ljava/lang/Class;"), new Member("java/lang/Class", "getComponentType", "()Ljava/lang/Class;"), new Member("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;"), new Member("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;[I)Ljava/lang/Object;"), new Member("java/lang/Float", "floatToRawIntBits", "(F)I"), new Member("java/lang/Float", "intBitsToFloat", "(I)F"), new Member("java/lang/Double", "doubleToRawLongBits", "(D)J"), new Member("java/lang/Double", "longBitsToDouble", "(J)D")});
    private static final Map<Member, Set<EffectQuantum>> solutions = new HashMap<Member, Set<EffectQuantum>>();
    private static final Set<EffectQuantum> thisChange = Collections.singleton(EffectQuantum.ThisChangeQuantum);

    HardCodedPurity() {
    }

    static HardCodedPurity getInstance() {
        return AGGRESSIVE_HARDCODED_PURITY ? new AggressiveHardCodedPurity() : new HardCodedPurity();
    }

    Effects getHardCodedSolution(Member method) {
        if (this.isThisChangingMethod(method)) {
            return new Effects(this.isBuilderChainCall(method) ? DataValue.ThisDataValue : DataValue.UnknownDataValue1, thisChange);
        }
        if (this.isPureMethod(method)) {
            return new Effects(this.getReturnValueForPureMethod(method), Collections.emptySet());
        }
        Set<EffectQuantum> effects = solutions.get(method);
        return effects == null ? null : new Effects(DataValue.UnknownDataValue1, effects);
    }

    boolean isThisChangingMethod(Member method) {
        return this.isBuilderChainCall(method) || thisChangingMethods.contains(method);
    }

    boolean isBuilderChainCall(Member method) {
        return (method.internalClassName.equals("java/lang/StringBuilder") || method.internalClassName.equals("java/lang/StringBuffer")) && method.methodName.startsWith("append");
    }

    DataValue getReturnValueForPureMethod(Member method) {
        String type2 = StringUtil.substringAfter((String)method.methodDesc, (String)")");
        if (type2 != null && (type2.length() == 1 || type2.equals("Ljava/lang/String;") || type2.equals("Ljava/lang/Class;"))) {
            return DataValue.UnknownDataValue1;
        }
        return DataValue.LocalDataValue;
    }

    boolean isPureMethod(Member method) {
        if (pureMethods.contains(method)) {
            return true;
        }
        return method.internalClassName.startsWith("[") && method.methodName.equals("clone") && method.methodDesc.equals("()Ljava/lang/Object;");
    }

    boolean isOwnedField(FieldInsnNode fieldInsn) {
        return ownedFields.contains(new Couple((Object)fieldInsn.owner, (Object)fieldInsn.name));
    }

    static {
        solutions.put(new Member("java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V"), Collections.singleton(new EffectQuantum.ParamChangeQuantum(2)));
        solutions.put(new Member("java/lang/Object", "hashCode", "()I"), Collections.emptySet());
    }

    static class AggressiveHardCodedPurity
    extends HardCodedPurity {
        static final Set<String> ITERABLES = ContainerUtil.set((Object[])new String[]{"java/lang/Iterable", "java/util/Collection", "java/util/List", "java/util/Set", "java/util/ArrayList", "java/util/HashSet", "java/util/AbstractList", "java/util/AbstractSet", "java/util/TreeSet"});

        AggressiveHardCodedPurity() {
        }

        @Override
        boolean isThisChangingMethod(Member method) {
            if (method.methodName.equals("next") && method.methodDesc.startsWith("()") && method.internalClassName.equals("java/util/Iterator")) {
                return true;
            }
            return super.isThisChangingMethod(method);
        }

        @Override
        boolean isPureMethod(Member method) {
            if (method.methodName.equals("toString") && method.methodDesc.equals("()Ljava/lang/String;")) {
                return true;
            }
            if (method.methodName.equals("iterator") && method.methodDesc.equals("()Ljava/util/Iterator;") && ITERABLES.contains(method.internalClassName)) {
                return true;
            }
            if (method.methodName.equals("hasNext") && method.methodDesc.equals("()Z") && method.internalClassName.equals("java/util/Iterator")) {
                return true;
            }
            return super.isPureMethod(method);
        }
    }
}

