/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.booleanIsAlwaysInverted;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.booleanIsAlwaysInverted.BooleanMethodIsAlwaysInvertedLocalInspection;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BooleanMethodIsAlwaysInvertedInspectionBase
extends GlobalJavaBatchInspectionTool {
    private static final Key<Boolean> ALWAYS_INVERTED = Key.create((String)"ALWAYS_INVERTED_METHOD");

    BooleanMethodIsAlwaysInvertedInspectionBase() {
    }

    private static boolean hasNonInvertedCalls(RefMethod refMethod) {
        Boolean alwaysInverted = (Boolean)refMethod.getUserData(ALWAYS_INVERTED);
        if (alwaysInverted == null) {
            return true;
        }
        if (refMethod.isExternalOverride()) {
            return true;
        }
        if (refMethod.isReferenced() && !alwaysInverted.booleanValue()) {
            return true;
        }
        Collection superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            if (!BooleanMethodIsAlwaysInvertedInspectionBase.hasNonInvertedCalls(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static void traverseSuperMethods(RefMethod refMethod, GlobalJavaInspectionContext globalContext, GlobalJavaInspectionContext.UsagesProcessor processor) {
        Collection superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            BooleanMethodIsAlwaysInvertedInspectionBase.traverseSuperMethods(superMethod, globalContext, processor);
        }
        globalContext.enqueueMethodUsagesProcessor(refMethod, processor);
    }

    private static void checkMethodCall(RefElement refWhat, PsiElement element) {
        if (!(refWhat instanceof RefMethod)) {
            return;
        }
        final RefMethod refMethod = (RefMethod)refWhat;
        PsiModifierListOwner psiElement = refMethod.getElement();
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        final PsiMethod psiMethod = (PsiMethod)psiElement;
        if (!PsiType.BOOLEAN.equals((Object)psiMethod.getReturnType())) {
            return;
        }
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((PsiElement)psiElement){
            final /* synthetic */ PsiElement val$psiElement;
            {
                this.val$psiElement = psiElement;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.isReferenceTo((PsiElement)psiMethod)) {
                    if (BooleanMethodIsAlwaysInvertedInspectionBase.isInvertedMethodCall(call)) {
                        return;
                    }
                    refMethod.putUserData(ALWAYS_INVERTED, (Object)Boolean.FALSE);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                super.visitMethodReferenceExpression(expression2);
                if (expression2.isReferenceTo(this.val$psiElement)) {
                    refMethod.putUserData(ALWAYS_INVERTED, (Object)Boolean.FALSE);
                }
            }
        });
    }

    static boolean isInvertedMethodCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression;
        if (methodCallExpression == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(0);
        }
        if ((methodExpression = methodCallExpression.getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression) {
            return true;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)ObjectUtils.tryCast((Object)methodCallExpression.getParent(), PsiPrefixExpression.class);
        return prefixExpression != null && prefixExpression.getOperationTokenType().equals(JavaTokenType.EXCL);
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"boolean.method.is.always.inverted.display.name", (Object[])new Object[0]);
        if (string == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DATA_FLOW_ISSUES;
        if (string == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("BooleanMethodIsAlwaysInverted" == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(3);
        }
        return "BooleanMethodIsAlwaysInverted";
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(4);
        }
        return new BooleanInvertedAnnotator();
    }

    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(8);
        }
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (!refMethod.isReferenced()) {
                return null;
            }
            if (BooleanMethodIsAlwaysInvertedInspectionBase.hasNonInvertedCalls(refMethod)) {
                return null;
            }
            if (!refMethod.getSuperMethods().isEmpty()) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
            PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
            if (psiIdentifier != null) {
                Collection inReferences = refMethod.getInReferences();
                if (inReferences.size() == 1) {
                    RefElement refElement = (RefElement)inReferences.iterator().next();
                    PsiElement usagesContainer = refElement.getElement();
                    if (usagesContainer == null) {
                        return null;
                    }
                    if (ReferencesSearch.search((PsiElement)psiMethod, (SearchScope)new LocalSearchScope(usagesContainer)).forEach((Processor)new Processor<PsiReference>(){
                        private final Set<PsiReference> myFoundRefs = new HashSet();

                        public boolean process(PsiReference reference) {
                            this.myFoundRefs.add(reference);
                            return this.myFoundRefs.size() < 2;
                        }
                    })) {
                        return null;
                    }
                }
                return new ProblemDescriptor[]{this.createProblemDescriptor(manager, psiIdentifier)};
            }
        }
        return null;
    }

    protected ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager manager, PsiIdentifier psiIdentifier) {
        if (manager == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(9);
        }
        return manager.createProblemDescriptor((PsiElement)psiIdentifier, InspectionsBundle.message((String)"boolean.method.is.always.inverted.problem.descriptor", (Object[])new Object[0]), this.getInvertBooleanFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext context, final @NotNull ProblemDescriptionsProcessor descriptionsProcessor) {
        if (manager == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(10);
        }
        if (context == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(11);
        }
        if (descriptionsProcessor == null) {
            BooleanMethodIsAlwaysInvertedInspectionBase.$$$reportNull$$$0(12);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitMethod(final @NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (descriptionsProcessor.getDescriptions((RefEntity)refMethod) != null) {
                    GlobalJavaInspectionContext.UsagesProcessor usagesProcessor = new GlobalJavaInspectionContext.UsagesProcessor(){

                        public boolean process(PsiReference psiReference) {
                            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)psiReference.getElement(), PsiReferenceExpression.class);
                            if (psiReferenceExpression == null) {
                                return false;
                            }
                            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)psiReferenceExpression.getParent(), PsiMethodCallExpression.class);
                            if (methodCallExpression != null && !BooleanMethodIsAlwaysInvertedInspectionBase.isInvertedMethodCall(methodCallExpression)) {
                                descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                            }
                            return false;
                        }
                    };
                    BooleanMethodIsAlwaysInvertedInspectionBase.traverseSuperMethods(refMethod, context, usagesProcessor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase$3", "visitMethod"));
            }
        });
        return false;
    }

    public QuickFix getQuickFix(String hint) {
        return this.getInvertBooleanFix();
    }

    protected LocalQuickFix getInvertBooleanFix() {
        return null;
    }

    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new BooleanMethodIsAlwaysInvertedLocalInspection(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/booleanIsAlwaysInverted/BooleanMethodIsAlwaysInvertedInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInvertedMethodCall";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BooleanInvertedAnnotator
    extends RefGraphAnnotator {
        private BooleanInvertedAnnotator() {
        }

        public void onInitialize(RefElement refElement) {
            if (refElement instanceof RefMethod) {
                PsiElement element = refElement.getElement();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                if (!PsiType.BOOLEAN.equals((Object)((PsiMethod)element).getReturnType())) {
                    return;
                }
                refElement.putUserData(ALWAYS_INVERTED, (Object)Boolean.TRUE);
            }
        }

        public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
            BooleanMethodIsAlwaysInvertedInspectionBase.checkMethodCall(refWhat, refFrom.getElement());
        }
    }
}

