/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.accessStaticViaInstance;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessStaticViaInstanceBase
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NonNls
    public static final String ACCESS_STATIC_VIA_INSTANCE = "AccessStaticViaInstance";

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            AccessStaticViaInstanceBase.$$$reportNull$$$0(0);
        }
        return "";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"access.static.via.instance", (Object[])new Object[0]);
        if (string == null) {
            AccessStaticViaInstanceBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (ACCESS_STATIC_VIA_INSTANCE == null) {
            AccessStaticViaInstanceBase.$$$reportNull$$$0(2);
        }
        return ACCESS_STATIC_VIA_INSTANCE;
    }

    public String getAlternativeID() {
        return "static-access";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            AccessStaticViaInstanceBase.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                AccessStaticViaInstanceBase.this.checkAccessStaticMemberViaInstanceReference(expression2, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            AccessStaticViaInstanceBase.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    private void checkAccessStaticMemberViaInstanceReference(PsiReferenceExpression expr, ProblemsHolder holder, boolean onTheFly) {
        PsiElement qualifierResolved;
        JavaResolveResult result = expr.advancedResolve(false);
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiMember)) {
            return;
        }
        PsiExpression qualifierExpression2 = expr.getQualifierExpression();
        if (qualifierExpression2 == null) {
            return;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression && ((qualifierResolved = ((PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
            return;
        }
        if (!((PsiMember)resolved).hasModifierProperty("static")) {
            return;
        }
        PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
        if (containingClass != null && containingClass.isInterface()) {
            return;
        }
        String description = JavaErrorMessages.message("static.member.accessed.via.instance.reference", JavaHighlightUtil.formatType(qualifierExpression2.getType()), HighlightMessageUtil.getSymbolName(resolved, result.getSubstitutor()));
        if (!onTheFly && RemoveUnusedVariableUtil.checkSideEffects(qualifierExpression2, null, new ArrayList())) {
            holder.registerProblem((PsiElement)expr, description, new LocalQuickFix[0]);
            return;
        }
        holder.registerProblem((PsiElement)expr, description, new LocalQuickFix[]{this.createAccessStaticViaInstanceFix(expr, onTheFly, result)});
    }

    protected LocalQuickFix createAccessStaticViaInstanceFix(PsiReferenceExpression expr, boolean onTheFly, JavaResolveResult result) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstanceBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstanceBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

