/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnstableApiUsageInspection
extends LocalInspectionTool {
    public final List<String> unstableApiAnnotations = new ExternalizableStringSet("org.jetbrains.annotations.ApiStatus.Experimental", "com.google.common.annotations.Beta", "io.reactivex.annotations.Beta", "io.reactivex.annotations.Experimental", "rx.annotations.Experimental", "rx.annotations.Beta", "org.apache.http.annotation.Beta");

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl(this.unstableApiAnnotations, JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.annotations.list", new Object[0]));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        constraints.fill = 1;
        panel.add((Component)annotationsListControl, constraints);
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(0);
        }
        if (!this.isApplicable(holder.getFile(), holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UnstableApiUsageInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof PsiLanguageInjectionHost) {
                    return;
                }
                PsiMethod resolvedConstructor = null;
                PsiElement elementParent = element.getParent();
                if (elementParent instanceof PsiConstructorCall) {
                    resolvedConstructor = ((PsiConstructorCall)elementParent).resolveConstructor();
                }
                for (PsiReference reference : element.getReferences()) {
                    PsiModifierListOwner modifierListOwner = UnstableApiUsageInspection.getModifierListOwner(reference, resolvedConstructor);
                    if (modifierListOwner == null || !UnstableApiUsageInspection.isLibraryElement((PsiElement)modifierListOwner)) continue;
                    for (String annotation : UnstableApiUsageInspection.this.unstableApiAnnotations) {
                        if (!modifierListOwner.hasAnnotation(annotation)) continue;
                        holder.registerProblem(reference, JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.description", UnstableApiUsageInspection.getReferenceText(reference)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        return;
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    private static boolean isLibraryElement(@NotNull PsiElement element) {
        if (element == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        PsiFile containingPsiFile = element.getContainingFile();
        if (containingPsiFile == null) {
            return false;
        }
        VirtualFile containingVirtualFile = containingPsiFile.getVirtualFile();
        if (containingVirtualFile == null) {
            return false;
        }
        return ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
    }

    @NotNull
    private static String getReferenceText(@NotNull PsiReference reference) {
        String referenceName;
        if (reference == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(4);
        }
        if (reference instanceof PsiQualifiedReference && (referenceName = ((PsiQualifiedReference)reference).getReferenceName()) != null) {
            String string = referenceName;
            if (string == null) {
                UnstableApiUsageInspection.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = StringUtil.getShortName((String)reference.getCanonicalText());
        if (string == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static PsiModifierListOwner getModifierListOwner(@NotNull PsiReference reference, @Nullable PsiMethod resolvedConstructor) {
        if (reference == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(7);
        }
        if (resolvedConstructor != null) {
            return resolvedConstructor;
        }
        if (reference instanceof ResolvingHint && !((ResolvingHint)reference).canResolveTo(PsiModifierListOwner.class)) {
            return null;
        }
        PsiElement resolvedElement = reference.resolve();
        if (resolvedElement instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)resolvedElement;
        }
        return null;
    }

    private boolean isApplicable(@Nullable PsiFile file, @Nullable Project project) {
        if (file == null || project == null) {
            return false;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = file.getResolveScope();
        for (String annotation : this.unstableApiAnnotations) {
            if (javaPsiFacade.findClass(annotation, scope) == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/UnstableApiUsageInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/UnstableApiUsageInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModifierListOwner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

