/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.trivialif.MergeIfAndIntention;
import org.jetbrains.annotations.NotNull;

public class SurroundWithIfFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.SurroundWithIfFix");
    private final String myText;

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            SurroundWithIfFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public SurroundWithIfFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            SurroundWithIfFix.$$$reportNull$$$0(1);
        }
        this.myText = ParenthesesUtils.getText(expressionToAssert, 10);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        PsiElement element;
        PsiElement anchorStatement;
        if (project == null) {
            SurroundWithIfFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            SurroundWithIfFix.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((anchorStatement = RefactoringUtil.getParentStatement(element = descriptor.getPsiElement(), false)) != null);
        if (anchorStatement.getParent() instanceof PsiLambdaExpression) {
            PsiCodeBlock body2 = RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)anchorStatement.getParent());
            anchorStatement = body2.getStatements()[0];
        }
        if ((editor = PsiUtilBase.findEditor((PsiElement)anchorStatement)) == null) {
            return;
        }
        PsiFile file = anchorStatement.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{anchorStatement};
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchorStatement);
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn(prev) != null) {
            elements = new PsiElement[]{prev, anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project, editor, elements);
            if (textRange == null) {
                return;
            }
            String newText = this.myText + " != null";
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset() + newText.length());
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            new MergeIfAndIntention().invoke(project, editor, file);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
        if (string == null) {
            SurroundWithIfFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isAvailable(PsiExpression qualifier) {
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)qualifier, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiElement parent = statement.getParent();
        return !(parent instanceof PsiForStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SurroundWithIfFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToAssert";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SurroundWithIfFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

