/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class StringTokenizerDelimiterInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String NEXT_TOKEN = "nextToken";
    private static final String STRING_TOKENIZER = "java.util.StringTokenizer";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            StringTokenizerDelimiterInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression callExpression) {
                PsiClass stringTokenizer;
                PsiExpressionList argumentList = callExpression.getArgumentList();
                PsiMethod method = callExpression.resolveMethod();
                if (method != null && argumentList != null && (method.isConstructor() || StringTokenizerDelimiterInspection.NEXT_TOKEN.equals(method.getName())) && (stringTokenizer = method.getContainingClass()) != null && StringTokenizerDelimiterInspection.STRING_TOKENIZER.equals(stringTokenizer.getQualifiedName())) {
                    PsiExpression[] arguments = argumentList.getExpressions();
                    int argCount = arguments.length;
                    if (method.isConstructor()) {
                        if (argCount == 2 || argCount == 3) {
                            StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[1], holder);
                        }
                    } else if (argCount == 1) {
                        StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[0], holder);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            StringTokenizerDelimiterInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static void hasArgumentDuplicates(PsiExpression delimiterArgument, ProblemsHolder holder) {
        Object value2;
        if (delimiterArgument instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)delimiterArgument).getValue()) instanceof String) {
            String delimiters = (String)value2;
            THashSet chars = new THashSet();
            for (char c : delimiters.toCharArray()) {
                if (chars.add(Character.valueOf(c))) continue;
                holder.registerProblem((PsiElement)delimiterArgument, "Delimiters argument contains duplicated characters", new LocalQuickFix[]{new ReplaceDelimitersWithUnique((PsiElement)delimiterArgument)});
                return;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/StringTokenizerDelimiterInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/StringTokenizerDelimiterInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ReplaceDelimitersWithUnique
    extends LocalQuickFixOnPsiElement {
        public ReplaceDelimitersWithUnique(@NotNull PsiElement element) {
            if (element == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace StringTokenizer delimiters parameter with unique symbols" == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(2);
            }
            return "Replace StringTokenizer delimiters parameter with unique symbols";
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(3);
            }
            if (file == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                ReplaceDelimitersWithUnique.$$$reportNull$$$0(6);
            }
            LinkedHashSet<Character> uniqueChars = new LinkedHashSet<Character>();
            PsiLiteralExpression delimiterArgument = (PsiLiteralExpression)startElement;
            Object literal = delimiterArgument.getValue();
            if (!(literal instanceof String)) {
                return;
            }
            for (char c : ((String)literal).toCharArray()) {
                uniqueChars.add(Character.valueOf(c));
            }
            String newDelimiters = StringUtil.join(uniqueChars, (String)"");
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            delimiterArgument.replace((PsiElement)elementFactory.createExpressionFromText(StringUtil.wrapWithDoubleQuote((String)((String)StringUtil.escaper((boolean)true, (String)"\"").fun((Object)newDelimiters))), null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/StringTokenizerDelimiterInspection$ReplaceDelimitersWithUnique";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

