/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyOptionalCallChainsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1);
    private static final CallMatcher OPTIONAL_GET = CallMatcher.instanceCall("java.util.Optional", "get").parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable", "of").parameterCount(1);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        OptionalChainVisitor optionalChainVisitor = new OptionalChainVisitor(){

            @Override
            protected void handleSimplification(@NotNull PsiElement element, @NotNull OptionalChainSimplification simplification) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (simplification == null) {
                    1.$$$reportNull$$$0(1);
                }
                holder.registerProblem(element, simplification.getDescription(), new LocalQuickFix[]{new OptionalChainFix(simplification)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "simplification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$1";
                objectArray[2] = "handleSimplification";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (optionalChainVisitor == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(2);
        }
        return optionalChainVisitor;
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiExpression initializer) {
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
        if (expression2 instanceof PsiLambdaExpression) {
            return (PsiLambdaExpression)expression2;
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            return LambdaRefactoringUtil.createLambda((PsiMethodReferenceExpression)expression2, true);
        }
        return null;
    }

    @Nullable
    private static PsiExpression extractFalseArg(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(3);
        }
        if (OPTIONAL_OR_ELSE.test(call)) {
            return call.getArgumentList().getExpressions()[0];
        }
        if (OPTIONAL_OR_ELSE_GET.test(call)) {
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
            if (lambda2 == null || !lambda2.getParameterList().isEmpty()) {
                return null;
            }
            return LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractFalseArg";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimplifyOptionalChainFix
    implements OptionalChainSimplification {
        private final String myReplacement;
        private final String myMessage;
        private final String myDescription;

        private SimplifyOptionalChainFix(String replacement, String message2, String description) {
            this.myReplacement = replacement;
            this.myMessage = message2;
            this.myDescription = description;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myMessage;
            if (string == null) {
                SimplifyOptionalChainFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                SimplifyOptionalChainFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiMethodCallExpression call;
            if (project == null) {
                SimplifyOptionalChainFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                SimplifyOptionalChainFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression replacementExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myReplacement, (PsiElement)call);
            PsiElement result = call.replace((PsiElement)replacementExpression);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$SimplifyOptionalChainFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$SimplifyOptionalChainFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrElseNonNullActionFix
    implements OptionalChainSimplification {
        private OrElseNonNullActionFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Replace null check with ifPresent()" == null) {
                OrElseNonNullActionFix.$$$reportNull$$$0(0);
            }
            return "Replace null check with ifPresent()";
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Remove redundant null check" == null) {
                OrElseNonNullActionFix.$$$reportNull$$$0(1);
            }
            return "Remove redundant null check";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiMethodCallExpression call;
            if (project == null) {
                OrElseNonNullActionFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                OrElseNonNullActionFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false)) == null) {
                return;
            }
            PsiExpression falseArg = SimplifyOptionalCallChainsInspection.extractFalseArg(call);
            if (!ExpressionUtils.isNullLiteral(falseArg)) {
                return;
            }
            Context context = Context.extract(call, falseArg);
            if (context == null) {
                return;
            }
            PsiExpression receiver2 = context.getOrElseCall().getMethodExpression().getQualifierExpression();
            if (receiver2 == null) {
                return;
            }
            String statementText = receiver2.getText() + ".ifPresent(" + LambdaUtil.createLambda((PsiVariable)context.getVariable(), (PsiExpression)context.getAction()) + ");";
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(statementText, (PsiElement)context.getStatement());
            PsiElement result = context.getStatement().replace((PsiElement)finalStatement);
            context.getConditionStatement().delete();
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Nullable
        private static PsiExpression extractMappingExpression(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
            PsiIfStatement ifStatement;
            if (statement == null) {
                OrElseNonNullActionFix.$$$reportNull$$$0(4);
            }
            if (optValue == null) {
                OrElseNonNullActionFix.$$$reportNull$$$0(5);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            if (ExpressionUtils.getVariableFromNullComparison(condition2, false) != optValue) {
                return null;
            }
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenStatement, PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return null;
            }
            return expressionStatement.getExpression();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullActionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullActionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractMappingExpression";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Context {
            @NotNull
            private final PsiExpression myAction;
            @NotNull
            private final PsiStatement myConditionStatement;
            @NotNull
            private final PsiStatement myStatement;
            @NotNull
            private final PsiVariable myVariable;
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;

            @NotNull
            public PsiExpression getAction() {
                PsiExpression psiExpression = this.myAction;
                if (psiExpression == null) {
                    Context.$$$reportNull$$$0(0);
                }
                return psiExpression;
            }

            @NotNull
            public PsiStatement getConditionStatement() {
                PsiStatement psiStatement = this.myConditionStatement;
                if (psiStatement == null) {
                    Context.$$$reportNull$$$0(1);
                }
                return psiStatement;
            }

            @NotNull
            public PsiStatement getStatement() {
                PsiStatement psiStatement = this.myStatement;
                if (psiStatement == null) {
                    Context.$$$reportNull$$$0(2);
                }
                return psiStatement;
            }

            @NotNull
            public PsiMethodCallExpression getOrElseCall() {
                PsiMethodCallExpression psiMethodCallExpression = this.myOrElseCall;
                if (psiMethodCallExpression == null) {
                    Context.$$$reportNull$$$0(3);
                }
                return psiMethodCallExpression;
            }

            private Context(@NotNull PsiExpression action, @NotNull PsiStatement conditionStatement, @NotNull PsiStatement statement, @NotNull PsiVariable variable, @NotNull PsiMethodCallExpression call) {
                if (action == null) {
                    Context.$$$reportNull$$$0(4);
                }
                if (conditionStatement == null) {
                    Context.$$$reportNull$$$0(5);
                }
                if (statement == null) {
                    Context.$$$reportNull$$$0(6);
                }
                if (variable == null) {
                    Context.$$$reportNull$$$0(7);
                }
                if (call == null) {
                    Context.$$$reportNull$$$0(8);
                }
                this.myAction = action;
                this.myConditionStatement = conditionStatement;
                this.myStatement = statement;
                this.myVariable = variable;
                this.myOrElseCall = call;
            }

            @NotNull
            public PsiVariable getVariable() {
                PsiVariable psiVariable = this.myVariable;
                if (psiVariable == null) {
                    Context.$$$reportNull$$$0(9);
                }
                return psiVariable;
            }

            @Nullable
            static Context extract(@NotNull PsiMethodCallExpression orElseCall, @NotNull PsiExpression orElseArgument) {
                if (orElseCall == null) {
                    Context.$$$reportNull$$$0(10);
                }
                if (orElseArgument == null) {
                    Context.$$$reportNull$$$0(11);
                }
                if (!ExpressionUtils.isNullLiteral(orElseArgument)) {
                    return null;
                }
                PsiLocalVariable returnVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)orElseCall.getParent(), PsiLocalVariable.class);
                if (returnVar == null) {
                    return null;
                }
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)returnVar, PsiStatement.class, (boolean)true);
                if (statement == null) {
                    return null;
                }
                PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
                if (nextStatement == null) {
                    return null;
                }
                PsiExpression lambdaExpr = OrElseNonNullActionFix.extractMappingExpression(nextStatement, (PsiVariable)returnVar);
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaExpr)) {
                    return null;
                }
                if (!ReferencesSearch.search((PsiElement)returnVar).forEach(reference -> PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)nextStatement, (PsiElement)reference.getElement(), (boolean)false))) {
                    return null;
                }
                return new Context(lambdaExpr, nextStatement, statement, (PsiVariable)returnVar, orElseCall);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullActionFix$Context";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conditionStatement";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orElseCall";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orElseArgument";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConditionStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOrElseCall";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullActionFix$Context";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "extract";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class OrElseReturnStreamFix
    implements OptionalChainSimplification {
        @NotNull
        private final String defaultExpression;
        private final boolean myIsSimple;

        private OrElseReturnStreamFix(@NotNull PsiExpression expression2, boolean simple) {
            if (expression2 == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(0);
            }
            this.defaultExpression = PsiExpressionTrimRenderer.render((PsiExpression)expression2);
            this.myIsSimple = simple;
        }

        @Override
        @NotNull
        public String getName() {
            String method = this.myIsSimple ? "orElse" : "orElseGet";
            String string = "Replace null check with " + method + "(" + this.defaultExpression + ")";
            if (string == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Remove redundant null check" == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(2);
            }
            return "Remove redundant null check";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiMethodCallExpression call;
            if (project == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(4);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false)) == null) {
                return;
            }
            PsiExpression falseArg = SimplifyOptionalCallChainsInspection.extractFalseArg(call);
            if (!ExpressionUtils.isNullLiteral(falseArg)) {
                return;
            }
            Context context = Context.extract(call, falseArg);
            if (context == null) {
                return;
            }
            PsiExpression receiver2 = context.getOrElseCall().getMethodExpression().getQualifierExpression();
            if (receiver2 == null) {
                return;
            }
            String methodWithArg = context.isSimple() ? ".orElse(" + context.getDefaultExpression().getText() + ")" : ".orElseGet(()->" + context.getDefaultExpression().getText() + ")";
            String expressionText = receiver2.getText() + methodWithArg;
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("return " + expressionText + ";", (PsiElement)receiver2);
            PsiStatement current = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context.getOrElseCall(), PsiStatement.class, (boolean)false);
            if (current == null) {
                return;
            }
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)current, (PsiElement)finalStatement);
            new CommentTracker().deleteAndRestoreComments((PsiElement)context.getNextStatement());
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Nullable
        private static PsiExpression extractConditionalDefaultValue(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
            if (statement == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(5);
            }
            if (optValue == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(6);
            }
            if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition2 = ifStatement.getCondition();
                if (condition2 == null) {
                    return null;
                }
                PsiExpression thenExpr = OrElseReturnStreamFix.getReturnExpression(ifStatement.getThenBranch());
                PsiExpression elseExpr = OrElseReturnStreamFix.getReturnExpression(ifStatement.getElseBranch());
                if (thenExpr == null || elseExpr == null) {
                    return null;
                }
                return OrElseReturnStreamFix.extractConditionalDefaultValue(thenExpr, elseExpr, condition2, optValue);
            }
            if (statement instanceof PsiReturnStatement) {
                PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
                PsiConditionalExpression ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)returnValue), PsiConditionalExpression.class);
                if (ternary == null) {
                    return null;
                }
                PsiExpression thenExpression2 = ternary.getThenExpression();
                PsiExpression elseExpression2 = ternary.getElseExpression();
                if (thenExpression2 == null || elseExpression2 == null) {
                    return null;
                }
                return OrElseReturnStreamFix.extractConditionalDefaultValue(thenExpression2, elseExpression2, ternary.getCondition(), optValue);
            }
            return null;
        }

        @Contract(value="null -> null")
        @Nullable
        private static PsiExpression getReturnExpression(@Nullable PsiStatement block) {
            if (block == null) {
                return null;
            }
            PsiStatement statement = ControlFlowUtils.stripBraces(block);
            PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)statement, PsiReturnStatement.class);
            if (returnStatement == null) {
                return null;
            }
            return returnStatement.getReturnValue();
        }

        @Nullable
        private static PsiExpression extractConditionalDefaultValue(@NotNull PsiExpression thenExpr, @NotNull PsiExpression elseExpr, @NotNull PsiExpression condition2, @NotNull PsiVariable optValue) {
            PsiExpression defaultExpression;
            if (thenExpr == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(7);
            }
            if (elseExpr == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(8);
            }
            if (condition2 == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(9);
            }
            if (optValue == null) {
                OrElseReturnStreamFix.$$$reportNull$$$0(10);
            }
            PsiVariable nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, true);
            boolean inverted = false;
            if (nullChecked == null) {
                nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, false);
                if (nullChecked == null) {
                    return null;
                }
                inverted = true;
            }
            if (!nullChecked.equals(optValue) || !ExpressionUtils.isReferenceTo(inverted ? thenExpr : elseExpr, optValue)) {
                return null;
            }
            PsiExpression psiExpression = defaultExpression = inverted ? elseExpr : thenExpr;
            if (VariableAccessUtils.variableIsUsed(optValue, (PsiElement)defaultExpression)) {
                return null;
            }
            return defaultExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnStreamFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optValue";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenExpr";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseExpr";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnStreamFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "extractConditionalDefaultValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Context {
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;
            @NotNull
            private final PsiExpression myDefaultExpression;
            @NotNull
            private final PsiStatement myNextStatement;
            private final boolean mySimple;

            private Context(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression defaultExpression, @NotNull PsiStatement nextStatement, boolean simple) {
                if (call == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (defaultExpression == null) {
                    Context.$$$reportNull$$$0(1);
                }
                if (nextStatement == null) {
                    Context.$$$reportNull$$$0(2);
                }
                this.myOrElseCall = call;
                this.myDefaultExpression = defaultExpression;
                this.myNextStatement = nextStatement;
                this.mySimple = simple;
            }

            @NotNull
            public PsiStatement getNextStatement() {
                PsiStatement psiStatement = this.myNextStatement;
                if (psiStatement == null) {
                    Context.$$$reportNull$$$0(3);
                }
                return psiStatement;
            }

            @NotNull
            public PsiMethodCallExpression getOrElseCall() {
                PsiMethodCallExpression psiMethodCallExpression = this.myOrElseCall;
                if (psiMethodCallExpression == null) {
                    Context.$$$reportNull$$$0(4);
                }
                return psiMethodCallExpression;
            }

            @NotNull
            public PsiExpression getDefaultExpression() {
                PsiExpression psiExpression = this.myDefaultExpression;
                if (psiExpression == null) {
                    Context.$$$reportNull$$$0(5);
                }
                return psiExpression;
            }

            public boolean isSimple() {
                return this.mySimple;
            }

            @Nullable
            static Context extract(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression falseArg) {
                if (call == null) {
                    Context.$$$reportNull$$$0(6);
                }
                if (falseArg == null) {
                    Context.$$$reportNull$$$0(7);
                }
                if (!ExpressionUtils.isNullLiteral(falseArg)) {
                    return null;
                }
                PsiLocalVariable returnVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)call, PsiLocalVariable.class, (boolean)true);
                if (returnVar == null) {
                    return null;
                }
                PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
                if (nextStatement == null) {
                    return null;
                }
                PsiExpression defaultValue = OrElseReturnStreamFix.extractConditionalDefaultValue(nextStatement, (PsiVariable)returnVar);
                boolean isSimple = ExpressionUtils.isSafelyRecomputableExpression(defaultValue);
                if (defaultValue == null || !isSimple && !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)defaultValue)) {
                    return null;
                }
                PsiType type2 = defaultValue.getType();
                PsiType methodCallReturnValue = call.getMethodExpression().getType();
                if (type2 == null || methodCallReturnValue == null || !methodCallReturnValue.isAssignableFrom(type2)) {
                    return null;
                }
                return new Context(call, defaultValue, nextStatement, isSimple);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultExpression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nextStatement";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnStreamFix$Context";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "falseArg";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnStreamFix$Context";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNextStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOrElseCall";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultExpression";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "extract";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class OptionalChainFix
    implements LocalQuickFix {
        @NotNull
        private final OptionalChainSimplification mySimplification;

        OptionalChainFix(@NotNull OptionalChainSimplification simplification) {
            if (simplification == null) {
                OptionalChainFix.$$$reportNull$$$0(0);
            }
            this.mySimplification = simplification;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.mySimplification.getName();
            if (string == null) {
                OptionalChainFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify optional call chain" == null) {
                OptionalChainFix.$$$reportNull$$$0(2);
            }
            return "Simplify optional call chain";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                OptionalChainFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                OptionalChainFix.$$$reportNull$$$0(4);
            }
            this.mySimplification.applyFix(project, descriptor.getStartElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "simplification";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalChainFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalChainFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface OptionalChainSimplification {
        @NotNull
        public String getName();

        @NotNull
        public String getDescription();

        public void applyFix(@NotNull Project var1, @NotNull PsiElement var2);
    }

    private static abstract class OptionalChainVisitor
    extends JavaElementVisitor {
        private OptionalChainVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            if (OPTIONAL_GET.test(call)) {
                this.handleRewrapping(call, OPTIONAL_OF_OF_NULLABLE);
                return;
            }
            PsiExpression falseArg = null;
            boolean useOrElseGet = false;
            if (OPTIONAL_OR_ELSE.test(call)) {
                falseArg = call.getArgumentList().getExpressions()[0];
            } else if (OPTIONAL_OR_ELSE_GET.test(call)) {
                useOrElseGet = true;
                PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
                if (lambda2 == null || !lambda2.getParameterList().isEmpty()) {
                    return;
                }
                falseArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            }
            if (falseArg == null) {
                return;
            }
            this.handleMapOrElse(call, useOrElseGet, falseArg);
            if (ExpressionUtils.isNullLiteral(falseArg)) {
                this.handleRewrapping(call, OPTIONAL_OF_NULLABLE);
            }
            this.handleOrElseNullConditionalReturn(call, falseArg);
            this.handleOrElseNullConditionalAction(call, falseArg);
        }

        private void handleRewrapping(PsiMethodCallExpression call, CallMatcher wrapper) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
            if (!wrapper.test(parentCall)) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null || !EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), parentCall.getType())) {
                return;
            }
            if ("get".equals(call.getMethodExpression().getReferenceName()) && !Boolean.TRUE.equals(CommonDataflow.getExpressionFact(qualifier, DfaFactType.OPTIONAL_PRESENCE))) {
                return;
            }
            SimplifyOptionalChainFix fix = new SimplifyOptionalChainFix(qualifier.getText(), "Unwrap", "Unnecessary Optional rewrapping");
            this.handleSimplification(Objects.requireNonNull(parentCall.getMethodExpression().getReferenceNameElement()), fix);
        }

        private void handleMapOrElse(PsiMethodCallExpression call, boolean useOrElseGet, PsiExpression falseArg) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (!OPTIONAL_MAP.test(qualifierCall)) {
                return;
            }
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(qualifierCall.getArgumentList().getExpressions()[0]);
            if (lambda2 == null) {
                return;
            }
            PsiExpression trueArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (trueArg == null) {
                return;
            }
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return;
            }
            PsiExpression qualifier = qualifierCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String opt = qualifier.getText();
            PsiParameter parameter2 = parameters2[0];
            String proposed = OptionalUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
            String canonicalOrElse = useOrElseGet && !ExpressionUtils.isSafelyRecomputableExpression(falseArg) ? ".orElseGet(() -> " + falseArg.getText() + ")" : ".orElse(" + falseArg.getText() + ")";
            String canonical = opt + ".map(" + LambdaUtil.createLambda((PsiVariable)parameter2, (PsiExpression)trueArg) + ")" + canonicalOrElse;
            if (proposed.length() < canonical.length()) {
                String displayCode;
                if (proposed.equals(opt)) {
                    displayCode = "";
                } else if (opt.length() > 10) {
                    opt = "(($))";
                    String template = OptionalUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(template, (PsiElement)call));
                    displayCode = displayCode.replaceFirst(Pattern.quote(opt), "..");
                } else {
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(proposed, (PsiElement)call));
                }
                String message2 = displayCode.isEmpty() ? "Remove redundant steps from optional chain" : "Simplify optional chain to '" + displayCode + "'";
                SimplifyOptionalChainFix fix = new SimplifyOptionalChainFix(proposed, message2, "Optional chain can be simplified");
                this.handleSimplification(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), fix);
            }
        }

        private void handleOrElseNullConditionalReturn(PsiMethodCallExpression call, PsiExpression falseArg) {
            OrElseReturnStreamFix.Context context = OrElseReturnStreamFix.Context.extract(call, falseArg);
            if (context == null) {
                return;
            }
            OrElseReturnStreamFix fix = new OrElseReturnStreamFix(context.getDefaultExpression(), context.isSimple());
            this.handleSimplification(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), fix);
        }

        private void handleOrElseNullConditionalAction(PsiMethodCallExpression call, PsiExpression falseArg) {
            if (OrElseNonNullActionFix.Context.extract(call, falseArg) == null) {
                return;
            }
            OrElseNonNullActionFix fix = new OrElseNonNullActionFix();
            this.handleSimplification(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), fix);
        }

        protected abstract void handleSimplification(@NotNull PsiElement var1, @NotNull OptionalChainSimplification var2);
    }
}

