/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAnnotationQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiAnnotation> myAnnotation;
    private final SmartPsiElementPointer<PsiModifierListOwner> myListOwner;

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner) {
        if (annotation == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(0);
        }
        Project project = annotation.getProject();
        SmartPointerManager pm = SmartPointerManager.getInstance((Project)project);
        this.myAnnotation = pm.createSmartPsiElementPointer((PsiElement)annotation);
        this.myListOwner = listOwner == null ? null : pm.createSmartPsiElementPointer((PsiElement)listOwner);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"remove.annotation", (Object[])new Object[0]);
        if (string == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiAnnotation annotation;
        if (project == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(3);
        }
        if ((annotation = (PsiAnnotation)this.myAnnotation.getElement()) == null) {
            return;
        }
        if (annotation.isPhysical()) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)annotation)) {
                return;
            }
            WriteAction.run(() -> annotation.delete());
        } else {
            PsiModifierListOwner listOwner = (PsiModifierListOwner)this.myListOwner.getElement();
            String qualifiedName = annotation.getQualifiedName();
            if (listOwner != null && qualifiedName != null) {
                ExternalAnnotationsManager.getInstance((Project)project).deannotate(listOwner, qualifiedName);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

