/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantExplicitVariableTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)holder.getFile()).isAtLeast(LanguageLevel.JDK_10)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLocalVariable(PsiLocalVariable variable) {
                PsiTypeElement typeElement = variable.getTypeElement();
                if (!typeElement.isInferredType()) {
                    PsiElement parent = variable.getParent();
                    if (parent instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent).getDeclaredElements().length > 1) {
                        return;
                    }
                    this.doCheck((PsiVariable)variable, (PsiVariable)((PsiLocalVariable)variable.copy()), typeElement);
                }
            }

            public void visitForeachStatement(PsiForeachStatement statement) {
                super.visitForeachStatement(statement);
                PsiParameter parameter2 = statement.getIterationParameter();
                PsiTypeElement typeElement = parameter2.getTypeElement();
                if (typeElement != null && !typeElement.isInferredType()) {
                    PsiForeachStatement copy = (PsiForeachStatement)statement.copy();
                    this.doCheck((PsiVariable)parameter2, (PsiVariable)copy.getIterationParameter(), typeElement);
                }
            }

            private void doCheck(PsiVariable variable, PsiVariable copyVariable, PsiTypeElement element2Highlight) {
                PsiTypeElement typeElementCopy = copyVariable.getTypeElement();
                if (typeElementCopy != null) {
                    RedundantExplicitVariableTypeInspection.replaceExplicitTypeWithVar(typeElementCopy, (PsiElement)variable);
                    if (variable.getType().equals(copyVariable.getType())) {
                        holder.registerProblem((PsiElement)element2Highlight, "Explicit type of local variable can be omitted", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithVarFix()});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            RedundantExplicitVariableTypeInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static PsiElement replaceExplicitTypeWithVar(PsiTypeElement typeElement, PsiElement context) {
        return typeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeElementFromText("var", context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithVarFix
    implements LocalQuickFix {
        private ReplaceWithVarFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace explicit type with 'var'" == null) {
                ReplaceWithVarFix.$$$reportNull$$$0(0);
            }
            return "Replace explicit type with 'var'";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceWithVarFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithVarFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof PsiTypeElement) {
                CodeStyleManager.getInstance((Project)project).reformat(RedundantExplicitVariableTypeInspection.replaceExplicitTypeWithVar((PsiTypeElement)element, element));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection$ReplaceWithVarFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantExplicitVariableTypeInspection$ReplaceWithVarFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

