/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantComparatorComparingInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher THEN_COMPARING_COMPARATOR = CallMatcher.instanceCall("java.util.Comparator", "thenComparing").parameterTypes("java.util.Comparator");
    private static final CallMatcher THEN_COMPARING_FUNCTION = CallMatcher.instanceCall("java.util.Comparator", "thenComparing").parameterTypes("java.util.function.Function");
    private static final CallMapper<String> REPLACEMENTS = new CallMapper<String>().register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparing").parameterTypes("java.util.function.Function"), "thenComparing").register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparing").parameterTypes("java.util.function.Function", "java.util.Comparator"), "thenComparing").register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparingInt").parameterCount(1), "thenComparingInt").register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparingLong").parameterCount(1), "thenComparingLong").register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparingDouble").parameterCount(1), "thenComparingDouble");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantComparatorComparingInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantComparatorComparingInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!THEN_COMPARING_COMPARATOR.test(call)) {
                    return;
                }
                PsiMethodCallExpression comparingCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
                String targetMethod = (String)REPLACEMENTS.mapFirst(comparingCall);
                if (targetMethod == null) {
                    return;
                }
                PsiExpressionList comparingArgs = comparingCall.getArgumentList();
                if (targetMethod.equals("thenComparing") && comparingArgs.getExpressionCount() == 1) {
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)call.copy();
                    copy.getArgumentList().replace(comparingArgs.copy());
                    if (!THEN_COMPARING_FUNCTION.matches((PsiExpression)copy)) {
                        return;
                    }
                }
                String name = comparingCall.getMethodExpression().getReferenceName();
                holder.registerProblem((PsiElement)comparingCall.getMethodExpression(), InspectionsBundle.message((String)"inspection.redundant.comparator.comparing.message", (Object[])new Object[]{name}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteComparingCallFix(name, targetMethod)});
            }
        };
        if (javaElementVisitor == null) {
            RedundantComparatorComparingInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantComparatorComparingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantComparatorComparingInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class DeleteComparingCallFix
    implements LocalQuickFix {
        private final String mySourceMethod;
        private final String myTargetMethod;

        public DeleteComparingCallFix(String sourceMethod, String targetMethod) {
            this.mySourceMethod = sourceMethod;
            this.myTargetMethod = targetMethod;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myTargetMethod.equals("thenComparing") ? InspectionsBundle.message((String)"inspection.redundant.comparator.comparing.fix.remove.name", (Object[])new Object[]{this.mySourceMethod}) : InspectionsBundle.message((String)"inspection.redundant.comparator.comparing.fix.replace.name", (Object[])new Object[]{this.mySourceMethod, this.myTargetMethod});
            if (string == null) {
                DeleteComparingCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.comparator.comparing.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteComparingCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression comparingCall;
            if (project == null) {
                DeleteComparingCallFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeleteComparingCallFix.$$$reportNull$$$0(3);
            }
            if ((comparingCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiMethodCallExpression thenComparingCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)comparingCall, PsiMethodCallExpression.class);
            if (thenComparingCall == null) {
                return;
            }
            ExpressionUtils.bindCallTo(thenComparingCall, this.myTargetMethod);
            CommentTracker ct = new CommentTracker();
            thenComparingCall.getArgumentList().replace((PsiElement)ct.markUnchanged(comparingCall.getArgumentList()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantComparatorComparingInspection$DeleteComparingCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantComparatorComparingInspection$DeleteComparingCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

