/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalAssignedToNullInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean WARN_ON_COMPARISON = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report comparison of Optional with null", (InspectionProfileEntry)this, "WARN_ON_COMPARISON");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalAssignedToNullInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                this.checkNulls(expression2.getType(), expression2.getRExpression(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.assignment", (Object[])new Object[0]));
            }

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length > args.length) {
                    return;
                }
                boolean varArgCall = MethodCallUtils.isVarArgCall(call);
                if (!varArgCall && parameters2.length < args.length) {
                    return;
                }
                for (int i = 0; i < args.length; ++i) {
                    PsiParameter parameter2 = parameters2[Math.min(parameters2.length - 1, i)];
                    PsiType type2 = parameter2.getType();
                    if (varArgCall && i >= parameters2.length - 1 && type2 instanceof PsiEllipsisType) {
                        type2 = ((PsiEllipsisType)type2).getComponentType();
                    }
                    this.checkNulls(type2, args[i], InspectionsBundle.message((String)"inspection.null.value.for.optional.context.parameter", (Object[])new Object[0]));
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiElement body2 = lambda2.getBody();
                if (body2 instanceof PsiExpression) {
                    this.checkNulls(LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2), (PsiExpression)body2, InspectionsBundle.message((String)"inspection.null.value.for.optional.context.lambda", (Object[])new Object[0]));
                }
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                this.checkNulls(PsiTypesUtil.getMethodReturnType((PsiElement)statement), statement.getReturnValue(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.return", (Object[])new Object[0]));
            }

            public void visitVariable(PsiVariable variable) {
                this.checkNulls(variable.getType(), variable.getInitializer(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.declaration", (Object[])new Object[0]));
            }

            public void visitBinaryExpression(PsiBinaryExpression binOp) {
                if (!OptionalAssignedToNullInspection.this.WARN_ON_COMPARISON) {
                    return;
                }
                PsiExpression value2 = ExpressionUtils.getValueComparedWithNull(binOp);
                if (value2 != null && TypeUtils.isOptional(value2.getType()) && !this.hasSubsequentIsPresentCall(value2, (PsiExpression)binOp, JavaTokenType.EQEQ.equals(binOp.getOperationTokenType()))) {
                    holder.registerProblem((PsiElement)binOp, "Optional value is compared with null", new LocalQuickFix[]{new ReplaceWithIsPresentFix(), new SetInspectionOptionFix((LocalInspectionTool)OptionalAssignedToNullInspection.this, "WARN_ON_COMPARISON", "Do not warn when comparing Optional with null", false)});
                }
            }

            private boolean hasSubsequentIsPresentCall(@NotNull PsiExpression optionalExpression, @NotNull PsiExpression previousExpression, boolean negated) {
                IElementType expectedToken;
                PsiPolyadicExpression parent;
                if (optionalExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (previousExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)previousExpression.getParent()), PsiPolyadicExpression.class)) == null) {
                    return false;
                }
                IElementType iElementType = expectedToken = negated ? JavaTokenType.OROR : JavaTokenType.ANDAND;
                if (!parent.getOperationTokenType().equals(expectedToken)) {
                    return false;
                }
                PsiExpression nextExpression = ((StreamEx)((StreamEx)StreamEx.of((Object[])parent.getOperands()).dropWhile(op -> {
                    if (previousExpression == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return !PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)previousExpression, (boolean)false);
                })).skip(1L)).findFirst().orElse(null);
                if ((nextExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextExpression)) == null) {
                    return false;
                }
                if (negated) {
                    if (!BoolUtils.isNegation(nextExpression)) {
                        return false;
                    }
                    nextExpression = BoolUtils.getNegated(nextExpression);
                }
                if (!(nextExpression instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)nextExpression;
                if (!"isPresent".equals(call.getMethodExpression().getReferenceName()) || !call.getArgumentList().isEmpty()) {
                    return false;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                return qualifier != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)optionalExpression);
            }

            private void checkNulls(PsiType type2, PsiExpression expression2, String declaration2) {
                if (expression2 != null && TypeUtils.isOptional(type2)) {
                    ExpressionUtils.nonStructuralChildren(expression2).filter(ExpressionUtils::isNullLiteral).forEach(nullLiteral -> this.register((PsiExpression)nullLiteral, (PsiClassType)type2, declaration2));
                }
            }

            private void register(PsiExpression expression2, PsiClassType type2, String contextName) {
                holder.registerProblem((PsiElement)expression2, InspectionsBundle.message((String)"inspection.null.value.for.optional.message", (Object[])new Object[]{contextName}), new LocalQuickFix[]{new ReplaceWithEmptyOptionalFix(type2)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalExpression";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previousExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasSubsequentIsPresentCall";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$hasSubsequentIsPresentCall$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (javaElementVisitor == null) {
            OptionalAssignedToNullInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/OptionalAssignedToNullInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithIsPresentFix
    implements LocalQuickFix {
        private ReplaceWithIsPresentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with 'isPresent()' call" == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(0);
            }
            return "Replace with 'isPresent()' call";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiBinaryExpression binOp;
            if (project == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(2);
            }
            if ((binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiBinaryExpression.class)) == null) {
                return;
            }
            PsiExpression value2 = ExpressionUtils.getValueComparedWithNull(binOp);
            if (value2 == null || !TypeUtils.isOptional(value2.getType())) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String negation = binOp.getOperationTokenType().equals(JavaTokenType.NE) ? "" : "!";
            ct.replaceAndRestoreComments((PsiElement)binOp, negation + ct.text(value2, 1) + ".isPresent()");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithIsPresentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithIsPresentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceWithEmptyOptionalFix
    implements LocalQuickFix {
        private final String myTypeName;
        private final String myTypeParameter;
        private final String myMethodName;

        public ReplaceWithEmptyOptionalFix(PsiClassType type2) {
            this.myTypeName = type2.rawType().getCanonicalText();
            PsiType[] parameters2 = type2.getParameters();
            this.myTypeParameter = parameters2.length == 1 ? "<" + GenericsUtil.getVariableTypeByExpressionType((PsiType)parameters2[0]).getCanonicalText() + ">" : "";
            this.myMethodName = this.myTypeName.equals("com.google.common.base.Optional") ? "absent" : "empty";
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.null.value.for.optional.fix.name", (Object[])new Object[]{StringUtil.getShortName((String)this.myTypeName) + "." + this.myMethodName + "()"});
            if (string == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.null.value.for.optional.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getStartElement()) instanceof PsiExpression)) {
                return;
            }
            String emptyCall = this.myTypeName + "." + this.myTypeParameter + this.myMethodName + "()";
            PsiElement result = new CommentTracker().replaceAndRestoreComments(element, emptyCall);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

