/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AnnotateMethodFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(AnnotateMethodFix.class);
    private final String myAnnotation;
    private final String[] myAnnotationsToRemove;

    public AnnotateMethodFix(@NotNull String fqn, String ... annotationsToRemove) {
        if (fqn == null) {
            AnnotateMethodFix.$$$reportNull$$$0(0);
        }
        if (annotationsToRemove == null) {
            AnnotateMethodFix.$$$reportNull$$$0(1);
        }
        this.myAnnotation = fqn;
        this.myAnnotationsToRemove = annotationsToRemove.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : annotationsToRemove;
        LOG.assertTrue(this.annotateSelf() || this.annotateOverriddenMethods(), (Object)"annotate method quick fix should not do nothing");
    }

    @NotNull
    public String getName() {
        String string = this.getFamilyName() + " " + this.getPreposition() + " '@" + ClassUtil.extractClassName((String)this.myAnnotation) + "'";
        if (string == null) {
            AnnotateMethodFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String getPreposition() {
        if ("with" == null) {
            AnnotateMethodFix.$$$reportNull$$$0(3);
        }
        return "with";
    }

    @NotNull
    public String getFamilyName() {
        if (this.annotateSelf()) {
            if (this.annotateOverriddenMethods()) {
                String string = InspectionsBundle.message((String)"inspection.annotate.overridden.method.and.self.quickfix.family.name", (Object[])new Object[0]);
                if (string == null) {
                    AnnotateMethodFix.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = InspectionsBundle.message((String)"inspection.annotate.method.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                AnnotateMethodFix.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = InspectionsBundle.message((String)"inspection.annotate.overridden.method.quickfix.family.name", (Object[])new Object[0]);
        if (string == null) {
            AnnotateMethodFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement;
        PsiMethod method;
        if (project == null) {
            AnnotateMethodFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            AnnotateMethodFix.$$$reportNull$$$0(8);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = descriptor.getPsiElement()), PsiMethod.class)) == null) {
            return;
        }
        ArrayList<PsiMethod> toAnnotate = new ArrayList<PsiMethod>();
        if (this.annotateSelf()) {
            toAnnotate.add(method);
        }
        if (this.annotateOverriddenMethods() && !ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
                ReadAction.run(() -> {
                    if (psiMethod.isPhysical() && AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod, (String)this.myAnnotation) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)this.myAnnotation, (int)10) && !NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(psiMethod)) {
                        toAnnotate.add(psiMethod);
                    }
                });
            }
        }, "Searching for Overriding Methods", true, project)) {
            return;
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        for (PsiMethod psiMethod : toAnnotate) {
            this.annotateMethod(psiMethod);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)method.getContainingFile());
    }

    protected boolean annotateOverriddenMethods() {
        return false;
    }

    protected boolean annotateSelf() {
        return true;
    }

    private void annotateMethod(@NotNull PsiMethod method) {
        if (method == null) {
            AnnotateMethodFix.$$$reportNull$$$0(9);
        }
        AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)method, PsiNameValuePair.EMPTY_ARRAY, this.myAnnotationsToRemove);
        fix.invoke(method.getProject(), method.getContainingFile(), (PsiElement)method, (PsiElement)method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnnotateMethodFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnnotateMethodFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreposition";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

