/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.FilterUtil;
import org.jetbrains.annotations.NotNull;

public class KeywordLookupItem
extends LookupElement
implements TypedLookupItem {
    private final PsiElement myPosition;
    private final PsiKeyword myKeyword;

    public KeywordLookupItem(PsiKeyword keyword, @NotNull PsiElement position) {
        if (position == null) {
            KeywordLookupItem.$$$reportNull$$$0(0);
        }
        this.myKeyword = keyword;
        this.myPosition = position;
    }

    @NotNull
    public Object getObject() {
        PsiKeyword psiKeyword = this.myKeyword;
        if (psiKeyword == null) {
            KeywordLookupItem.$$$reportNull$$$0(1);
        }
        return psiKeyword;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myKeyword.getText();
        if (string == null) {
            KeywordLookupItem.$$$reportNull$$$0(2);
        }
        return string;
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE;
    }

    public boolean equals(Object o) {
        return o instanceof KeywordLookupItem && this.getLookupString().equals(((KeywordLookupItem)o).getLookupString());
    }

    public int hashCode() {
        return this.getLookupString().hashCode();
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        presentation.setItemTextBold(true);
    }

    @Override
    public PsiType getType() {
        return FilterUtil.getKeywordItemType(this.myPosition, this.getLookupString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/KeywordLookupItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/KeywordLookupItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

