/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.documentation.AbstractExternalFilter;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;

public class JavaDocExternalFilter
extends AbstractExternalFilter {
    private final Project myProject;
    private PsiElement myElement;
    private static final AbstractExternalFilter.ParseSettings ourPackageInfoSettings = new AbstractExternalFilter.ParseSettings(Pattern.compile("package\\s+[^\\s]+\\s+description", 2), Pattern.compile("START OF BOTTOM NAVBAR", 2), true, false);
    @NonNls
    protected static final Pattern ourAnchorsuffix = Pattern.compile("#(.*)$");
    @NonNls
    protected static final Pattern ourHTMLFilesuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    @NonNls
    private static final Pattern ourHREFselector = Pattern.compile("<A.*?HREF=\"([^>\"]*)\"", 34);
    @NonNls
    private static final Pattern ourMethodHeading = Pattern.compile("<H[34]>(.+?)</H[34]>", 34);
    @NonNls
    protected static final String H2 = "</H2>";
    @NonNls
    protected static final String HTML_CLOSE = "</HTML>";
    @NonNls
    protected static final String HTML = "<HTML>";
    private final AbstractExternalFilter.RefConvertor[] myReferenceConvertors = new AbstractExternalFilter.RefConvertor[]{new AbstractExternalFilter.RefConvertor(ourHREFselector){

        protected String convertReference(String root, String href) {
            if (BrowserUtil.isAbsoluteURL((String)href)) {
                return href;
            }
            String reference = JavaDocInfoGenerator.createReferenceForRelativeLink(href, JavaDocExternalFilter.this.myElement);
            if (reference == null) {
                if (href.startsWith("#")) {
                    return root + href;
                }
                String nakedRoot = ourHTMLFilesuffix.matcher(root).replaceAll("/");
                return JavaDocExternalFilter.doAnnihilate((String)(nakedRoot + href));
            }
            return reference;
        }
    }};

    public JavaDocExternalFilter(Project project) {
        this.myProject = project;
    }

    protected AbstractExternalFilter.RefConvertor[] getRefConverters() {
        return this.myReferenceConvertors;
    }

    @Nullable
    public static String filterInternalDocInfo(String text2) {
        if (text2 == null) {
            return null;
        }
        text2 = PlatformDocumentationUtil.fixupText((CharSequence)text2);
        return text2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getExternalDocInfoForElement(@NotNull String docURL, PsiElement element) throws Exception {
        if (docURL == null) {
            JavaDocExternalFilter.$$$reportNull$$$0(0);
        }
        String externalDoc = null;
        this.myElement = element;
        String projectPath = "/" + this.myProject.getName() + "/";
        String builtInServer = "http://localhost:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() + projectPath;
        if (docURL.startsWith(builtInServer)) {
            VirtualFile file;
            Url url = Urls.parseFromIdea((CharSequence)docURL);
            VirtualFile virtualFile = file = url == null ? null : WebServerPathToFileManager.getInstance((Project)this.myProject).findVirtualFile(url.getPath().substring(projectPath.length()));
            if (file != null) {
                StringBuilder result = new StringBuilder();
                try (InputStreamReader reader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);){
                    this.doBuildFromStream(docURL, reader, result);
                }
                externalDoc = this.correctDocText(docURL, result);
            }
        }
        if (externalDoc == null) {
            externalDoc = super.getExternalDocInfoForElement(docURL, element);
        }
        if (externalDoc == null) {
            return null;
        }
        if (element instanceof PsiMethod) {
            Couple classNameAndPresentation = (Couple)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
                PsiClass aClass = ((PsiMethod)element).getContainingClass();
                return aClass == null ? null : Couple.of((Object)aClass.getQualifiedName(), (Object)(aClass.getQualifiedName() + JavaDocInfoGenerator.generateTypeParameters((PsiTypeParameterListOwner)aClass, true)));
            }));
            if (classNameAndPresentation == null) {
                return externalDoc;
            }
            Matcher matcher = ourMethodHeading.matcher(externalDoc);
            StringBuilder buffer = new StringBuilder("<h3>");
            DocumentationManager.createHyperlink((StringBuilder)buffer, (String)((String)classNameAndPresentation.first), (String)((String)classNameAndPresentation.second), (boolean)false);
            return matcher.replaceFirst(buffer.append("</h3>").toString());
        }
        return externalDoc;
    }

    @NotNull
    protected AbstractExternalFilter.ParseSettings getParseSettings(@NotNull String url) {
        if (url == null) {
            JavaDocExternalFilter.$$$reportNull$$$0(1);
        }
        AbstractExternalFilter.ParseSettings parseSettings = url.endsWith("package-summary.html") ? ourPackageInfoSettings : super.getParseSettings(url);
        if (parseSettings == null) {
            JavaDocExternalFilter.$$$reportNull$$$0(2);
        }
        return parseSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docURL";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/javadoc/JavaDocExternalFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/javadoc/JavaDocExternalFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParseSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExternalDocInfoForElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParseSettings";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

