/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.ImplementAbstractMethodHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementAbstractMethodAction
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.implement.abstract.method.family", (Object[])new Object[0]);
        if (string == null) {
            ImplementAbstractMethodAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        int offset;
        PsiMethod method;
        if (project == null) {
            ImplementAbstractMethodAction.$$$reportNull$$$0(1);
        }
        if ((method = ImplementAbstractMethodAction.findMethod(file, offset = editor.getCaretModel().getOffset())) == null || !method.isValid()) {
            return false;
        }
        this.setText(this.getIntentionName(method));
        if (!method.getManager().isInProject((PsiElement)method)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (isAbstract || !method.hasModifierProperty("private") && !method.hasModifierProperty("static")) {
            if (!isAbstract && !ImplementAbstractMethodAction.isOnIdentifier(file, offset)) {
                return false;
            }
            MyElementProcessor processor = new MyElementProcessor(method);
            if (containingClass.isEnum()) {
                for (PsiField field : containingClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant)) continue;
                    PsiEnumConstantInitializer initializingClass2 = ((PsiEnumConstant)field).getInitializingClass();
                    if (initializingClass2 == null) {
                        processor.myHasMissingImplementations = true;
                        continue;
                    }
                    if (!processor.execute((PsiClass)initializingClass2)) break;
                }
            }
            ClassInheritorsSearch.search((PsiClass)containingClass, (boolean)false).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
            return this.isAvailable(processor);
        }
        return false;
    }

    private static boolean isOnIdentifier(PsiFile file, int offset) {
        PsiElement psiElement = file.findElementAt(offset);
        return psiElement instanceof PsiIdentifier && psiElement.getParent() instanceof PsiMethod;
    }

    protected String getIntentionName(PsiMethod method) {
        return method.hasModifierProperty("abstract") ? CodeInsightBundle.message((String)"intention.implement.abstract.method.text", (Object[])new Object[]{method.getName()}) : CodeInsightBundle.message((String)"intention.override.method.text", (Object[])new Object[]{method.getName()});
    }

    protected boolean isAvailable(MyElementProcessor processor) {
        return processor.hasMissingImplementations();
    }

    @Nullable
    static PsiMethod findExistingImplementation(PsiClass aClass, PsiMethod method) {
        PsiMethod[] methods;
        for (PsiMethod candidate : methods = aClass.findMethodsByName(method.getName(), false)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = candidate.findSuperMethods(false)) {
                if (!superMethod.equals(method)) continue;
                return candidate;
            }
        }
        return null;
    }

    private static PsiMethod findMethod(PsiFile file, int offset) {
        PsiMethod method = ImplementAbstractMethodAction._findMethod(file, offset);
        if (method == null) {
            method = ImplementAbstractMethodAction._findMethod(file, offset - 1);
        }
        return method;
    }

    private static PsiMethod _findMethod(PsiFile file, int offset) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiMethod.class);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiMethod method;
        if (project == null) {
            ImplementAbstractMethodAction.$$$reportNull$$$0(2);
        }
        if ((method = ImplementAbstractMethodAction.findMethod(file, editor.getCaretModel().getOffset())) == null) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || editor.getContentComponent().isShowing()) {
            this.invokeHandler(project, editor, method);
        }
    }

    protected void invokeHandler(Project project, Editor editor, PsiMethod method) {
        new ImplementAbstractMethodHandler(project, editor, method).invoke();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ImplementAbstractMethodAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ImplementAbstractMethodAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyElementProcessor
    implements PsiElementProcessor<PsiClass> {
        private boolean myHasMissingImplementations;
        private boolean myHasExistingImplementations;
        private final PsiMethod myMethod;

        MyElementProcessor(PsiMethod method) {
            this.myMethod = method;
        }

        public boolean hasMissingImplementations() {
            return this.myHasMissingImplementations;
        }

        public boolean hasExistingImplementations() {
            return this.myHasExistingImplementations;
        }

        public boolean execute(@NotNull PsiClass element) {
            PsiMethod existingImplementation;
            if (element == null) {
                MyElementProcessor.$$$reportNull$$$0(0);
            }
            if ((existingImplementation = ImplementAbstractMethodAction.findExistingImplementation(element, this.myMethod)) != null && !existingImplementation.hasModifierProperty("abstract")) {
                this.myHasExistingImplementations = true;
            } else if (existingImplementation == null) {
                this.myHasMissingImplementations = true;
            }
            return !this.myHasMissingImplementations || !this.myHasExistingImplementations;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ImplementAbstractMethodAction$MyElementProcessor", "execute"));
        }
    }
}

