/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcatenationToMessageFormatAction
implements IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.replace.concatenation.with.formatted.output.family", (Object[])new Object[0]);
        if (string == null) {
            ConcatenationToMessageFormatAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.replace.concatenation.with.formatted.output.text", (Object[])new Object[0]);
        if (string == null) {
            ConcatenationToMessageFormatAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        PsiPolyadicExpression concatenation;
        if (project == null) {
            ConcatenationToMessageFormatAction.$$$reportNull$$$0(2);
        }
        if ((concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation(element = ConcatenationToMessageFormatAction.findElementAtCaret(editor, file))) == null) {
            return;
        }
        StringBuilder formatString = new StringBuilder();
        ArrayList args = new ArrayList();
        PsiConcatenationUtil.buildFormatString((PsiExpression)concatenation, (StringBuilder)formatString, args, (boolean)false);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText("java.text.MessageFormat.format()", (PsiElement)concatenation);
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression formatArgument = factory.createExpressionFromText("\"" + formatString.toString() + "\"", null);
        argumentList.add((PsiElement)formatArgument);
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)file)) {
            for (PsiExpression arg : args) {
                argumentList.add((PsiElement)arg);
            }
        } else {
            PsiNewExpression arrayArg = (PsiNewExpression)factory.createExpressionFromText("new java.lang.Object[]{}", null);
            PsiArrayInitializerExpression arrayInitializer = arrayArg.getArrayInitializer();
            assert (arrayInitializer != null);
            for (PsiExpression arg : args) {
                arrayInitializer.add((PsiElement)arg);
            }
            argumentList.add((PsiElement)arrayArg);
        }
        call = (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)call);
        call = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)call);
        new CommentTracker().replaceAndRestoreComments((PsiElement)concatenation, (PsiElement)call);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConcatenationToMessageFormatAction.$$$reportNull$$$0(3);
        }
        if (PsiUtil.getLanguageLevel((PsiElement)file).compareTo((Enum)LanguageLevel.JDK_1_4) < 0) {
            return false;
        }
        PsiElement element = ConcatenationToMessageFormatAction.findElementAtCaret(editor, file);
        PsiPolyadicExpression concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation(element);
        return concatenation != null && !AnnotationUtil.isInsideAnnotation((PsiElement)concatenation) && !PsiUtil.isConstantExpression((PsiExpression)concatenation);
    }

    @Nullable
    private static PsiElement findElementAtCaret(Editor editor, PsiFile file) {
        return file.findElementAt(editor.getCaretModel().getOffset());
    }

    @Nullable
    private static PsiPolyadicExpression getEnclosingLiteralConcatenation(PsiElement element) {
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
        if (binaryExpression == null) {
            return null;
        }
        PsiClassType stringType = PsiType.getJavaLangString((PsiManager)element.getManager(), (GlobalSearchScope)element.getResolveScope());
        if (!stringType.equals((Object)binaryExpression.getType())) {
            return null;
        }
        PsiElement parent;
        while ((parent = binaryExpression.getParent()) instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression parentBinaryExpression = (PsiPolyadicExpression)parent;
            if (!stringType.equals((Object)parentBinaryExpression.getType())) {
                return binaryExpression;
            }
            binaryExpression = parentBinaryExpression;
        }
        return binaryExpression;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

