/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.AnnotationHintsPass;
import com.intellij.codeInsight.hints.ModificationStampHolder;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPassFactory;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "project", "Lcom/intellij/openapi/project/Project;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.java.impl"})
public final class AnnotationHintsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    @NotNull
    private static final ModificationStampHolder modificationStampHolder;
    public static final Companion Companion;

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (editor.isOneLineMode() || !(file instanceof PsiJavaFile) || modificationStampHolder.isNotChanged(editor, file)) {
            return null;
        }
        return (TextEditorHighlightingPass)new AnnotationHintsPass((PsiElement)file, editor, modificationStampHolder);
    }

    public AnnotationHintsPassFactory(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar registrar) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
        super(project);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    static {
        Companion = new Companion(null);
        Key key2 = Key.create((String)"LAST_PASS_MODIFICATION_TIMESTAMP");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<Long>(\"LAST_P\u2026_MODIFICATION_TIMESTAMP\")");
        modificationStampHolder = new ModificationStampHolder((Key<Long>)key2);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPassFactory$Companion;", "", "()V", "modificationStampHolder", "Lcom/intellij/codeInsight/hints/ModificationStampHolder;", "getModificationStampHolder", "()Lcom/intellij/codeInsight/hints/ModificationStampHolder;", "intellij.java.impl"})
    public static final class Companion {
        @NotNull
        public final ModificationStampHolder getModificationStampHolder() {
            return modificationStampHolder;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

