/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.DeleteParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<PsiExpressionList, Object, PsiExpression>,
DumbAware {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{PsiMethodCallExpression.class, PsiNewExpression.class, PsiAnonymousClass.class, PsiEnumConstant.class});
    private static final Set<Class> ourStopSearch = Collections.singleton(PsiMethod.class);
    private static final String WHITESPACE_OR_LINE_BREAKS = " \t\n";
    private static final Key<Inlay> CURRENT_HINT = Key.create((String)"current.hint");
    private static final Key<List<Inlay>> HIGHLIGHTED_HINTS = Key.create((String)"highlighted.hints");

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        List<? extends PsiElement> elements = JavaCompletionUtil.getAllPsiElements(item);
        return elements != null && !elements.isEmpty() && elements.get(0) instanceof PsiMethod ? elements.toArray() : null;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public PsiExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        PsiExpressionList argumentList;
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((argumentList = this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart(), true)) != null) {
            return MethodParameterInfoHandler.findMethodsForArgumentList(context, argumentList);
        }
        return null;
    }

    private PsiExpressionList findArgumentList(PsiFile file, int offset, int parameterStart, boolean allowOuter) {
        PsiExpressionList argumentList = (PsiExpressionList)ParameterInfoUtils.findArgumentList((PsiFile)file, (int)offset, (int)parameterStart, (ParameterInfoHandlerWithTabActionSupport)this, (boolean)allowOuter);
        if (argumentList == null && allowOuter) {
            PsiCall call = (PsiCall)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, PsiMethodCallExpression.class, (Class[])new Class[]{PsiMethod.class});
            if (call == null) {
                call = (PsiCall)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, PsiNewExpression.class, (Class[])new Class[]{PsiMethod.class});
            }
            if (call != null) {
                argumentList = call.getArgumentList();
            }
        }
        return argumentList;
    }

    private static PsiExpressionList findMethodsForArgumentList(CreateParameterInfoContext context, @NotNull PsiExpressionList argumentList) {
        Object[] candidates;
        if (argumentList == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if ((candidates = MethodParameterInfoHandler.getMethods(argumentList)).length == 0) {
            DaemonCodeAnalyzer.getInstance((Project)context.getProject()).updateVisibleHighlighters(context.getEditor());
            return null;
        }
        context.setItemsToShow(candidates);
        return argumentList;
    }

    public void showParameterInfo(@NotNull PsiExpressionList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(3);
        }
        int offset = element.getTextRange().getStartOffset();
        if (CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
            ParameterInfoController controller = ParameterInfoController.findControllerAtOffset((Editor)context.getEditor(), (int)offset);
            PsiElement parent = element.getParent();
            if (parent instanceof PsiCall && controller != null && controller.isHintShown(false)) {
                Object highlighted = controller.getHighlighted();
                Object[] objects = controller.getObjects();
                if (objects != null && objects.length > 0 && (highlighted != null || objects.length == 1)) {
                    PsiCall methodCall = (PsiCall)parent;
                    JavaMethodCallElement.setCompletionModeIfNotSet(methodCall, (Disposable)controller);
                    PsiMethod targetMethod = (PsiMethod)((CandidateInfo)(highlighted == null ? objects[0] : highlighted)).getElement();
                    CompletionMemory.registerChosenMethod(targetMethod, methodCall);
                    controller.setPreservedOnHintHidden(true);
                    ParameterHintsPass.syncUpdate((PsiElement)methodCall, (Editor)context.getEditor());
                }
            }
        }
        context.showHint((PsiElement)element, offset, (ParameterInfoHandler)this);
    }

    public PsiExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        Object[] candidates;
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context.isPreservedOnHintHidden() && MethodParameterInfoHandler.isOutsideOfCompletedInvocation(context)) {
            context.setPreservedOnHintHidden(false);
            return null;
        }
        PsiExpressionList expressionList = this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart(), false);
        if (expressionList != null && (candidates = context.getObjectsToView()) != null && candidates.length != 0) {
            PsiElement element;
            Object currentMethodInfo = context.getHighlightedParameter();
            if (currentMethodInfo == null) {
                currentMethodInfo = candidates[0];
            }
            Object object = currentMethodInfo instanceof CandidateInfo ? ((CandidateInfo)currentMethodInfo).getElement() : (element = currentMethodInfo instanceof PsiElement ? (PsiElement)currentMethodInfo : null);
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiElement parent = expressionList.getParent();
                String originalMethodName = method.getName();
                PsiReferenceExpression currentMethodReference = null;
                if (parent instanceof PsiMethodCallExpression && !method.isConstructor()) {
                    currentMethodReference = ((PsiMethodCallExpression)parent).getMethodExpression();
                } else if (parent instanceof PsiNewExpression) {
                    currentMethodReference = ((PsiNewExpression)parent).getClassReference();
                } else if (parent instanceof PsiAnonymousClass) {
                    currentMethodReference = ((PsiAnonymousClass)parent).getBaseClassReference();
                }
                if (currentMethodReference == null || originalMethodName.equals(currentMethodReference.getReferenceName())) {
                    int currentNumberOfParameters = expressionList.getExpressionCount();
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
                    Document document = psiDocumentManager.getCachedDocument(context.getFile());
                    if (parent instanceof PsiCallExpression && JavaMethodCallElement.isCompletionMode((PsiCall)parent)) {
                        PsiMethod chosenMethod = CompletionMemory.getChosenMethod((PsiCall)parent);
                        if ((context.getHighlightedParameter() != null || candidates.length == 1) && chosenMethod != null && document != null && psiDocumentManager.isCommitted(document) && MethodParameterInfoHandler.isIncompatibleParameterCount(chosenMethod, currentNumberOfParameters)) {
                            JavaMethodCallElement.setCompletionMode((PsiCall)parent, false);
                            ParameterHintsPass.syncUpdate((PsiElement)parent, (Editor)context.getEditor());
                            MethodParameterInfoHandler.highlightHints(context.getEditor(), null, -1, (UserDataHolder)context.getCustomContext());
                        } else {
                            int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)expressionList.getNode(), (int)context.getOffset(), (IElementType)JavaTokenType.COMMA);
                            TextRange textRange = expressionList.getTextRange();
                            if (context.getOffset() <= textRange.getStartOffset() || context.getOffset() >= textRange.getEndOffset()) {
                                index = -1;
                            }
                            MethodParameterInfoHandler.highlightHints(context.getEditor(), expressionList, context.isInnermostContext() ? index : -1, (UserDataHolder)context.getCustomContext());
                        }
                    }
                    return expressionList;
                }
            }
        }
        MethodParameterInfoHandler.highlightHints(context.getEditor(), null, -1, (UserDataHolder)context.getCustomContext());
        return null;
    }

    private static boolean isOutsideOfCompletedInvocation(UpdateParameterInfoContext context) {
        PsiElement owner = context.getParameterOwner();
        if (owner != null && owner.isValid()) {
            TextRange ownerTextRange = MethodParameterInfoHandler.getRelatedRange(owner, context.getEditor());
            int caretOffset = context.getOffset();
            if (ownerTextRange != null) {
                int parametersCount;
                PsiMethod chosenMethod;
                PsiElement parent;
                if (caretOffset >= ownerTextRange.getStartOffset() && caretOffset <= ownerTextRange.getEndOffset()) {
                    return false;
                }
                for (PsiElement element : owner.getChildren()) {
                    if (!(element instanceof PsiErrorElement)) continue;
                    return false;
                }
                if (owner instanceof PsiExpressionList && ((PsiExpressionList)owner).isEmpty() && (parent = owner.getParent()) instanceof PsiCall && (chosenMethod = CompletionMemory.getChosenMethod((PsiCall)parent)) != null && ((parametersCount = chosenMethod.getParameterList().getParametersCount()) == 1 && !chosenMethod.isVarArgs() || parametersCount == 2 && chosenMethod.isVarArgs()) && !MethodParameterInfoHandler.overloadWithNoParametersExists(chosenMethod, context.getObjectsToView())) {
                    return false;
                }
            }
        }
        return true;
    }

    private static TextRange getRelatedRange(PsiElement owner, Editor editor) {
        TextRange range = owner.getTextRange();
        if (range == null) {
            return null;
        }
        Document document = editor.getDocument();
        if (Registry.is((String)"editor.keep.completion.hints.even.longer")) {
            int startY = editor.visualPositionToXY((VisualPosition)editor.offsetToVisualPosition((int)range.getStartOffset())).y;
            int endY = editor.visualPositionToXY((VisualPosition)editor.offsetToVisualPosition((int)range.getEndOffset())).y;
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            return (double)startY > visibleArea.getMaxY() || (double)endY < visibleArea.getMinY() ? null : new TextRange(0, document.getTextLength());
        }
        if (!Registry.is((String)"editor.keep.completion.hints.longer")) {
            return range;
        }
        return new TextRange(DocumentUtil.getLineStartOffset((int)range.getStartOffset(), (Document)document), DocumentUtil.getLineEndOffset((int)range.getEndOffset(), (Document)document));
    }

    private static boolean overloadWithNoParametersExists(PsiMethod method, Object[] candidates) {
        String methodName = method.getName();
        return ContainerUtil.find((Object[])candidates, c -> {
            if (!(c instanceof CandidateInfo)) {
                return false;
            }
            PsiElement e = ((CandidateInfo)c).getElement();
            if (!(e instanceof PsiMethod)) {
                return false;
            }
            PsiMethod m = (PsiMethod)e;
            return m.getParameterList().isEmpty() && m.getName().equals(methodName);
        }) != null;
    }

    private static boolean isIncompatibleParameterCount(@NotNull PsiMethod method, int numberOfParameters) {
        if (method == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int limit = JavaMethodCallElement.getCompletionHintsLimit();
        int originalNumberOfParameters = method.getParameterList().getParametersCount();
        return Registry.is((String)"editor.completion.hints.virtual.comma") ? !PsiImplUtil.isVarArgs(method) && numberOfParameters > originalNumberOfParameters : (PsiImplUtil.isVarArgs(method) ? originalNumberOfParameters > 2 && numberOfParameters < Math.min(limit, originalNumberOfParameters) - 1 && (limit != 1 || numberOfParameters != 0) : !(originalNumberOfParameters >= numberOfParameters && numberOfParameters >= Math.min(limit, originalNumberOfParameters) || Math.min(limit, originalNumberOfParameters) == 1 && numberOfParameters == 0));
    }

    public void updateParameterInfo(@NotNull PsiExpressionList o, @NotNull UpdateParameterInfoContext context) {
        PsiMethod method;
        Object highlightedCandidate;
        TextRange elRange;
        PsiElement parameterOwner;
        if (o == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if ((parameterOwner = context.getParameterOwner()) != o) {
            context.removeHint();
            return;
        }
        int offset = context.getOffset();
        int index = offset <= (elRange = o.getTextRange()).getStartOffset() || offset >= elRange.getEndOffset() ? -1 : ParameterInfoUtils.getCurrentParameterIndex((ASTNode)o.getNode(), (int)offset, (IElementType)JavaTokenType.COMMA);
        context.setCurrentParameter(index);
        Object[] candidates = context.getObjectsToView();
        PsiExpression[] args = o.getExpressions();
        PsiCall call = MethodParameterInfoHandler.getCall(o);
        PsiMethod realResolve = call != null ? call.resolveMethod() : null;
        PsiMethod chosenMethod = CompletionMemory.getChosenMethod(call);
        Object chosenInfo = null;
        CandidateInfo completeMatch = null;
        for (int i = 0; i < candidates.length; ++i) {
            CandidateInfo candidate = (CandidateInfo)candidates[i];
            PsiMethod method2 = (PsiMethod)candidate.getElement();
            if (!method2.isValid() || candidate instanceof MethodCandidateInfo && !((MethodCandidateInfo)candidate).getSiteSubstitutor().isValid()) continue;
            PsiSubstitutor substitutor = MethodParameterInfoHandler.getCandidateInfoSubstitutor((PsiElement)o, candidate, method2 == realResolve);
            assert (substitutor != null);
            if (!method2.isValid() || !substitutor.isValid()) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            PsiParameter[] parms = method2.getParameterList().getParameters();
            boolean enabled = true;
            if (parms.length <= index) {
                if (parms.length > 0) {
                    if (method2.isVarArgs()) {
                        for (int j = 0; j < parms.length - 1; ++j) {
                            PsiType parmType = substitutor.substitute(parms[j].getType());
                            PsiType argType = args[j].getType();
                            if (argType == null || parmType.isAssignableFrom(argType)) continue;
                            enabled = false;
                            break;
                        }
                        if (enabled) {
                            PsiArrayType lastParmType = (PsiArrayType)substitutor.substitute(parms[parms.length - 1].getType());
                            PsiType componentType = lastParmType.getComponentType();
                            if (parms.length == args.length) {
                                PsiType lastArgType = args[args.length - 1].getType();
                                if (lastArgType != null && !lastParmType.isAssignableFrom(lastArgType) && !componentType.isAssignableFrom(lastArgType)) {
                                    enabled = false;
                                }
                            } else {
                                for (int j = parms.length; j <= index && j < args.length; ++j) {
                                    PsiExpression arg = args[j];
                                    PsiType argType = arg.getType();
                                    if (argType == null || componentType.isAssignableFrom(argType)) continue;
                                    enabled = false;
                                    break;
                                }
                            }
                        }
                    } else {
                        enabled = false;
                    }
                } else {
                    enabled = index == 0;
                }
            } else {
                enabled = MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, index, substitutor);
            }
            context.setUIComponentEnabled(i, enabled);
            if (candidates.length <= 1 || !enabled) continue;
            if (PsiManager.getInstance((Project)context.getProject()).areElementsEquivalent((PsiElement)chosenMethod, (PsiElement)method2)) {
                chosenInfo = candidate;
            }
            if (parms.length != args.length || realResolve != method2 || !MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, args.length, substitutor)) continue;
            completeMatch = candidate;
        }
        context.setHighlightedParameter((Registry.is((String)"editor.completion.hints.virtual.comma") || args.length == 0) && chosenInfo != null ? chosenInfo : ObjectUtils.coalesce(completeMatch, chosenInfo));
        Object object = highlightedCandidate = candidates.length == 1 ? candidates[0] : context.getHighlightedParameter();
        if (highlightedCandidate != null && !(method = (PsiMethod)(highlightedCandidate instanceof CandidateInfo ? ((CandidateInfo)highlightedCandidate).getElement() : highlightedCandidate)).isVarArgs() && index > 0 && index >= method.getParameterList().getParametersCount()) {
            context.setCurrentParameter(-1);
        }
    }

    private static void highlightHints(@NotNull Editor editor, @Nullable PsiExpressionList expressionList, int currentHintIndex, @NotNull UserDataHolder context) {
        if (editor == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(9);
        }
        if (editor.isDisposed() || editor instanceof EditorWindow) {
            return;
        }
        ParameterHintsPresentationManager presentationManager = ParameterHintsPresentationManager.getInstance();
        Inlay currentHint = null;
        ArrayList<Inlay> highlightedHints = null;
        if (expressionList != null && expressionList.isValid()) {
            int expressionCount = expressionList.getExpressionCount();
            if (currentHintIndex == 0 || currentHintIndex > 0 && currentHintIndex < expressionCount) {
                highlightedHints = new ArrayList<Inlay>(expressionCount);
                ParameterHintsPass.syncUpdate((PsiElement)expressionList.getParent(), (Editor)editor);
                for (int i = 0; i < Math.max(expressionCount, currentHintIndex == 0 ? 1 : 0); ++i) {
                    PsiElement nextDelimiter;
                    PsiElement prevDelimiter;
                    if (i < expressionCount) {
                        PsiExpression expression2 = expressionList.getExpressions()[i];
                        for (prevDelimiter = expression2; prevDelimiter != null && !(prevDelimiter instanceof PsiJavaToken); prevDelimiter = prevDelimiter.getPrevSibling()) {
                        }
                        for (nextDelimiter = expression2; nextDelimiter != null && !(nextDelimiter instanceof PsiJavaToken); nextDelimiter = nextDelimiter.getNextSibling()) {
                        }
                    } else {
                        prevDelimiter = expressionList.getFirstChild();
                        nextDelimiter = expressionList.getLastChild();
                    }
                    if (prevDelimiter == null || nextDelimiter == null) continue;
                    CharSequence text2 = editor.getDocument().getImmutableCharSequence();
                    int firstRangeStartOffset = prevDelimiter.getTextRange().getEndOffset();
                    int firstRangeEndOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)firstRangeStartOffset, (String)WHITESPACE_OR_LINE_BREAKS);
                    for (Inlay inlay : editor.getInlayModel().getInlineElementsInRange(firstRangeStartOffset, firstRangeEndOffset)) {
                        if (!presentationManager.isParameterHint(inlay)) continue;
                        highlightedHints.add(inlay);
                        if (i != currentHintIndex || currentHint != null) continue;
                        currentHint = inlay;
                    }
                    int secondRangeEndOffset = nextDelimiter.getTextRange().getStartOffset();
                    if (secondRangeEndOffset <= firstRangeEndOffset) continue;
                    int secondRangeStartOffset = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(secondRangeEndOffset - 1), (String)WHITESPACE_OR_LINE_BREAKS) + 1;
                    for (Inlay inlay : editor.getInlayModel().getInlineElementsInRange(secondRangeStartOffset, secondRangeEndOffset)) {
                        if (!presentationManager.isParameterHint(inlay)) continue;
                        highlightedHints.add(inlay);
                    }
                }
            }
        }
        if (currentHint == context.getUserData(CURRENT_HINT) && Objects.equals(highlightedHints, context.getUserData(HIGHLIGHTED_HINTS))) {
            return;
        }
        MethodParameterInfoHandler.resetHints(context);
        if (currentHint != null) {
            presentationManager.setCurrent(currentHint, true);
            context.putUserData(CURRENT_HINT, currentHint);
        }
        if (!ContainerUtil.isEmpty(highlightedHints)) {
            for (Inlay highlightedHint : highlightedHints) {
                presentationManager.setHighlighted(highlightedHint, true);
            }
            context.putUserData(HIGHLIGHTED_HINTS, highlightedHints);
        }
    }

    private static void resetHints(@NotNull UserDataHolder context) {
        List highlightedHints;
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(10);
        }
        ParameterHintsPresentationManager presentationManager = ParameterHintsPresentationManager.getInstance();
        Inlay currentHint = (Inlay)context.getUserData(CURRENT_HINT);
        if (currentHint != null) {
            presentationManager.setCurrent(currentHint, false);
            context.putUserData(CURRENT_HINT, null);
        }
        if ((highlightedHints = (List)context.getUserData(HIGHLIGHTED_HINTS)) != null) {
            for (Inlay hint : highlightedHints) {
                presentationManager.setHighlighted(hint, false);
            }
            context.putUserData(HIGHLIGHTED_HINTS, null);
        }
    }

    public void dispose(@NotNull DeleteParameterInfoContext context) {
        Editor editor;
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (!((editor = context.getEditor()) instanceof EditorWindow)) {
            MethodParameterInfoHandler.resetHints((UserDataHolder)context.getCustomContext());
            PsiElement parameterOwner = context.getParameterOwner();
            if (!editor.isDisposed() && parameterOwner != null && parameterOwner.isValid()) {
                ParameterHintsPass.syncUpdate((PsiElement)parameterOwner.getParent(), (Editor)editor);
            }
        }
    }

    private static PsiSubstitutor getCandidateInfoSubstitutor(PsiElement argList, CandidateInfo candidate, boolean resolveResult) {
        Computable computeSubstitutor = () -> candidate instanceof MethodCandidateInfo && ((MethodCandidateInfo)candidate).isInferencePossible() ? ((MethodCandidateInfo)candidate).inferTypeArguments((ParameterTypeInferencePolicy)CompletionParameterTypeInferencePolicy.INSTANCE, true) : candidate.getSubstitutor();
        if (resolveResult && candidate instanceof MethodCandidateInfo && ((MethodCandidateInfo)candidate).isInferencePossible()) {
            return (PsiSubstitutor)computeSubstitutor.compute();
        }
        return (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(ObjectUtils.notNull((Object)argList, (Object)candidate.getElement()), false, computeSubstitutor);
    }

    private static boolean isAssignableParametersBeforeGivenIndex(PsiParameter[] parms, PsiExpression[] args, int length, PsiSubstitutor substitutor) {
        for (int j = 0; j < length; ++j) {
            PsiParameter parm = parms[j];
            PsiExpression arg = args[j];
            assert (parm.isValid());
            assert (arg.isValid());
            PsiType parmType = parm.getType();
            PsiType argType = arg.getType();
            if (argType == null) continue;
            if (parmType instanceof PsiEllipsisType) {
                parmType = ((PsiEllipsisType)parmType).getComponentType();
            }
            if ((parmType = substitutor.substitute(parmType)).isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Class<PsiExpressionList> getArgumentListClass() {
        if (PsiExpressionList.class == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return PsiExpressionList.class;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JavaTokenType.RBRACE;
        if (iElementType == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(13);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public Set<Class> getArgListStopSearchClasses() {
        Set<Class> set = ourStopSearch;
        if (set == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JavaTokenType.COMMA;
        if (iElementType == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(16);
        }
        return iElementType;
    }

    @NotNull
    public PsiExpression[] getActualParameters(@NotNull PsiExpressionList psiExpressionList) {
        if (psiExpressionList == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(17);
        }
        PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
        if (psiExpressionArray == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(18);
        }
        return psiExpressionArray;
    }

    private static PsiCall getCall(PsiExpressionList list) {
        PsiElement listParent = list.getParent();
        if (listParent instanceof PsiMethodCallExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiNewExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiAnonymousClass) {
            return (PsiCall)listParent.getParent();
        }
        if (listParent instanceof PsiEnumConstant) {
            return (PsiCall)listParent;
        }
        return null;
    }

    private static CandidateInfo[] getMethods(PsiExpressionList argList) {
        PsiCall call = MethodParameterInfoHandler.getCall(argList);
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)argList.getProject()).getResolveHelper();
        if (call instanceof PsiCallExpression) {
            CandidateInfo[] candidates = MethodParameterInfoHandler.getCandidates((PsiCallExpression)call);
            ArrayList<CandidateInfo> result = new ArrayList<CandidateInfo>();
            if (!(argList.getParent() instanceof PsiAnonymousClass)) {
                block0: for (CandidateInfo candidate : candidates) {
                    PsiMethod methodCandidate = (PsiMethod)candidate.getElement();
                    for (CandidateInfo info : result) {
                        if (!MethodSignatureUtil.isSuperMethod((PsiMethod)methodCandidate, (PsiMethod)((PsiMethod)info.getElement()))) continue;
                        continue block0;
                    }
                    if (!candidate.isStaticsScopeCorrect()) continue;
                    boolean accessible = candidate.isAccessible();
                    if (!accessible && methodCandidate.getModifierList().hasModifierProperty("private")) {
                        accessible = JavaPsiFacade.getInstance((Project)methodCandidate.getProject()).getResolveHelper().isAccessible((PsiMember)methodCandidate, methodCandidate.getModifierList(), (PsiElement)call, null, null);
                    }
                    if (!accessible) continue;
                    result.add(candidate);
                }
            } else {
                PsiClass aClass = (PsiClass)argList.getParent();
                for (CandidateInfo candidate : candidates) {
                    if (!candidate.isStaticsScopeCorrect() || !helper.isAccessible((PsiMember)((PsiMethod)candidate.getElement()), (PsiElement)argList, aClass)) continue;
                    result.add(candidate);
                }
            }
            return result.isEmpty() ? candidates : result.toArray(CandidateInfo.EMPTY_ARRAY);
        }
        assert (call instanceof PsiEnumConstant);
        PsiMethod[] constructors = ((PsiEnumConstant)call).getContainingClass().getConstructors();
        CandidateInfo[] result = new CandidateInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new CandidateInfo((PsiElement)constructors[i], PsiSubstitutor.EMPTY);
        }
        return result;
    }

    private static CandidateInfo[] getCandidates(PsiCallExpression call) {
        MethodResolverProcessor processor = new MethodResolverProcessor((PsiElement)call, call.getContainingFile(), new PsiConflictResolver[0]){

            @Override
            protected boolean acceptVarargs() {
                return false;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, call, true);
        }
        catch (MethodProcessorSetupFailedException e) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        List<CandidateInfo> results = processor.getResults();
        return results.toArray(CandidateInfo.EMPTY_ARRAY);
    }

    public static String updateMethodPresentation(@NotNull PsiMethod method, @Nullable PsiSubstitutor substitutor, @NotNull ParameterInfoUIContext context) {
        if (method == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(19);
        }
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(20);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (!method.isValid() || substitutor != null && !substitutor.isValid()) {
            context.setUIComponentEnabled(false);
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO && !context.isSingleParameterInfo()) {
            if (!method.isConstructor()) {
                PsiType returnType = method.getReturnType();
                if (substitutor != null) {
                    returnType = substitutor.substitute(returnType);
                }
                assert (returnType != null) : method;
                MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)method);
                buffer.append(returnType.getPresentableText(true));
                buffer.append(" ");
            }
            buffer.append(method.getName());
            buffer.append("(");
        }
        int currentParameter = context.getCurrentParameterIndex();
        PsiParameter[] parms = method.getParameterList().getParameters();
        int numParams = parms.length;
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (numParams > 0) {
            if (context.isSingleParameterInfo() && method.isVarArgs() && currentParameter >= numParams) {
                currentParameter = numParams - 1;
            }
            for (int j = 0; j < numParams; ++j) {
                if (context.isSingleParameterInfo() && j != currentParameter) continue;
                PsiParameter param = parms[j];
                int startOffset = buffer.length();
                if (param.isValid()) {
                    PsiType paramType = param.getType();
                    assert (paramType.isValid());
                    if (substitutor != null) {
                        assert (substitutor.isValid());
                        paramType = substitutor.substitute(paramType);
                    }
                    if (context.isSingleParameterInfo()) {
                        buffer.append("<b>");
                    }
                    MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)param);
                    String type2 = paramType.getPresentableText(true);
                    buffer.append(context.isSingleParameterInfo() ? StringUtil.escapeXml((String)type2) : type2);
                    String name = param.getName();
                    if (name != null && !context.isSingleParameterInfo()) {
                        buffer.append(" ");
                        buffer.append(name);
                    }
                    if (context.isSingleParameterInfo()) {
                        buffer.append("</b>");
                    }
                }
                if (context.isSingleParameterInfo()) {
                    String javaDoc = new JavaDocInfoGenerator(param.getProject(), (PsiElement)param).generateMethodParameterJavaDoc();
                    if (javaDoc == null) continue;
                    if ((javaDoc = MethodParameterInfoHandler.removeHyperlinks(javaDoc)).length() < 100) {
                        buffer.append("&nbsp;&nbsp;<i>").append(javaDoc).append("</i>");
                        continue;
                    }
                    buffer.insert(0, "<table><tr><td valign='top'>").append("</td><td style='width:400px'>&nbsp;&nbsp;<i>").append(javaDoc).append("</i></td></tr></table>");
                    continue;
                }
                int endOffset = buffer.length();
                if (j < numParams - 1) {
                    buffer.append(", ");
                }
                if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !param.isVarArgs() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        } else {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO && !context.isSingleParameterInfo()) {
            buffer.append(")");
        }
        String text2 = buffer.toString();
        if (context.isSingleParameterInfo()) {
            context.setupRawUIComponentPresentation(text2);
            return text2;
        }
        return context.setupUIComponentPresentation(text2, highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), method.isDeprecated() && !context.isSingleParameterInfo() && !context.isSingleOverload(), false, context.getDefaultParameterColor());
    }

    private static String removeHyperlinks(String html) {
        return html.replaceAll("<a.*?>", "").replaceAll("</a>", "");
    }

    private static void appendModifierList(@NotNull StringBuilder buffer, @NotNull PsiModifierListOwner owner) {
        if (buffer == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(21);
        }
        if (owner == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(22);
        }
        int lastSize = buffer.length();
        HashSet shownAnnotations = ContainerUtil.newHashSet();
        for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)false, null, (!DumbService.isDumb((Project)owner.getProject()) ? 1 : 0) != 0)) {
            String referenceName;
            PsiElement resolved;
            PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
            if (element == null || (resolved = element.resolve()) instanceof PsiClass && (!JavaDocInfoGenerator.isDocumentedAnnotationType((PsiClass)resolved) || AnnotationTargetUtil.findAnnotationTarget((PsiClass)((PsiClass)resolved), (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) != null) || !shownAnnotations.add(referenceName = element.getReferenceName()) && !JavaDocInfoGenerator.isRepeatableAnnotationType(resolved)) continue;
            if (lastSize != buffer.length()) {
                buffer.append(' ');
            }
            buffer.append('@').append(referenceName);
        }
        if (lastSize != buffer.length()) {
            buffer.append(' ');
        }
    }

    public void updateUI(Object p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(23);
        }
        if (p instanceof CandidateInfo) {
            CandidateInfo info = (CandidateInfo)p;
            PsiMethod method = (PsiMethod)info.getElement();
            if (!method.isValid() || info instanceof MethodCandidateInfo && !((MethodCandidateInfo)info).getSiteSubstitutor().isValid()) {
                context.setUIComponentEnabled(false);
                return;
            }
            PsiElement parameterOwner = context.getParameterOwner();
            PsiCall call = parameterOwner instanceof PsiExpressionList ? MethodParameterInfoHandler.getCall((PsiExpressionList)parameterOwner) : null;
            MethodParameterInfoHandler.updateMethodPresentation(method, MethodParameterInfoHandler.getCandidateInfoSubstitutor(parameterOwner, info, call != null && call.resolveMethod() == method), context);
        } else {
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)p, null, context);
        }
    }

    public boolean supportsOverloadSwitching() {
        return CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiExpressionList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListClass";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsForArgumentList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatibleParameterCount";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "highlightHints";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetHints";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateMethodPresentation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendModifierList";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

