/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;

public class HighlightBreakOutsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public HighlightBreakOutsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myTarget);
    }

    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<PsiElement> targets) {
        PsiElement parent = this.myTarget.getParent();
        if (parent instanceof PsiContinueStatement) {
            PsiStatement statement = ((PsiContinueStatement)parent).findContinuedStatement();
            if (statement instanceof PsiLoopStatement) {
                this.highlightLoopDeclaration((PsiLoopStatement)statement);
            }
        } else if (parent instanceof PsiBreakStatement) {
            PsiStatement exitedStatement = ((PsiBreakStatement)parent).findExitedStatement();
            if (exitedStatement instanceof PsiLoopStatement) {
                this.highlightLoopDeclaration((PsiLoopStatement)exitedStatement);
            } else if (exitedStatement instanceof PsiSwitchStatement) {
                this.addOccurrence(exitedStatement.getFirstChild());
            }
        }
        this.addOccurrence(this.myTarget);
    }

    private void highlightLoopDeclaration(PsiLoopStatement statement) {
        if (statement instanceof PsiDoWhileStatement) {
            PsiKeyword whileKeyword = ((PsiDoWhileStatement)statement).getWhileKeyword();
            if (whileKeyword != null) {
                this.addOccurrence((PsiElement)whileKeyword);
            }
        } else {
            this.addOccurrence(statement.getFirstChild());
        }
    }
}

