/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

public class JavaWithIfSurrounder
extends JavaStatementsSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.if.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, true)).length == 0) {
            return null;
        }
        String text2 = "if(a){\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text2, null);
        ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement);
        PsiStatement thenBranch = (ifStatement = (PsiIfStatement)container.addAfter((PsiElement)ifStatement, statements[statements.length - 1])).getThenBranch();
        if (thenBranch != null) {
            PsiCodeBlock thenBlock = ((PsiBlockStatement)thenBranch).getCodeBlock();
            SurroundWithUtil.indentCommentIfNecessary(thenBlock, statements);
            thenBlock.addRange(statements[0], statements[statements.length - 1]);
            container.deleteChildRange(statements[0], statements[statements.length - 1]);
        }
        if ((ifStatement = (PsiIfStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)ifStatement)) == null) {
            return null;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 != null) {
            TextRange range = condition2.getTextRange();
            TextRange textRange = new TextRange(range.getStartOffset(), range.getStartOffset());
            editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
            return textRange;
        }
        return ifStatement.getTextRange();
    }
}

