/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterTemplatesManager;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.SetterTemplatesManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.exception.GenerateCodeException;
import org.jetbrains.java.generate.template.TemplatesManager;

public class GenerateMembersUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersUtil");

    private GenerateMembersUtil() {
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (memberPrototypes == null) {
            GenerateMembersUtil.$$$reportNull$$$0(0);
        }
        List<T> list = GenerateMembersUtil.insertMembersAtOffset(file, offset, memberPrototypes, (Function<PsiElement, PsiClass>)((Function)leaf -> GenerateMembersUtil.findClassAtOffset(file, leaf)));
        if (list == null) {
            GenerateMembersUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(@NotNull PsiClass psiClass, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (psiClass == null) {
            GenerateMembersUtil.$$$reportNull$$$0(2);
        }
        if (memberPrototypes == null) {
            GenerateMembersUtil.$$$reportNull$$$0(3);
        }
        List<T> list = GenerateMembersUtil.insertMembersAtOffset(psiClass.getContainingFile(), offset, memberPrototypes, (Function<PsiElement, PsiClass>)((Function)leaf -> {
            if (psiClass == null) {
                GenerateMembersUtil.$$$reportNull$$$0(80);
            }
            return psiClass;
        }));
        if (list == null) {
            GenerateMembersUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file, int offset, @NotNull List<T> memberPrototypes, Function<PsiElement, PsiClass> aClassFunction) throws IncorrectOperationException {
        PsiField field;
        PsiTypeElement typeElement;
        PsiElement element;
        if (memberPrototypes == null) {
            GenerateMembersUtil.$$$reportNull$$$0(5);
        }
        if (memberPrototypes.isEmpty()) {
            List<T> list = memberPrototypes;
            if (list == null) {
                GenerateMembersUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        PsiElement leaf = file.findElementAt(offset);
        if (leaf == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GenerateMembersUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiClass aClass = (PsiClass)aClassFunction.fun((Object)leaf);
        if (aClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GenerateMembersUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        PsiElement anchor = ((GenerationInfo)memberPrototypes.get(0)).findInsertionAnchor(aClass, leaf);
        if (anchor instanceof PsiWhiteSpace) {
            ASTNode spaceNode = anchor.getNode();
            anchor = anchor.getNextSibling();
            assert (spaceNode != null);
            if (spaceNode.getStartOffset() <= offset && spaceNode.getStartOffset() + spaceNode.getTextLength() >= offset) {
                PsiParserFacade parserFacade;
                ASTNode singleNewLineWhitespace;
                String whiteSpace = spaceNode.getText().substring(0, offset - spaceNode.getStartOffset());
                if (!StringUtil.containsLineBreak((CharSequence)whiteSpace)) {
                    whiteSpace = whiteSpace + "\n";
                }
                if ((singleNewLineWhitespace = (parserFacade = PsiParserFacade.SERVICE.getInstance((Project)file.getProject())).createWhiteSpaceFromText(whiteSpace).getNode()) != null) {
                    spaceNode.getTreeParent().replaceChild(spaceNode, singleNewLineWhitespace);
                }
            }
        }
        for (element = anchor; !(element == null || element instanceof PsiField || element instanceof PsiMethod || element instanceof PsiClassInitializer); element = element.getNextSibling()) {
        }
        if (element instanceof PsiField && (typeElement = (field = (PsiField)element).getTypeElement()) != null && !field.equals(typeElement.getParent())) {
            field.normalizeDeclaration();
            anchor = field;
        }
        List<T> list = GenerateMembersUtil.insertMembersBeforeAnchor(aClass, anchor, memberPrototypes);
        if (list == null) {
            GenerateMembersUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersBeforeAnchor(PsiClass aClass, @Nullable PsiElement anchor, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (memberPrototypes == null) {
            GenerateMembersUtil.$$$reportNull$$$0(10);
        }
        boolean before = true;
        for (GenerationInfo memberPrototype : memberPrototypes) {
            memberPrototype.insert(aClass, anchor, before);
            before = false;
            anchor = memberPrototype.getPsiMember();
        }
        List<T> list = memberPrototypes;
        if (list == null) {
            GenerateMembersUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static void positionCaret(@NotNull Editor editor, @NotNull PsiElement firstMember, boolean toEditMethodBody) {
        int offset;
        PsiMethod method;
        PsiCodeBlock body2;
        if (editor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(12);
        }
        if (firstMember == null) {
            GenerateMembersUtil.$$$reportNull$$$0(13);
        }
        LOG.assertTrue(firstMember.isValid());
        Project project = firstMember.getProject();
        if (toEditMethodBody && (body2 = (method = (PsiMethod)firstMember).getBody()) != null) {
            CharSequence chars;
            PsiElement lastBodyElement;
            PsiElement firstBodyElement;
            PsiElement l = firstBodyElement = body2.getFirstBodyElement();
            while (l instanceof PsiWhiteSpace) {
                l = l.getNextSibling();
            }
            if (l == null) {
                l = body2;
            }
            PsiElement r = lastBodyElement = body2.getLastBodyElement();
            while (r instanceof PsiWhiteSpace) {
                r = r.getPrevSibling();
            }
            if (r == null) {
                r = body2;
            }
            int start = l.getTextRange().getStartOffset();
            int end = r.getTextRange().getEndOffset();
            boolean adjustLineIndent = false;
            if (start > end && firstBodyElement == lastBodyElement && firstBodyElement instanceof PsiWhiteSpaceImpl && (chars = ((PsiWhiteSpaceImpl)firstBodyElement).getChars()).length() > 1 && chars.charAt(0) == '\n' && chars.charAt(1) == '\n') {
                start = end = firstBodyElement.getTextRange().getStartOffset() + 1;
                adjustLineIndent = true;
            }
            editor.getCaretModel().moveToOffset(Math.min(start, end));
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (start < end) {
                editor.getSelectionModel().setSelection(start, end);
            } else if (adjustLineIndent) {
                Document document = editor.getDocument();
                RangeMarker marker = document.createRangeMarker(start, start);
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                if (marker.isValid()) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, marker.getStartOffset());
                }
            }
            return;
        }
        if (firstMember instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)firstMember;
            PsiCodeBlock body3 = method2.getBody();
            if (body3 == null) {
                offset = method2.getTextRange().getStartOffset();
            } else {
                PsiJavaToken lBrace = body3.getLBrace();
                assert (lBrace != null) : firstMember.getText();
                offset = lBrace.getTextRange().getEndOffset();
            }
        } else {
            offset = firstMember.getTextRange().getStartOffset();
        }
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    public static PsiElement insert(@NotNull PsiClass aClass, @NotNull PsiMember member, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        if (aClass == null) {
            GenerateMembersUtil.$$$reportNull$$$0(14);
        }
        if (member == null) {
            GenerateMembersUtil.$$$reportNull$$$0(15);
        }
        if (member instanceof PsiMethod && !aClass.isInterface()) {
            PsiParameter[] parameters2 = ((PsiMethod)member).getParameterList().getParameters();
            boolean generateFinals = JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).GENERATE_FINAL_PARAMETERS;
            for (PsiParameter parameter2 : parameters2) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter2, (String)"final", (boolean)generateFinals);
            }
        }
        if (anchor != null) {
            return before ? aClass.addBefore((PsiElement)member, anchor) : aClass.addAfter((PsiElement)member, anchor);
        }
        return aClass.add((PsiElement)member);
    }

    @Nullable
    private static PsiClass findClassAtOffset(PsiFile file, PsiElement leaf) {
        for (PsiElement element = leaf; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isEnum()) {
                PsiElement lastChild = null;
                for (PsiElement child : psiClass.getChildren()) {
                    if (child instanceof PsiJavaToken && ";".equals(child.getText())) {
                        lastChild = child;
                        break;
                    }
                    if ((!(child instanceof PsiJavaToken) || !",".equals(child.getText())) && !(child instanceof PsiEnumConstant)) continue;
                    lastChild = child;
                }
                if (lastChild != null) {
                    int adjustedOffset = lastChild.getTextRange().getEndOffset();
                    if (leaf.getTextRange().getEndOffset() <= adjustedOffset) {
                        return GenerateMembersUtil.findClassAtOffset(file, file.findElementAt(adjustedOffset));
                    }
                }
            }
            return psiClass;
        }
        return null;
    }

    public static PsiMethod substituteGenericMethod(PsiMethod method, PsiSubstitutor substitutor) {
        return GenerateMembersUtil.substituteGenericMethod(method, substitutor, null);
    }

    public static PsiMethod substituteGenericMethod(@NotNull PsiMethod sourceMethod, @NotNull PsiSubstitutor substitutor, @Nullable PsiElement target) {
        if (sourceMethod == null) {
            GenerateMembersUtil.$$$reportNull$$$0(16);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(17);
        }
        Project project = sourceMethod.getProject();
        JVMElementFactory factory = GenerateMembersUtil.getFactory(sourceMethod.getProject(), target);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        try {
            PsiMethod resultMethod = GenerateMembersUtil.createMethod(factory, sourceMethod, target);
            GenerateMembersUtil.copyModifiers(sourceMethod.getModifierList(), resultMethod.getModifierList());
            PsiSubstitutor collisionResolvedSubstitutor = GenerateMembersUtil.substituteTypeParameters(factory, target, sourceMethod.getTypeParameterList(), resultMethod.getTypeParameterList(), substitutor, sourceMethod);
            GenerateMembersUtil.substituteReturnType(PsiManager.getInstance((Project)project), resultMethod, sourceMethod.getReturnType(), collisionResolvedSubstitutor);
            GenerateMembersUtil.substituteParameters(factory, codeStyleManager, sourceMethod.getParameterList(), resultMethod.getParameterList(), collisionResolvedSubstitutor, target);
            GenerateMembersUtil.copyDocComment(sourceMethod, resultMethod, factory);
            GlobalSearchScope scope = sourceMethod.getResolveScope();
            List<PsiClassType> thrownTypes = ExceptionUtil.collectSubstituted(collisionResolvedSubstitutor, sourceMethod.getThrowsList().getReferencedTypes(), scope);
            if (target instanceof PsiClass) {
                for (PsiMethod psiMethod : ((PsiClass)target).findMethodsBySignature(sourceMethod, true)) {
                    PsiClass aSuper;
                    if (psiMethod == null || psiMethod == sourceMethod || MethodSignatureUtil.isSuperMethod((PsiMethod)psiMethod, (PsiMethod)sourceMethod) || (aSuper = psiMethod.getContainingClass()) == null || aSuper == target) continue;
                    PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aSuper, (PsiClass)((PsiClass)target), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    ExceptionUtil.retainExceptions(thrownTypes, ExceptionUtil.collectSubstituted(superClassSubstitutor, psiMethod.getThrowsList().getReferencedTypes(), scope));
                }
            }
            GenerateMembersUtil.substituteThrows(factory, resultMethod.getThrowsList(), collisionResolvedSubstitutor, sourceMethod, thrownTypes);
            return resultMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return sourceMethod;
        }
    }

    private static void copyModifiers(@NotNull PsiModifierList sourceModifierList, @NotNull PsiModifierList targetModifierList) {
        if (sourceModifierList == null) {
            GenerateMembersUtil.$$$reportNull$$$0(18);
        }
        if (targetModifierList == null) {
            GenerateMembersUtil.$$$reportNull$$$0(19);
        }
        VisibilityUtil.setVisibility((PsiModifierList)targetModifierList, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)sourceModifierList));
    }

    @NotNull
    private static PsiSubstitutor substituteTypeParameters(@NotNull JVMElementFactory factory, @Nullable PsiElement target, @Nullable PsiTypeParameterList sourceTypeParameterList, @Nullable PsiTypeParameterList targetTypeParameterList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        if (factory == null) {
            GenerateMembersUtil.$$$reportNull$$$0(20);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(21);
        }
        if (sourceMethod == null) {
            GenerateMembersUtil.$$$reportNull$$$0(22);
        }
        if (sourceTypeParameterList == null || targetTypeParameterList == null || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)sourceMethod, (PsiSubstitutor)substitutor)) {
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                GenerateMembersUtil.$$$reportNull$$$0(23);
            }
            return psiSubstitutor;
        }
        HashMap<PsiTypeParameter, PsiClassType> substitutionMap = new HashMap<PsiTypeParameter, PsiClassType>(substitutor.getSubstitutionMap());
        for (PsiTypeParameter typeParam : sourceTypeParameterList.getTypeParameters()) {
            PsiTypeParameter substitutedTypeParam = GenerateMembersUtil.substituteTypeParameter(factory, typeParam, substitutor, sourceMethod);
            PsiTypeParameter resolvedTypeParam = GenerateMembersUtil.resolveTypeParametersCollision(factory, sourceTypeParameterList, target, substitutedTypeParam, substitutor);
            targetTypeParameterList.add((PsiElement)resolvedTypeParam);
            if (substitutedTypeParam == resolvedTypeParam) continue;
            substitutionMap.put(typeParam, factory.createType((PsiClass)resolvedTypeParam));
        }
        PsiSubstitutor psiSubstitutor = substitutionMap.isEmpty() ? substitutor : factory.createSubstitutor(substitutionMap);
        if (psiSubstitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(24);
        }
        return psiSubstitutor;
    }

    @NotNull
    private static PsiTypeParameter resolveTypeParametersCollision(@NotNull JVMElementFactory factory, @NotNull PsiTypeParameterList sourceTypeParameterList, @Nullable PsiElement target, @NotNull PsiTypeParameter typeParam, @NotNull PsiSubstitutor substitutor) {
        if (factory == null) {
            GenerateMembersUtil.$$$reportNull$$$0(25);
        }
        if (sourceTypeParameterList == null) {
            GenerateMembersUtil.$$$reportNull$$$0(26);
        }
        if (typeParam == null) {
            GenerateMembersUtil.$$$reportNull$$$0(27);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(28);
        }
        for (PsiType type2 : substitutor.getSubstitutionMap().values()) {
            if (type2 == null || !Comparing.equal((String)type2.getCanonicalText(), (String)typeParam.getName())) continue;
            String newName = GenerateMembersUtil.suggestUniqueTypeParameterName(typeParam.getName(), sourceTypeParameterList, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class, (boolean)false));
            PsiTypeParameter newTypeParameter = factory.createTypeParameter(newName, typeParam.getSuperTypes());
            substitutor.put(typeParam, (PsiType)factory.createType((PsiClass)newTypeParameter));
            PsiTypeParameter psiTypeParameter = newTypeParameter;
            if (psiTypeParameter == null) {
                GenerateMembersUtil.$$$reportNull$$$0(29);
            }
            return psiTypeParameter;
        }
        PsiTypeParameter psiTypeParameter = factory.createTypeParameter(typeParam.getName(), typeParam.getSuperTypes());
        if (psiTypeParameter == null) {
            GenerateMembersUtil.$$$reportNull$$$0(30);
        }
        return psiTypeParameter;
    }

    @NotNull
    private static String suggestUniqueTypeParameterName(String baseName, @NotNull PsiTypeParameterList typeParameterList, @Nullable PsiClass targetClass) {
        String newName;
        if (typeParameterList == null) {
            GenerateMembersUtil.$$$reportNull$$$0(31);
        }
        int i = 0;
        while (!GenerateMembersUtil.checkUniqueTypeParameterName(newName = baseName + ++i, typeParameterList) || targetClass != null && !GenerateMembersUtil.checkUniqueTypeParameterName(newName, targetClass.getTypeParameterList())) {
        }
        String string = newName;
        if (string == null) {
            GenerateMembersUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static boolean checkUniqueTypeParameterName(@NotNull String baseName, @Nullable PsiTypeParameterList typeParameterList) {
        if (baseName == null) {
            GenerateMembersUtil.$$$reportNull$$$0(33);
        }
        if (typeParameterList == null) {
            return true;
        }
        for (PsiTypeParameter typeParameter : typeParameterList.getTypeParameters()) {
            if (!Comparing.equal((String)typeParameter.getName(), (String)baseName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static PsiTypeParameter substituteTypeParameter(final @NotNull JVMElementFactory factory, @NotNull PsiTypeParameter typeParameter, final @NotNull PsiSubstitutor substitutor, final @NotNull PsiMethod sourceMethod) {
        if (factory == null) {
            GenerateMembersUtil.$$$reportNull$$$0(34);
        }
        if (typeParameter == null) {
            GenerateMembersUtil.$$$reportNull$$$0(35);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(36);
        }
        if (sourceMethod == null) {
            GenerateMembersUtil.$$$reportNull$$$0(37);
        }
        PsiElement copy = ((PsiElement)ObjectUtils.notNull((Object)(typeParameter instanceof PsiCompiledElement ? ((PsiCompiledElement)typeParameter).getMirror() : typeParameter), (Object)typeParameter)).copy();
        final HashMap<PsiElement, PsiElement> replacementMap = new HashMap<PsiElement, PsiElement>();
        copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiTypeParameter) {
                    PsiClassType type2 = factory.createType((PsiClass)((PsiTypeParameter)resolve));
                    replacementMap.put(reference, factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)type2, (PsiTypeParameterListOwner)sourceMethod)));
                }
            }
        });
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)RefactoringUtil.replaceElementsWithMap(copy, replacementMap);
        if (psiTypeParameter == null) {
            GenerateMembersUtil.$$$reportNull$$$0(38);
        }
        return psiTypeParameter;
    }

    private static void substituteParameters(@NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiParameterList sourceParameterList, @NotNull PsiParameterList targetParameterList, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        if (factory == null) {
            GenerateMembersUtil.$$$reportNull$$$0(39);
        }
        if (codeStyleManager == null) {
            GenerateMembersUtil.$$$reportNull$$$0(40);
        }
        if (sourceParameterList == null) {
            GenerateMembersUtil.$$$reportNull$$$0(41);
        }
        if (targetParameterList == null) {
            GenerateMembersUtil.$$$reportNull$$$0(42);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(43);
        }
        PsiParameter[] parameters2 = sourceParameterList.getParameters();
        PsiParameter[] newParameters = GenerateMembersUtil.overriddenParameters(parameters2, factory, codeStyleManager, substitutor, target);
        for (int i = 0; i < newParameters.length; ++i) {
            PsiParameter newParameter = newParameters[i];
            GenerateMembersUtil.copyOrReplaceModifierList((PsiModifierListOwner)parameters2[i], target, (PsiModifierListOwner)newParameter);
            targetParameterList.add((PsiElement)newParameter);
        }
    }

    public static PsiParameter[] overriddenParameters(PsiParameter[] parameters2, @NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        if (factory == null) {
            GenerateMembersUtil.$$$reportNull$$$0(44);
        }
        if (codeStyleManager == null) {
            GenerateMembersUtil.$$$reportNull$$$0(45);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(46);
        }
        PsiParameter[] result = new PsiParameter[parameters2.length];
        UniqueNameGenerator generator = new UniqueNameGenerator();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiType parameterType = parameter2.getType();
            PsiType substituted = GenerateMembersUtil.substituteType(substitutor, parameterType, (PsiTypeParameterListOwner)((PsiMethod)parameter2.getDeclarationScope()));
            String paramName = parameter2.getName();
            boolean isBaseNameGenerated = true;
            boolean isSubstituted = substituted.equals(parameterType);
            if (!isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, TypeConversionUtil.erasure((PsiType)parameterType), paramName)) {
                isBaseNameGenerated = false;
            }
            if (paramName == null || isBaseNameGenerated && !isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, parameterType, paramName) || !factory.isValidParameterName(paramName)) {
                String[] names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)substituted).names;
                paramName = names.length > 0 ? generator.generateUniqueName(names[0]) : generator.generateUniqueName("p");
            } else if (!generator.value(paramName)) {
                paramName = generator.generateUniqueName(paramName);
            }
            generator.addExistingName(paramName);
            PsiType expressionType = GenericsUtil.getVariableTypeByExpressionType((PsiType)substituted);
            if (expressionType instanceof PsiArrayType && substituted instanceof PsiEllipsisType) {
                expressionType = new PsiEllipsisType(((PsiArrayType)expressionType).getComponentType());
            }
            result[i] = factory.createParameter(paramName, expressionType, target);
        }
        return result;
    }

    private static void substituteThrows(@NotNull JVMElementFactory factory, @NotNull PsiReferenceList targetThrowsList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod, List<PsiClassType> thrownTypes) {
        if (factory == null) {
            GenerateMembersUtil.$$$reportNull$$$0(47);
        }
        if (targetThrowsList == null) {
            GenerateMembersUtil.$$$reportNull$$$0(48);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(49);
        }
        if (sourceMethod == null) {
            GenerateMembersUtil.$$$reportNull$$$0(50);
        }
        for (PsiClassType thrownType : thrownTypes) {
            targetThrowsList.add(factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)thrownType, (PsiTypeParameterListOwner)sourceMethod)));
        }
    }

    private static void copyDocComment(PsiMethod source, PsiMethod target, JVMElementFactory factory) {
        PsiDocComment docComment;
        PsiElement navigationElement = source.getNavigationElement();
        if (navigationElement instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)navigationElement).getDocComment()) != null) {
            target.addAfter((PsiElement)factory.createDocCommentFromText(docComment.getText()), null);
        }
        PsiParameter[] sourceParameters = source.getParameterList().getParameters();
        PsiParameterList targetParameterList = target.getParameterList();
        RefactoringUtil.fixJavadocsForParams(target, new HashSet<PsiParameter>(Arrays.asList(targetParameterList.getParameters())), (Condition<Pair<PsiParameter, String>>)((Condition)pair -> {
            int parameterIndex = targetParameterList.getParameterIndex((PsiParameter)pair.first);
            if (parameterIndex >= 0 && parameterIndex < sourceParameters.length) {
                return Comparing.strEqual((String)((String)pair.second), (String)sourceParameters[parameterIndex].getName());
            }
            return false;
        }));
    }

    @NotNull
    private static PsiMethod createMethod(@NotNull JVMElementFactory factory, @NotNull PsiMethod method, PsiElement target) {
        if (factory == null) {
            GenerateMembersUtil.$$$reportNull$$$0(51);
        }
        if (method == null) {
            GenerateMembersUtil.$$$reportNull$$$0(52);
        }
        if (method.isConstructor()) {
            PsiMethod psiMethod = factory.createConstructor(method.getName(), target);
            if (psiMethod == null) {
                GenerateMembersUtil.$$$reportNull$$$0(53);
            }
            return psiMethod;
        }
        PsiMethod psiMethod = factory.createMethod(method.getName(), (PsiType)PsiType.VOID, target);
        if (psiMethod == null) {
            GenerateMembersUtil.$$$reportNull$$$0(54);
        }
        return psiMethod;
    }

    private static void substituteReturnType(@NotNull PsiManager manager, @NotNull PsiMethod method, @Nullable PsiType returnType, @NotNull PsiSubstitutor substitutor) {
        PsiTypeElement returnTypeElement;
        if (manager == null) {
            GenerateMembersUtil.$$$reportNull$$$0(55);
        }
        if (method == null) {
            GenerateMembersUtil.$$$reportNull$$$0(56);
        }
        if (substitutor == null) {
            GenerateMembersUtil.$$$reportNull$$$0(57);
        }
        if ((returnTypeElement = method.getReturnTypeElement()) == null || returnType == null) {
            return;
        }
        PsiType substitutedReturnType = GenerateMembersUtil.substituteType(substitutor, returnType, (PsiTypeParameterListOwner)method);
        returnTypeElement.replace((PsiElement)new LightTypeElement(manager, substitutedReturnType instanceof PsiWildcardType ? TypeConversionUtil.erasure((PsiType)substitutedReturnType) : substitutedReturnType));
    }

    @NotNull
    private static JVMElementFactory getFactory(@NotNull Project p, @Nullable PsiElement target) {
        if (p == null) {
            GenerateMembersUtil.$$$reportNull$$$0(58);
        }
        Object object = target == null ? JavaPsiFacade.getInstance((Project)p).getElementFactory() : JVMElementFactories.requireFactory((Language)target.getLanguage(), (Project)p);
        if (object == null) {
            GenerateMembersUtil.$$$reportNull$$$0(59);
        }
        return object;
    }

    private static boolean isBaseNameGenerated(JavaCodeStyleManager csManager, PsiType parameterType, String paramName) {
        if (Arrays.asList(csManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)parameterType).names).contains(paramName)) {
            return true;
        }
        String typeName = JavaCodeStyleManagerImpl.getTypeName(parameterType);
        return typeName != null && NameUtil.getSuggestionsByName((String)typeName, (String)"", (String)"", (boolean)false, (boolean)false, (boolean)(parameterType instanceof PsiArrayType)).contains(paramName);
    }

    private static PsiType substituteType(PsiSubstitutor substitutor, PsiType type2, @NotNull PsiTypeParameterListOwner owner) {
        PsiType deepComponentType;
        if (owner == null) {
            GenerateMembersUtil.$$$reportNull$$$0(60);
        }
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner, (PsiSubstitutor)substitutor)) {
            return TypeConversionUtil.erasure((PsiType)type2);
        }
        PsiType psiType = substitutor.substitute(type2);
        if (psiType != null && !((deepComponentType = psiType.getDeepComponentType()) instanceof PsiCapturedWildcardType) && !(deepComponentType instanceof PsiWildcardType)) {
            return psiType;
        }
        return TypeConversionUtil.erasure((PsiType)type2);
    }

    public static boolean isChildInRange(PsiElement child, PsiElement first, PsiElement last) {
        if (child.equals(first)) {
            return true;
        }
        do {
            if (child.equals(first)) {
                return false;
            }
            if (!child.equals(last)) continue;
            return true;
        } while ((child = child.getNextSibling()) != null);
        return false;
    }

    public static void setupGeneratedMethod(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        PsiClass base = containingClass == null ? null : containingClass.getSuperClass();
        PsiMethod overridden = base == null ? null : base.findMethodBySignature(method, true);
        boolean emptyTemplate = true;
        PsiCodeBlock body2 = method.getBody();
        if (body2 != null) {
            PsiJavaToken lBrace = body2.getLBrace();
            int left = lBrace != null ? lBrace.getStartOffsetInParent() + 1 : 0;
            PsiJavaToken rBrace = body2.getRBrace();
            int right = rBrace != null ? rBrace.getStartOffsetInParent() : body2.getTextLength();
            emptyTemplate = StringUtil.isEmptyOrSpaces((String)body2.getText().substring(left, right));
        }
        if (overridden == null) {
            if (emptyTemplate) {
                CreateFromUsageUtils.setupMethodBody(method, containingClass);
            }
            return;
        }
        if (emptyTemplate) {
            OverrideImplementUtil.setupMethodBody(method, overridden, containingClass);
        }
        OverrideImplementUtil.annotateOnOverrideImplement(method, base, overridden);
    }

    @Deprecated
    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @NotNull PsiModifierListOwner targetParam) {
        if (sourceParam == null) {
            GenerateMembersUtil.$$$reportNull$$$0(61);
        }
        if (targetParam == null) {
            GenerateMembersUtil.$$$reportNull$$$0(62);
        }
        GenerateMembersUtil.copyOrReplaceModifierList(sourceParam, null, targetParam);
    }

    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @Nullable PsiElement targetClass, @NotNull PsiModifierListOwner targetParam) {
        if (sourceParam == null) {
            GenerateMembersUtil.$$$reportNull$$$0(63);
        }
        if (targetParam == null) {
            GenerateMembersUtil.$$$reportNull$$$0(64);
        }
        PsiModifierList sourceModifierList = sourceParam.getModifierList();
        PsiModifierList targetModifierList = targetParam.getModifierList();
        if (sourceModifierList != null && targetModifierList != null) {
            for (String m : PsiModifier.MODIFIERS) {
                targetModifierList.setModifierProperty(m, sourceParam.hasModifierProperty(m));
            }
            OverrideImplementsAnnotationsHandler.repeatAnnotationsFromSource(sourceParam, targetClass, targetParam);
        }
    }

    public static void copyAnnotations(@NotNull PsiModifierList source, @NotNull PsiModifierList target, String ... skipAnnotations) {
        if (source == null) {
            GenerateMembersUtil.$$$reportNull$$$0(65);
        }
        if (target == null) {
            GenerateMembersUtil.$$$reportNull$$$0(66);
        }
        for (PsiAnnotation annotation : source.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null || ArrayUtil.contains((String)qualifiedName, (String[])skipAnnotations) || target.hasAnnotation(qualifiedName)) continue;
            AddAnnotationPsiFix.addPhysicalAnnotation(qualifiedName, annotation.getParameterList().getAttributes(), target);
        }
    }

    public static void copyAnnotations(@NotNull PsiModifierListOwner source, @NotNull PsiModifierListOwner target, String ... skipAnnotations) {
        if (source == null) {
            GenerateMembersUtil.$$$reportNull$$$0(67);
        }
        if (target == null) {
            GenerateMembersUtil.$$$reportNull$$$0(68);
        }
        PsiModifierList targetModifierList = target.getModifierList();
        PsiModifierList sourceModifierList = source.getModifierList();
        if (targetModifierList == null || sourceModifierList == null) {
            return;
        }
        GenerateMembersUtil.copyAnnotations(sourceModifierList, targetModifierList, skipAnnotations);
    }

    public static PsiMethod generateSimpleGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(69);
        }
        return GenerateMembersUtil.generatePrototype(field, PropertyUtilBase.generateGetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(70);
        }
        return GenerateMembersUtil.generatePrototype(field, PropertyUtilBase.generateSetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(PsiField field, PsiClass targetClass) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtilBase.generateSetterPrototype((PsiField)field, (PsiClass)targetClass));
    }

    public static String suggestGetterName(PsiField field) {
        return GenerateMembersUtil.generateGetterPrototype(field).getName();
    }

    public static String suggestGetterName(String name, PsiType type2, Project project) {
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        return GenerateMembersUtil.suggestGetterName(JavaPsiFacade.getElementFactory((Project)project).createField(name, type2));
    }

    public static String suggestSetterName(PsiField field) {
        return GenerateMembersUtil.generateSetterPrototype(field).getName();
    }

    public static String suggestSetterName(String name, PsiType type2, Project project) {
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        return GenerateMembersUtil.suggestSetterName(JavaPsiFacade.getElementFactory((Project)project).createField(name, type2));
    }

    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(71);
        }
        return GenerateMembersUtil.generateGetterPrototype(field, true);
    }

    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(72);
        }
        return GenerateMembersUtil.generateSetterPrototype(field, true);
    }

    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, PsiClass aClass) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(73);
        }
        return GenerateMembersUtil.generatePrototype(field, aClass, true, SetterTemplatesManager.getInstance());
    }

    static PsiMethod generateGetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(74);
        }
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, GetterTemplatesManager.getInstance());
    }

    static PsiMethod generateSetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(75);
        }
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, SetterTemplatesManager.getInstance());
    }

    private static PsiMethod generatePrototype(@NotNull PsiField field, PsiClass psiClass, boolean ignoreInvalidTemplate, TemplatesManager templatesManager) {
        PsiMethod annotationTarget;
        PsiMethod result;
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(76);
        }
        Project project = field.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String template = templatesManager.getDefaultTemplate().getTemplate();
        String methodText = GenerationUtil.velocityGenerateCode(psiClass, Collections.singletonList(field), new HashMap<String, String>(), template, 0, false);
        boolean isGetter = templatesManager instanceof GetterTemplatesManager;
        try {
            result = factory.createMethodFromText(methodText, (PsiElement)psiClass);
        }
        catch (IncorrectOperationException e) {
            if (ignoreInvalidTemplate) {
                LOG.info((Throwable)e);
                result = isGetter ? PropertyUtilBase.generateGetterPrototype((PsiField)field) : PropertyUtilBase.generateSetterPrototype((PsiField)field);
            }
            throw new GenerateCodeException(e);
        }
        result = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)result);
        if (isGetter) {
            annotationTarget = result;
        } else {
            PsiParameter[] parameters2 = result.getParameterList().getParameters();
            PsiParameter psiParameter = annotationTarget = parameters2.length == 1 ? parameters2[0] : null;
        }
        if (annotationTarget != null) {
            NullableNotNullManager.getInstance((Project)project).copyNullableOrNotNullAnnotation((PsiModifierListOwner)field, (PsiModifierListOwner)annotationTarget);
        }
        return GenerateMembersUtil.generatePrototype(field, result);
    }

    @NotNull
    private static PsiMethod generatePrototype(@NotNull PsiField field, @NotNull PsiMethod result) {
        if (field == null) {
            GenerateMembersUtil.$$$reportNull$$$0(77);
        }
        if (result == null) {
            GenerateMembersUtil.$$$reportNull$$$0(78);
        }
        PsiMethod psiMethod = GenerateMembersUtil.setVisibility((PsiMember)field, GenerateMembersUtil.annotateOnOverrideImplement(field.getContainingClass(), result));
        if (psiMethod == null) {
            GenerateMembersUtil.$$$reportNull$$$0(79);
        }
        return psiMethod;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static PsiMethod setVisibility(PsiMember member, PsiMethod prototype) {
        String newVisibility;
        if (prototype == null) {
            return null;
        }
        PsiFile file = member.getContainingFile();
        JavaCodeStyleSettings javaSettings = file != null ? JavaCodeStyleSettings.getInstance(file) : (JavaCodeStyleSettings)CodeStyle.getProjectOrDefaultSettings((Project)member.getProject()).getCustomSettings(JavaCodeStyleSettings.class);
        String visibility = javaSettings.VISIBILITY;
        if ("EscalateVisible".equals(visibility)) {
            PsiClass aClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
            newVisibility = PsiUtil.getMaximumModifierForMember((PsiClass)aClass, (boolean)false);
        } else {
            newVisibility = visibility;
        }
        VisibilityUtil.setVisibility((PsiModifierList)prototype.getModifierList(), (String)newVisibility);
        return prototype;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static PsiMethod annotateOnOverrideImplement(@Nullable PsiClass targetClass, @Nullable PsiMethod generated) {
        PsiMethod superMethod;
        if (generated == null || targetClass == null) {
            return generated;
        }
        if (JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION && (superMethod = targetClass.findMethodBySignature(generated, true)) != null && superMethod.getContainingClass() != targetClass && PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)targetClass, null)) {
            OverrideImplementUtil.annotateOnOverrideImplement(generated, targetClass, superMethod, true);
        }
        return generated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 53: 
            case 54: 
            case 59: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 53: 
            case 54: 
            case 59: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberPrototypes";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 53: 
            case 54: 
            case 59: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/GenerateMembersUtil";
                break;
            }
            case 2: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstMember";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 16: 
            case 22: 
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMethod";
                break;
            }
            case 17: 
            case 21: 
            case 28: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModifierList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModifierList";
                break;
            }
            case 20: 
            case 25: 
            case 34: 
            case 39: 
            case 44: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypeParameterList";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParam";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleManager";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceParameterList";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetParameterList";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetThrowsList";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceParam";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetParam";
                break;
            }
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/GenerateMembersUtil";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "insertMembersAtOffset";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "insertMembersBeforeAnchor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTypeParameters";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeParametersCollision";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueTypeParameterName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTypeParameter";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePrototype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertMembersAtOffset";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 53: 
            case 54: 
            case 59: 
            case 79: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertMembersBeforeAnchor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "positionCaret";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "substituteGenericMethod";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyModifiers";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypeParameters";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeParametersCollision";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "suggestUniqueTypeParameterName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkUniqueTypeParameterName";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypeParameter";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "substituteParameters";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "overriddenParameters";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "substituteThrows";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "substituteReturnType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFactory";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "substituteType";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "copyOrReplaceModifierList";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotations";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "generateSimpleGetterPrototype";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "generateSimpleSetterPrototype";
                break;
            }
            case 71: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "generateGetterPrototype";
                break;
            }
            case 72: 
            case 73: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "generateSetterPrototype";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "generatePrototype";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertMembersAtOffset$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 53: 
            case 54: 
            case 59: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

