/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.exception.TemplateResourceException;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesManager;

@State(name="EqualsHashCodeTemplates", storages={@Storage(value="equalsHashCodeTemplates.xml")})
public class EqualsHashCodeTemplatesManager
extends TemplatesManager {
    private static final String DEFAULT_EQUALS = "/com/intellij/codeInsight/generation/defaultEquals.vm";
    private static final String DEFAULT_HASH_CODE = "/com/intellij/codeInsight/generation/defaultHashCode.vm";
    private static final String APACHE3_EQUALS = "/com/intellij/codeInsight/generation/apacheEqualsBuilder3.vm";
    private static final String APACHE3_HASH_CODE = "/com/intellij/codeInsight/generation/apacheHashCodeBuilder3.vm";
    private static final String APACHE3_BUILDER = "org.apache.commons.lang3.builder.EqualsBuilder";
    private static final String APACHE_EQUALS = "/com/intellij/codeInsight/generation/apacheEqualsBuilder.vm";
    private static final String APACHE_HASH_CODE = "/com/intellij/codeInsight/generation/apacheHashCodeBuilder.vm";
    private static final String APACHE_BUILDER = "org.apache.commons.lang.builder.EqualsBuilder";
    private static final String GUAVA_EQUALS = "/com/intellij/codeInsight/generation/guavaEquals.vm";
    private static final String GUAVA_HASH_CODE = "/com/intellij/codeInsight/generation/guavaHashCode.vm";
    private static final String GUAVA_BUILDER = "com.google.common.base.Objects";
    private static final String OBJECTS_EQUALS = "/com/intellij/codeInsight/generation/objectsEquals.vm";
    private static final String OBJECTS_HASH_CODE = "/com/intellij/codeInsight/generation/objectsHashCode.vm";
    private static final String OBJECTS_BUILDER = "java.util.Objects";
    private static final String EQUALS_SUFFIX = "equals";
    private static final String HASH_CODE_SUFFIX = "hashCode";
    @NonNls
    public static final String INTELLI_J_DEFAULT = "IntelliJ Default";
    @NonNls
    public static final String EQUALS_HASH_CODE_BUILDER_APACHE_COMMONS_LANG = "Equals/HashCodeBuilder (Apache commons-lang)";
    @NonNls
    public static final String EQUALS_HASH_CODE_BUILDER_APACHE_COMMONS_LANG_3 = "Equals/HashCodeBuilder (Apache commons-lang 3)";
    @NonNls
    public static final String OBJECTS_EQUAL_AND_HASH_CODE_GUAVA = "Objects.equal and hashCode (Guava)";
    @NonNls
    public static final String JAVA_UTIL_OBJECTS_EQUALS_AND_HASH_CODE = "java.util.Objects.equals and hashCode (java 7+)";

    public static EqualsHashCodeTemplatesManager getInstance() {
        return (EqualsHashCodeTemplatesManager)ServiceManager.getService(EqualsHashCodeTemplatesManager.class);
    }

    @Override
    public TemplateResource[] getDefaultTemplates() {
        try {
            return new TemplateResource[]{new TemplateResource(EqualsHashCodeTemplatesManager.toEqualsName(INTELLI_J_DEFAULT), EqualsHashCodeTemplatesManager.readFile(DEFAULT_EQUALS), true), new TemplateResource(EqualsHashCodeTemplatesManager.toHashCodeName(INTELLI_J_DEFAULT), EqualsHashCodeTemplatesManager.readFile(DEFAULT_HASH_CODE), true), new TemplateResource(EqualsHashCodeTemplatesManager.toEqualsName(EQUALS_HASH_CODE_BUILDER_APACHE_COMMONS_LANG), EqualsHashCodeTemplatesManager.readFile(APACHE_EQUALS), true, APACHE_BUILDER), new TemplateResource(EqualsHashCodeTemplatesManager.toHashCodeName(EQUALS_HASH_CODE_BUILDER_APACHE_COMMONS_LANG), EqualsHashCodeTemplatesManager.readFile(APACHE_HASH_CODE), true, APACHE_BUILDER), new TemplateResource(EqualsHashCodeTemplatesManager.toEqualsName(EQUALS_HASH_CODE_BUILDER_APACHE_COMMONS_LANG_3), EqualsHashCodeTemplatesManager.readFile(APACHE3_EQUALS), true, APACHE3_BUILDER), new TemplateResource(EqualsHashCodeTemplatesManager.toHashCodeName(EQUALS_HASH_CODE_BUILDER_APACHE_COMMONS_LANG_3), EqualsHashCodeTemplatesManager.readFile(APACHE3_HASH_CODE), true, APACHE3_BUILDER), new TemplateResource(EqualsHashCodeTemplatesManager.toEqualsName(OBJECTS_EQUAL_AND_HASH_CODE_GUAVA), EqualsHashCodeTemplatesManager.readFile(GUAVA_EQUALS), true, GUAVA_BUILDER), new TemplateResource(EqualsHashCodeTemplatesManager.toHashCodeName(OBJECTS_EQUAL_AND_HASH_CODE_GUAVA), EqualsHashCodeTemplatesManager.readFile(GUAVA_HASH_CODE), true, GUAVA_BUILDER), new TemplateResource(EqualsHashCodeTemplatesManager.toEqualsName(JAVA_UTIL_OBJECTS_EQUALS_AND_HASH_CODE), EqualsHashCodeTemplatesManager.readFile(OBJECTS_EQUALS), true, OBJECTS_BUILDER), new TemplateResource(EqualsHashCodeTemplatesManager.toHashCodeName(JAVA_UTIL_OBJECTS_EQUALS_AND_HASH_CODE), EqualsHashCodeTemplatesManager.readFile(OBJECTS_HASH_CODE), true, OBJECTS_BUILDER)};
        }
        catch (IOException e) {
            throw new TemplateResourceException("Error loading default templates", e);
        }
    }

    private static String readFile(String resourceName) throws IOException {
        return EqualsHashCodeTemplatesManager.readFile(resourceName, EqualsHashCodeTemplatesManager.class);
    }

    public TemplateResource getDefaultEqualsTemplate() {
        return this.getEqualsTemplate(this.getDefaultTemplate());
    }

    public TemplateResource getDefaultHashcodeTemplate() {
        return this.getHashcodeTemplate(this.getDefaultTemplate());
    }

    public TemplateResource getEqualsTemplate(TemplateResource template) {
        return this.getDefaultTemplate(EQUALS_SUFFIX, HASH_CODE_SUFFIX, template);
    }

    public TemplateResource getHashcodeTemplate(TemplateResource template) {
        return this.getDefaultTemplate(HASH_CODE_SUFFIX, EQUALS_SUFFIX, template);
    }

    @NotNull
    public static String getTemplateBaseName(TemplateResource resource) {
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)resource.getFileName(), (String)EQUALS_SUFFIX), (String)HASH_CODE_SUFFIX).trim();
        if (string == null) {
            EqualsHashCodeTemplatesManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    private TemplateResource getDefaultTemplate(String selfSuffix, String oppositeSuffix, TemplateResource defaultTemplate) {
        String fileName = defaultTemplate.getFileName();
        if (fileName.endsWith(selfSuffix)) {
            return defaultTemplate;
        }
        String equalsTemplateName = StringUtil.trimEnd((String)fileName, (String)oppositeSuffix) + selfSuffix;
        for (TemplateResource resource : this.getAllTemplates()) {
            if (!equalsTemplateName.equals(resource.getFileName())) continue;
            return resource;
        }
        assert (false) : selfSuffix + " template for " + fileName + " not found";
        return null;
    }

    public void setDefaultTemplate(String name) {
        HashSet fullNames = ContainerUtil.newHashSet((Object[])new String[]{EqualsHashCodeTemplatesManager.toEqualsName(name), EqualsHashCodeTemplatesManager.toHashCodeName(name)});
        for (TemplateResource resource : this.getAllTemplates()) {
            if (!fullNames.contains(resource.getFileName())) continue;
            this.setDefaultTemplate(resource);
            break;
        }
    }

    @Override
    protected String getInitialTemplateName() {
        return EqualsHashCodeTemplatesManager.toEqualsName(JAVA_UTIL_OBJECTS_EQUALS_AND_HASH_CODE);
    }

    public String getDefaultTemplateBaseName() {
        return EqualsHashCodeTemplatesManager.getTemplateBaseName(this.getDefaultTemplate());
    }

    public static String toEqualsName(String name) {
        return name + " " + EQUALS_SUFFIX;
    }

    public static String toHashCodeName(String name) {
        return name + " " + HASH_CODE_SUFFIX;
    }

    public Collection<Couple<TemplateResource>> getTemplateCouples() {
        LinkedHashMap<String, Couple> resources = new LinkedHashMap<String, Couple>();
        for (TemplateResource resource : this.getAllTemplates()) {
            String baseName = EqualsHashCodeTemplatesManager.getTemplateBaseName(resource);
            TemplateResource eq = EqualsHashCodeTemplatesManager.toEqualsName(baseName).equals(resource.getFileName()) ? resource : null;
            TemplateResource hc = EqualsHashCodeTemplatesManager.toHashCodeName(baseName).equals(resource.getFileName()) ? resource : null;
            Couple couple = (Couple)resources.get(baseName);
            if (couple != null) {
                resources.put(baseName, Couple.of((Object)(couple.first != null ? (TemplateResource)couple.first : eq), (Object)(couple.second != null ? (TemplateResource)couple.second : hc)));
                continue;
            }
            resources.put(baseName, Couple.of((Object)eq, (Object)hc));
        }
        return resources.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/EqualsHashCodeTemplatesManager", "getTemplateBaseName"));
    }
}

