/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CaseStatementsSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            CaseStatementsSelectioner.$$$reportNull$$$0(0);
        }
        return e.getParent() instanceof PsiCodeBlock && e.getParent().getParent() instanceof PsiSwitchStatement;
    }

    public List<TextRange> select(@NotNull PsiElement statement, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement sibling;
        PsiElement labelStatement;
        if (statement == null) {
            CaseStatementsSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            CaseStatementsSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CaseStatementsSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement caseStart = statement;
        PsiElement caseEnd = statement;
        if (statement instanceof PsiSwitchStatement) {
            return result;
        }
        Object object = labelStatement = statement instanceof PsiSwitchLabelStatement ? statement : null;
        if (labelStatement == null) {
            for (sibling = statement.getPrevSibling(); sibling != null && !(sibling instanceof PsiSwitchLabelStatement); sibling = sibling.getPrevSibling()) {
                if (sibling instanceof PsiWhiteSpace) continue;
                caseStart = sibling;
            }
            labelStatement = sibling;
        }
        if (labelStatement != null) {
            PsiElement nextLabel;
            while ((nextLabel = PsiTreeUtil.skipSiblingsBackward((PsiElement)labelStatement, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiSwitchLabelStatement) {
                labelStatement = nextLabel;
            }
        }
        PsiElement psiElement = sibling = statement instanceof PsiWhiteSpace ? statement.getNextSibling() : statement;
        while (sibling instanceof PsiSwitchLabelStatement) {
            sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)sibling, (Class[])new Class[]{PsiWhiteSpace.class});
        }
        while (sibling != null && !(sibling instanceof PsiSwitchLabelStatement)) {
            if (!(sibling instanceof PsiWhiteSpace) && !(sibling instanceof PsiJavaToken)) {
                caseEnd = sibling;
            }
            sibling = sibling.getNextSibling();
        }
        Document document = editor.getDocument();
        int endOffset = DocumentUtil.getLineEndOffset((int)(caseEnd.getTextOffset() + caseEnd.getTextLength()), (Document)document) + 1;
        if (!(caseStart instanceof PsiSwitchLabelStatement)) {
            result.add(new TextRange(DocumentUtil.getLineStartOffset((int)caseStart.getTextOffset(), (Document)document), endOffset));
        }
        if (labelStatement != null) {
            result.add(new TextRange(DocumentUtil.getLineStartOffset((int)labelStatement.getTextOffset(), (Document)document), endOffset));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/CaseStatementsSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

