/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.BraceOrQuoteOutAction;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;

public class JavaNextParameterActionPromoter
implements ActionPromoter {
    public List<AnAction> promote(List<AnAction> actions, DataContext context) {
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)context.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            return null;
        }
        if (!ParameterInfoController.existsForEditor((Editor)editor)) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement argumentList = ParameterInfoController.findArgumentList((PsiFile)file, (int)caretOffset, (int)-1);
        if (argumentList == null) {
            return null;
        }
        int lbraceOffset = argumentList.getTextRange().getStartOffset();
        if (ParameterInfoController.findControllerAtOffset((Editor)editor, (int)lbraceOffset) == null) {
            return null;
        }
        int rbraceOffset = argumentList.getTextRange().getEndOffset() - 1;
        if (caretOffset > rbraceOffset || !CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)document.getImmutableCharSequence().subSequence(caretOffset, rbraceOffset))) {
            return null;
        }
        return ContainerUtil.filter(actions, action -> !(action instanceof BraceOrQuoteOutAction));
    }
}

