/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix");
    private final PsiType myReturnType;
    protected final String myName;

    public VariableTypeFix(@NotNull PsiVariable variable, PsiType toReturn) {
        if (variable == null) {
            VariableTypeFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)variable);
        this.myReturnType = GenericsUtil.getVariableTypeByExpressionType((PsiType)toReturn);
        this.myName = variable.getName();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.variable.type.text", UsageViewUtil.getType((PsiElement)this.getStartElement()), this.myName, this.getReturnType().getCanonicalText());
        if (string == null) {
            VariableTypeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.variable.type.family", new Object[0]);
        if (string == null) {
            VariableTypeFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiVariable myVariable;
        if (project == null) {
            VariableTypeFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            VariableTypeFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            VariableTypeFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            VariableTypeFix.$$$reportNull$$$0(6);
        }
        return (myVariable = (PsiVariable)startElement).getTypeElement() != null && myVariable.getManager().isInProject((PsiElement)myVariable) && this.getReturnType() != null && !LambdaUtil.notInferredType((PsiType)this.getReturnType()) && this.getReturnType().isValid() && !TypeConversionUtil.isNullType((PsiType)this.getReturnType()) && !TypeConversionUtil.isVoidType((PsiType)this.getReturnType());
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiVariable myVariable;
        if (project == null) {
            VariableTypeFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            VariableTypeFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            VariableTypeFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            VariableTypeFix.$$$reportNull$$$0(10);
        }
        if (this.changeMethodSignatureIfNeeded(myVariable = (PsiVariable)startElement)) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(this.getText()).run(() -> {
            if (file == null) {
                VariableTypeFix.$$$reportNull$$$0(11);
            }
            if (project == null) {
                VariableTypeFix.$$$reportNull$$$0(12);
            }
            try {
                myVariable.normalizeDeclaration();
                PsiTypeElement typeElement = myVariable.getTypeElement();
                LOG.assertTrue(typeElement != null, myVariable.getClass());
                PsiTypeElement newTypeElement = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createTypeElement(this.getReturnType());
                typeElement.replace((PsiElement)newTypeElement);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)myVariable);
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private boolean changeMethodSignatureIfNeeded(PsiVariable myVariable) {
        PsiElement scope;
        if (myVariable instanceof PsiParameter && (scope = ((PsiParameter)myVariable).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            PsiMethod psiMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
            if (psiMethod == null) {
                return true;
            }
            int parameterIndex = method.getParameterList().getParameterIndex((PsiParameter)myVariable);
            if (!FileModificationService.getInstance().prepareFileForWrite(psiMethod.getContainingFile())) {
                return true;
            }
            ArrayList<ParameterInfoImpl> infos = new ArrayList<ParameterInfoImpl>();
            int i = 0;
            for (PsiParameter parameter2 : psiMethod.getParameterList().getParameters()) {
                boolean changeType = i == parameterIndex;
                infos.add(new ParameterInfoImpl(i++, parameter2.getName(), changeType ? this.getReturnType() : parameter2.getType()));
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(psiMethod.getProject(), psiMethod, false, (PsiElement)myVariable);
                dialog.setParameterInfos(infos);
                dialog.show();
            } else {
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, false, null, psiMethod.getName(), psiMethod.getReturnType(), infos.toArray(new ParameterInfoImpl[0]));
                processor.run();
            }
            return true;
        }
        return false;
    }

    protected PsiType getReturnType() {
        return this.myReturnType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

