/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchSurrounder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class SurroundWithTryCatchFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix");
    private PsiElement myElement;

    public SurroundWithTryCatchFix(@NotNull PsiElement element) {
        if (element == null) {
            SurroundWithTryCatchFix.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiStatement || element instanceof PsiResourceVariable || element instanceof PsiExpression && !(element instanceof PsiMethodReferenceExpression) && ControlFlowUtils.canExtractStatement((PsiExpression)element, false)) {
            this.myElement = element;
        }
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
        if (string == null) {
            SurroundWithTryCatchFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("surround.with.try.catch.fix", new Object[0]);
        if (string == null) {
            SurroundWithTryCatchFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SurroundWithTryCatchFix.$$$reportNull$$$0(3);
        }
        if (this.myElement != null && this.myElement.isValid()) {
            PsiElement parentStatement = RefactoringUtil.getParentStatement(this.myElement, false);
            return !(parentStatement instanceof PsiDeclarationStatement) || !(((PsiDeclarationStatement)parentStatement).getDeclaredElements()[0] instanceof PsiClass);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SurroundWithTryCatchFix.$$$reportNull$$$0(4);
        }
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        if (this.myElement instanceof PsiExpression) {
            this.myElement = RefactoringUtil.ensureCodeBlock((PsiExpression)this.myElement);
        }
        this.myElement = RefactoringUtil.getParentStatement(this.myElement, false);
        if (this.myElement == null) {
            return;
        }
        TextRange range = null;
        try {
            JavaWithTryCatchSurrounder handler = new JavaWithTryCatchSurrounder();
            range = handler.surroundElements(project, editor, new PsiElement[]{this.myElement});
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        LogicalPosition pos = new LogicalPosition(line, col);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (range != null) {
            int offset = range.getStartOffset();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithTryCatchFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

