/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedVariableUtil {
    public static boolean checkSideEffects(PsiExpression element, @Nullable PsiVariable variableToIgnore, List<? super PsiElement> sideEffects) {
        if (sideEffects == null || element == null) {
            return false;
        }
        ArrayList<PsiElement> writes = new ArrayList<PsiElement>();
        SideEffectChecker.checkSideEffects(element, writes);
        if (variableToIgnore != null) {
            for (int i = writes.size() - 1; i >= 0; --i) {
                PsiExpression lExpression;
                PsiElement write = (PsiElement)writes.get(i);
                if (!(write instanceof PsiAssignmentExpression) || !((lExpression = ((PsiAssignmentExpression)write).getLExpression()) instanceof PsiReference) || ((PsiReference)lExpression).resolve() != variableToIgnore) continue;
                writes.remove(i);
            }
        }
        sideEffects.addAll(writes);
        return !writes.isEmpty();
    }

    static PsiElement replaceElementWithExpression(PsiExpression expression2, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        PsiElement elementToReplace = element;
        PsiExpression expressionToReplaceWith = expression2;
        if (element.getParent() instanceof PsiExpressionStatement) {
            PsiElement lastChild;
            elementToReplace = element.getParent();
            expressionToReplaceWith = factory.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
            if (RemoveUnusedVariableUtil.isForLoopUpdate(elementToReplace) && PsiUtil.isJavaToken((PsiElement)(lastChild = expressionToReplaceWith.getLastChild()), (IElementType)JavaTokenType.SEMICOLON)) {
                lastChild.delete();
            }
        } else if (element.getParent() instanceof PsiDeclarationStatement) {
            expressionToReplaceWith = factory.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
        }
        return elementToReplace.replace((PsiElement)expressionToReplaceWith);
    }

    static PsiElement createStatementIfNeeded(PsiExpression expression2, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        if (!(element.getParent() instanceof PsiExpressionStatement) && !(element.getParent() instanceof PsiDeclarationStatement)) {
            return expression2;
        }
        return factory.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
    }

    static void deleteWholeStatement(PsiElement element, PsiElementFactory factory) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiExpressionStatement) {
            PsiExpressionStatement parent = (PsiExpressionStatement)element.getParent();
            if (parent.getParent() instanceof PsiCodeBlock || RemoveUnusedVariableUtil.isForLoopUpdate((PsiElement)parent)) {
                parent.delete();
            } else {
                parent.replace(RemoveUnusedVariableUtil.createStatementIfNeeded(null, factory, element));
            }
        } else {
            element.delete();
        }
    }

    static void deleteReferences(PsiVariable variable, List<? extends PsiElement> references, @NotNull RemoveMode mode) throws IncorrectOperationException {
        if (mode == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(0);
        }
        for (PsiElement psiElement : references) {
            RemoveUnusedVariableUtil.processUsage(psiElement, variable, null, mode);
        }
    }

    static void collectReferences(@NotNull PsiElement context, final PsiVariable variable, final List<? super PsiElement> references) {
        if (context == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(1);
        }
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable) {
                    references.add(expression2);
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    static Boolean processUsage(PsiElement element, PsiVariable variable, List<? super PsiElement> sideEffects, @NotNull RemoveMode deleteMode) throws IncorrectOperationException {
        if (deleteMode == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(2);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
        while (element != null) {
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression2 = (PsiAssignmentExpression)element;
                PsiExpression lExpression = expression2.getLExpression();
                if (!(lExpression instanceof PsiReferenceExpression) || variable != ((PsiReferenceExpression)lExpression).resolve()) {
                    return null;
                }
                PsiExpression rExpression = expression2.getRExpression();
                if ((rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rExpression)) == null) {
                    return true;
                }
                boolean sideEffectFound = RemoveUnusedVariableUtil.checkSideEffects(rExpression, variable, sideEffects);
                if (!RemoveUnusedVariableUtil.isStatementExpression((PsiExpression)expression2) || PsiUtil.isStatement((PsiElement)rExpression)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT || deleteMode == RemoveMode.DELETE_ALL && !(element.getParent() instanceof PsiExpressionStatement)) {
                        element = RemoveUnusedVariableUtil.replaceElementWithExpression(rExpression, factory, element);
                        element = RemoveUnusedVariableUtil.eraseUnnecessaryOuterParentheses(element);
                        ArrayList references = new ArrayList();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                }
                return !sideEffectFound;
            }
            if (element instanceof PsiExpressionStatement && deleteMode != RemoveMode.CANCEL) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == element) {
                    element.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText(";", element));
                    break;
                }
                element.delete();
                break;
            }
            if (element instanceof PsiVariable && element == variable) {
                PsiExpression expression3 = variable.getInitializer();
                if (expression3 != null) {
                    expression3 = PsiUtil.deparenthesizeExpression((PsiExpression)expression3);
                }
                boolean sideEffectsFound = RemoveUnusedVariableUtil.checkSideEffects(expression3, variable, sideEffects);
                if (expression3 != null && PsiUtil.isStatement((PsiElement)expression3) && variable instanceof PsiLocalVariable && (!(variable.getParent() instanceof PsiDeclarationStatement) || ((PsiDeclarationStatement)variable.getParent()).getDeclaredElements().length <= 1)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT) {
                        element = element.getParent().replace(RemoveUnusedVariableUtil.createStatementIfNeeded(expression3, factory, element));
                        ArrayList references = new ArrayList();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        element.delete();
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    if (element instanceof PsiField) {
                        ((PsiField)element).normalizeDeclaration();
                    }
                    element.delete();
                }
                return !sideEffectsFound;
            }
            element = element.getParent();
        }
        return true;
    }

    @NotNull
    private static PsiElement eraseUnnecessaryOuterParentheses(@NotNull PsiElement element) {
        if (element == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(3);
        }
        PsiElement parenthesizedParent = element;
        while (parenthesizedParent.getParent() instanceof PsiParenthesizedExpression) {
            parenthesizedParent = parenthesizedParent.getParent();
        }
        if (parenthesizedParent != element) {
            PsiElement psiElement = parenthesizedParent.replace(element);
            if (psiElement == null) {
                RemoveUnusedVariableUtil.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            RemoveUnusedVariableUtil.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public static boolean isForLoopUpdate(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiForStatement && ((PsiForStatement)parent).getUpdate() == element;
    }

    private static boolean isStatementExpression(PsiExpression expression2) {
        PsiElement parent = expression2.getParent();
        return parent instanceof PsiExpressionStatement || parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteMode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "eraseUnnecessaryOuterParentheses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectReferences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processUsage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "eraseUnnecessaryOuterParentheses";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum RemoveMode {
        MAKE_STATEMENT,
        DELETE_ALL,
        CANCEL;

    }
}

