/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveBoundClassToFrontFix
extends ExtendsListFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MoveBoundClassToFrontFix");
    private final String myName;

    public MoveBoundClassToFrontFix(@NotNull PsiClass aClass, @NotNull PsiClassType classToExtendFrom) {
        if (aClass == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(0);
        }
        if (classToExtendFrom == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(1);
        }
        super(aClass, classToExtendFrom, true);
        this.myName = QuickFixBundle.message("move.bound.class.to.front.fix.text", HighlightUtil.formatClass(this.myClassToExtendFrom), HighlightUtil.formatClass(aClass));
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.in.extend.list.family", new Object[0]);
        if (string == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass;
        PsiReferenceList extendsList;
        if (project == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(7);
        }
        if ((extendsList = (myClass = (PsiClass)startElement).getExtendsList()) == null) {
            return;
        }
        try {
            this.modifyList(extendsList, false, -1);
            this.modifyList(extendsList, true, 0);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass;
        if (project == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            MoveBoundClassToFrontFix.$$$reportNull$$$0(11);
        }
        return (myClass = (PsiClass)startElement).getManager().isInProject((PsiElement)myClass) && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToExtendFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveBoundClassToFrontFix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveBoundClassToFrontFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

