/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected final String mySignature;
    protected final String myBody;

    private CreateMethodQuickFix(PsiClass targetClass, @NonNls String signature, @NonNls String body2) {
        super((PsiElement)targetClass);
        this.mySignature = signature;
        this.myBody = body2;
    }

    @NotNull
    public String getText() {
        PsiClass myTargetClass = (PsiClass)this.getStartElement();
        String signature = myTargetClass == null ? "" : PsiFormatUtil.formatMethod((PsiMethod)this.createMethod(myTargetClass), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)65795, (int)65538, (int)2);
        String string = QuickFixBundle.message("create.method.from.usage.text", signature);
        if (string == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(5);
        }
        PsiClass myTargetClass = (PsiClass)startElement;
        PsiMethod method = this.createMethod(myTargetClass);
        List arguments = ContainerUtil.map2List((Object[])method.getParameterList().getParameters(), psiParameter -> Pair.create(null, (Object)psiParameter.getType()));
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(myTargetClass.add((PsiElement)method));
        CreateMethodFromUsageFix.doCreate(myTargetClass, method, arguments, PsiSubstitutor.EMPTY, ExpectedTypeInfo.EMPTY_ARRAY, (PsiElement)method);
    }

    private PsiMethod createMethod(@NotNull PsiClass myTargetClass) {
        if (myTargetClass == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(6);
        }
        Project project = myTargetClass.getProject();
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)myTargetClass.getLanguage(), (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        String methodText = this.mySignature + (myTargetClass.isInterface() ? ";" : "{" + this.myBody + "}");
        return elementFactory.createMethodFromText(methodText, null);
    }

    @Nullable
    public static CreateMethodQuickFix createFix(@NotNull PsiClass targetClass, @NonNls String signature, @NonNls String body2) {
        if (targetClass == null) {
            CreateMethodQuickFix.$$$reportNull$$$0(7);
        }
        CreateMethodQuickFix fix = new CreateMethodQuickFix(targetClass, signature, body2);
        try {
            fix.createMethod(targetClass);
            return fix;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myTargetClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

