/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromUsageBaseFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix");

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element;
        if (project == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(0);
        }
        if ((element = this.getElement()) == null || this.isValidElement(element)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (!this.isAvailableImpl(offset)) {
            return false;
        }
        List<PsiClass> targetClasses = this.filterTargetClasses(element, project);
        return !targetClasses.isEmpty();
    }

    protected abstract boolean isAvailableImpl(int var1);

    protected abstract void invokeImpl(PsiClass var1);

    protected abstract boolean isValidElement(PsiElement var1);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement element = this.getElement();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CreateFromUsage: element =" + element);
        }
        if (element == null) {
            return;
        }
        List<PsiClass> targetClasses = this.filterTargetClasses(element, project);
        if (targetClasses.isEmpty()) {
            return;
        }
        if (targetClasses.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.doInvoke(project, targetClasses.get(0));
        } else {
            this.chooseTargetClass(targetClasses, editor);
        }
    }

    protected List<PsiClass> filterTargetClasses(PsiElement element, Project project) {
        return ContainerUtil.filter(this.getTargetClasses(element), psiClass -> JVMElementFactories.getFactory((Language)psiClass.getLanguage(), (Project)project) != null);
    }

    private void doInvoke(Project project, PsiClass targetClass) {
        if (!FileModificationService.getInstance().prepareFileForWrite(targetClass.getContainingFile())) {
            return;
        }
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        ApplicationManager.getApplication().runWriteAction(() -> this.invokeImpl(targetClass));
    }

    @Nullable
    protected abstract PsiElement getElement();

    private void chooseTargetClass(List<PsiClass> classes2, Editor editor) {
        PsiClass firstClass = classes2.get(0);
        Project project = firstClass.getProject();
        PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes2, firstClass);
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(classes2).setSelectionMode(0).setSelectedValue((Object)preselection, true).setRenderer((ListCellRenderer)((Object)renderer)).setItemChosenCallback(aClass -> {
            AnonymousTargetClassPreselectionUtil.rememberSelection(aClass, firstClass);
            CommandProcessor.getInstance().executeCommand(project, () -> this.doInvoke(project, (PsiClass)aClass), this.getText(), null);
        }).setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0]));
        renderer.installSpeedSearch(builder);
        builder.createPopup().showInBestPositionFor(editor);
    }

    @Nullable(value="null means unable to open the editor")
    public static Editor positionCursor(@NotNull Project project, @NotNull PsiFile targetFile, @NotNull PsiElement element) {
        TextRange range;
        if (project == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(2);
        }
        if (targetFile == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(4);
        }
        LOG.assertTrue((range = element.getTextRange()) != null, element.getClass());
        int textOffset = range.getStartOffset();
        VirtualFile file = targetFile.getVirtualFile();
        if (file == null && (file = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, textOffset);
        descriptor.setScrollType(ScrollType.MAKE_VISIBLE);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    protected void setupVisibility(PsiClass parentClass, @NotNull PsiClass targetClass, PsiModifierList list) throws IncorrectOperationException {
        if (targetClass == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(5);
        }
        if (targetClass.isInterface() && list.getFirstChild() != null) {
            list.deleteChildRange(list.getFirstChild(), list.getLastChild());
            return;
        }
        if (targetClass.isInterface()) {
            return;
        }
        String visibility = this.getVisibility(parentClass, targetClass);
        if ("EscalateVisible".equals(visibility)) {
            list.setModifierProperty("private", true);
            VisibilityUtil.escalateVisibility((PsiModifierList)list, (PsiElement)parentClass);
        } else {
            VisibilityUtil.setVisibility((PsiModifierList)list, (String)visibility);
        }
    }

    @PsiModifier.ModifierConstant
    protected String getVisibility(PsiClass parentClass, @NotNull PsiClass targetClass) {
        if (targetClass == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(6);
        }
        if (parentClass != null && (parentClass.equals(targetClass) || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)parentClass, (boolean)true))) {
            return "private";
        }
        return JavaCodeStyleSettings.getInstance((PsiFile)targetClass.getContainingFile()).VISIBILITY;
    }

    public static boolean shouldCreateStaticMember(PsiReferenceExpression ref, PsiClass targetClass) {
        PsiExpression qualifierExpression2 = ref.getQualifierExpression();
        while (qualifierExpression2 instanceof PsiParenthesizedExpression) {
            qualifierExpression2 = ((PsiParenthesizedExpression)qualifierExpression2).getExpression();
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            PsiElement resolvedElement = referenceExpression.resolve();
            return resolvedElement instanceof PsiClass;
        }
        if (qualifierExpression2 != null) {
            return false;
        }
        if (ref instanceof PsiMethodReferenceExpression) {
            return true;
        }
        assert (PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)ref, (boolean)true));
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiModifierListOwner.class);
        if (owner instanceof PsiMethod && ((PsiMethod)owner).isConstructor()) {
            String calleeText;
            PsiReferenceExpression run = ref;
            while (run.getParent() instanceof PsiExpression) {
                run = (PsiExpression)run.getParent();
            }
            if (run.getParent() instanceof PsiExpressionList && run.getParent().getParent() instanceof PsiMethodCallExpression && ((calleeText = ((PsiMethodCallExpression)run.getParent().getParent()).getMethodExpression().getText()).equals("this") || calleeText.equals("super"))) {
                return true;
            }
        }
        while (owner != null && owner != targetClass) {
            if (owner.hasModifierProperty("static")) {
                return true;
            }
            owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiModifierListOwner.class);
        }
        return false;
    }

    @Nullable
    private static PsiExpression getQualifier(PsiElement element) {
        if (element instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement ref = ((PsiNewExpression)element).getClassReference();
            if (ref instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)ref).getQualifierExpression();
            }
        } else {
            if (element instanceof PsiReferenceExpression) {
                return ((PsiReferenceExpression)element).getQualifierExpression();
            }
            if (element instanceof PsiMethodCallExpression) {
                return ((PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression();
            }
        }
        return null;
    }

    @NotNull
    public static PsiSubstitutor getTargetSubstitutor(@Nullable PsiElement element) {
        PsiType type2;
        if (element instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement reference = ((PsiNewExpression)element).getClassOrAnonymousClassReference();
            JavaResolveResult result = reference == null ? JavaResolveResult.EMPTY : reference.advancedResolve(false);
            PsiSubstitutor psiSubstitutor = result.getSubstitutor();
            if (psiSubstitutor == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(7);
            }
            return psiSubstitutor;
        }
        PsiExpression qualifier = CreateFromUsageBaseFix.getQualifier(element);
        if (qualifier != null && (type2 = qualifier.getType()) instanceof PsiClassType) {
            PsiSubstitutor psiSubstitutor = ((PsiClassType)type2).resolveGenerics().getSubstitutor();
            if (psiSubstitutor == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(8);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(9);
        }
        return psiSubstitutor;
    }

    protected boolean isAllowOuterTargetClass() {
        return true;
    }

    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        PsiAnnotation annotation;
        PsiClass psiClass = null;
        PsiExpression qualifier = null;
        if (element instanceof PsiNameValuePair && (annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class)) != null) {
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    CreateFromUsageBaseFix.$$$reportNull$$$0(10);
                }
                return list;
            }
            PsiElement resolve = nameRef.resolve();
            if (resolve instanceof PsiClass) {
                List<PsiClass> list = Collections.singletonList((PsiClass)resolve);
                if (list == null) {
                    CreateFromUsageBaseFix.$$$reportNull$$$0(11);
                }
                return list;
            }
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (element instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
            if (ref != null) {
                PsiElement refElement = ref.resolve();
                if (refElement instanceof PsiClass) {
                    psiClass = (PsiClass)refElement;
                } else {
                    PsiElement refQualifier = ref.getQualifier();
                    if (refQualifier instanceof PsiJavaCodeReferenceElement && (refElement = ((PsiJavaCodeReferenceElement)refQualifier).resolve()) instanceof PsiClass) {
                        psiClass = (PsiClass)refElement;
                    }
                }
            }
        } else if (element instanceof PsiReferenceExpression) {
            PsiExpression expression2;
            PsiSwitchStatement switchStatement;
            PsiElement parent;
            qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
            if (qualifier == null && element instanceof PsiMethodReferenceExpression) {
                PsiTypeElement qualifierTypeElement = ((PsiMethodReferenceExpression)element).getQualifierType();
                if (qualifierTypeElement != null) {
                    psiClass = PsiUtil.resolveClassInType((PsiType)qualifierTypeElement.getType());
                }
            } else if (qualifier == null && (parent = element.getParent()) instanceof PsiSwitchLabelStatement && (switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiSwitchStatement.class)) != null && (expression2 = switchStatement.getExpression()) != null) {
                psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            }
        } else if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
            qualifier = methodExpression.getQualifierExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    CreateFromUsageBaseFix.$$$reportNull$$$0(13);
                }
                return list;
            }
        }
        boolean allowOuterClasses = false;
        if (qualifier != null) {
            PsiElement resolved;
            PsiType type2 = qualifier.getType();
            if (type2 instanceof PsiClassType) {
                psiClass = ((PsiClassType)type2).resolve();
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass && psiClass == null) {
                psiClass = (PsiClass)resolved;
            }
        } else if (psiClass == null) {
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            allowOuterClasses = true;
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiClass[] supers = psiClass.getSupers();
            ArrayList<PsiClass> filtered = new ArrayList<PsiClass>();
            for (PsiClass aSuper : supers) {
                if (!aSuper.getManager().isInProject((PsiElement)aSuper) || aSuper instanceof PsiTypeParameter) continue;
                filtered.add(aSuper);
            }
            ArrayList<PsiClass> arrayList = filtered;
            if (arrayList == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        if (psiClass == null || !psiClass.getManager().isInProject((PsiElement)psiClass)) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (!allowOuterClasses || !this.isAllowOuterTargetClass()) {
            ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
            this.collectSupers(psiClass, classes2);
            ArrayList<PsiClass> arrayList = classes2;
            if (arrayList == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        while (psiClass != null) {
            result.add(psiClass);
            if (psiClass.hasModifierProperty("static")) break;
            psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
        }
        ArrayList<PsiClass> arrayList = result;
        if (arrayList == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private void collectSupers(PsiClass psiClass, ArrayList<PsiClass> classes2) {
        PsiClass[] supers;
        classes2.add(psiClass);
        for (PsiClass aSuper : supers = psiClass.getSupers()) {
            if (classes2.contains(aSuper) || !this.canBeTargetClass(aSuper)) continue;
            this.collectSupers(aSuper, classes2);
        }
    }

    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass);
    }

    public static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project) {
        if (editor == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(18);
        }
        if (project == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(19);
        }
        CreateFromUsageBaseFix.startTemplate(editor, template, project, null);
    }

    protected static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project, TemplateEditingListener listener) {
        if (editor == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(20);
        }
        if (project == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(21);
        }
        CreateFromUsageBaseFix.startTemplate(editor, template, project, listener, null);
    }

    public static void startTemplate(@NotNull Editor editor, Template template, @NotNull Project project, TemplateEditingListener listener, String commandName) {
        if (editor == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(22);
        }
        if (project == null) {
            CreateFromUsageBaseFix.$$$reportNull$$$0(23);
        }
        Runnable runnable = () -> {
            if (project == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(24);
            }
            if (editor == null) {
                CreateFromUsageBaseFix.$$$reportNull$$$0(25);
            }
            TemplateManager.getInstance((Project)project).startTemplate(editor, template, listener);
        };
        CommandProcessor.getInstance().executeCommand(project, runnable, commandName, (Object)commandName);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void setupGenericParameters(PsiClass targetClass, PsiJavaCodeReferenceElement ref) {
        int numParams = ref.getTypeParameters().length;
        if (numParams == 0) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ref.getProject()).getElementFactory();
        HashSet<String> typeParamNames = new HashSet<String>();
        for (PsiType type2 : ref.getTypeParameters()) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (!(psiClass instanceof PsiTypeParameter)) continue;
            typeParamNames.add(psiClass.getName());
        }
        int idx = 0;
        block1: for (PsiType type3 : ref.getTypeParameters()) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type3);
            if (psiClass instanceof PsiTypeParameter) {
                targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText(psiClass.getName(), null));
                continue;
            }
            while (true) {
                String paramName;
                String string = paramName = idx > 0 ? "T" + idx : "T";
                if (typeParamNames.add(paramName)) {
                    targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText(paramName, null));
                    continue block1;
                }
                ++idx;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateFromUsageBaseFix";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSubstitutor";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "positionCursor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupVisibility";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVisibility";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startTemplate$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

