/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.ConstructorBodyGenerator;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorMatchingSuperFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix");
    private final PsiClass myClass;

    public CreateConstructorMatchingSuperFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            CreateConstructorMatchingSuperFix.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constructor.matching.super", new Object[0]);
        if (string == null) {
            CreateConstructorMatchingSuperFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateConstructorMatchingSuperFix.$$$reportNull$$$0(2);
        }
        if (!this.myClass.isValid() || !this.myClass.getManager().isInProject((PsiElement)this.myClass)) {
            return false;
        }
        this.setText(QuickFixBundle.message("create.constructor.matching.super", new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        PsiMethod[] baseConstrs;
        if (project == null) {
            CreateConstructorMatchingSuperFix.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        PsiClass baseClass = this.myClass.getSuperClass();
        LOG.assertTrue(baseClass != null);
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)this.myClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        ArrayList<PsiMethodMember> baseConstructors = new ArrayList<PsiMethodMember>();
        for (PsiMethod baseConstr : baseConstrs = baseClass.getConstructors()) {
            if (!PsiUtil.isAccessible((PsiMember)baseConstr, (PsiElement)this.myClass, (PsiClass)this.myClass)) continue;
            baseConstructors.add(new PsiMethodMember(baseConstr, substitutor));
        }
        CreateConstructorMatchingSuperFix.chooseConstructor2Delegate(project, editor, substitutor, baseConstructors, baseConstrs, this.myClass);
    }

    public static void chooseConstructor2Delegate(Project project, Editor editor, PsiSubstitutor substitutor, List<PsiMethodMember> baseConstructors, PsiMethod[] baseConstrs, PsiClass targetClass) {
        PsiMethodMember[] constructors = baseConstructors.toArray(new PsiMethodMember[0]);
        if (constructors.length == 0) {
            constructors = new PsiMethodMember[baseConstrs.length];
            for (int i = 0; i < baseConstrs.length; ++i) {
                constructors[i] = new PsiMethodMember(baseConstrs[i], substitutor);
            }
        }
        LOG.assertTrue(constructors.length >= 1);
        boolean isCopyJavadoc = true;
        if (constructors.length > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser((ClassMember[])constructors, false, true, project);
            chooser.setTitle(QuickFixBundle.message("super.class.constructors.chooser.title", new Object[0]));
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return;
            }
            constructors = (PsiMethodMember[])chooser.getSelectedElements((ClassMember[])new PsiMethodMember[0]);
            isCopyJavadoc = chooser.isCopyJavadoc();
        }
        PsiMethodMember[] constructors1 = constructors;
        boolean isCopyJavadoc1 = isCopyJavadoc;
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                if (targetClass.getLBrace() == null) {
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)targetClass.getProject()).getElementFactory().createClass("X");
                    targetClass.addRangeAfter(psiClass.getLBrace(), psiClass.getRBrace(), targetClass.getLastChild());
                }
                JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)project);
                CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
                PsiMethod derived = null;
                for (PsiMethodMember candidate : constructors1) {
                    String targetClassName;
                    PsiDocComment docComment;
                    PsiMethod base = (PsiMethod)candidate.getElement();
                    derived = GenerateMembersUtil.substituteGenericMethod(base, candidate.getSubstitutor(), (PsiElement)targetClass);
                    if (!isCopyJavadoc1 && (docComment = derived.getDocComment()) != null) {
                        docComment.delete();
                    }
                    LOG.assertTrue((targetClassName = targetClass.getName()) != null, (Object)targetClass);
                    derived.setName(targetClassName);
                    ConstructorBodyGenerator generator = (ConstructorBodyGenerator)ConstructorBodyGenerator.INSTANCE.forLanguage(derived.getLanguage());
                    if (generator != null) {
                        StringBuilder buffer = new StringBuilder();
                        generator.start(buffer, derived.getName(), PsiParameter.EMPTY_ARRAY);
                        generator.generateSuperCallIfNeeded(buffer, derived.getParameterList().getParameters());
                        generator.finish(buffer);
                        PsiMethod stub = factory.createMethodFromText(buffer.toString(), (PsiElement)targetClass);
                        derived.getBody().replace((PsiElement)stub.getBody());
                    }
                    derived = (PsiMethod)formatter.reformat((PsiElement)derived);
                    derived = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)derived);
                    PsiGenerationInfo<PsiMethod> info = OverrideImplementUtil.createGenerationInfo(derived);
                    info.insert(targetClass, null, true);
                    derived = info.getPsiMember();
                }
                if (derived != null) {
                    editor.getCaretModel().moveToOffset(derived.getTextRange().getStartOffset());
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            UndoUtil.markPsiFileForUndo((PsiFile)targetClass.getContainingFile());
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

