/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorFromCallFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromCallFix");
    private final PsiConstructorCall myConstructorCall;

    public CreateConstructorFromCallFix(@NotNull PsiConstructorCall constructorCall) {
        if (constructorCall == null) {
            CreateConstructorFromCallFix.$$$reportNull$$$0(0);
        }
        this.myConstructorCall = constructorCall;
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return false;
    }

    @Override
    protected void invokeImpl(final PsiClass targetClass) {
        final Project project = this.myConstructorCall.getProject();
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        try {
            PsiMethod constructor = (PsiMethod)targetClass.add((PsiElement)elementFactory.createConstructor());
            final PsiFile file = targetClass.getContainingFile();
            TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)constructor);
            CreateFromUsageUtils.setupMethodParameters(constructor, (TemplateBuilder)templateBuilder, this.myConstructorCall.getArgumentList(), CreateConstructorFromCallFix.getTargetSubstitutor((PsiElement)this.myConstructorCall));
            final PsiMethod superConstructor = CreateClassFromNewFix.setupSuperCall(targetClass, constructor, templateBuilder);
            constructor = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)constructor);
            Template template = templateBuilder.buildTemplate();
            final Editor editor = CreateConstructorFromCallFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)targetClass);
            if (editor == null) {
                return;
            }
            TextRange textRange = constructor.getTextRange();
            editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
            editor.getCaretModel().moveToOffset(textRange.getStartOffset());
            CreateConstructorFromCallFix.startTemplate(editor, template, project, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        try {
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                            int offset = editor.getCaretModel().getOffset();
                            PsiMethod constructor1 = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiMethod.class, (boolean)false);
                            if (superConstructor == null) {
                                CreateFromUsageUtils.setupMethodBody(constructor1);
                            } else {
                                OverrideImplementUtil.setupMethodBody(constructor1, superConstructor, targetClass);
                            }
                            CreateFromUsageUtils.setupEditor(constructor1, editor);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    });
                }
            });
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiFile getTargetFile(PsiElement element) {
        PsiJavaCodeReferenceElement qualifier;
        PsiElement psiElement;
        PsiConstructorCall constructorCall = (PsiConstructorCall)element;
        if (constructorCall instanceof PsiEnumConstant) {
            return constructorCall.getContainingFile();
        }
        PsiJavaCodeReferenceElement referenceElement = CreateConstructorFromCallFix.getReferenceElement(constructorCall);
        if (referenceElement.getQualifier() instanceof PsiJavaCodeReferenceElement && (psiElement = (qualifier = (PsiJavaCodeReferenceElement)referenceElement.getQualifier()).resolve()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            return psiClass.getContainingFile();
        }
        return null;
    }

    @Override
    protected PsiElement getElement() {
        if (!this.myConstructorCall.isValid() || !this.myConstructorCall.getManager().isInProject((PsiElement)this.myConstructorCall)) {
            return null;
        }
        PsiExpressionList argumentList = this.myConstructorCall.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        if (this.myConstructorCall instanceof PsiEnumConstant) {
            return this.myConstructorCall;
        }
        PsiJavaCodeReferenceElement referenceElement = CreateConstructorFromCallFix.getReferenceElement(this.myConstructorCall);
        if (referenceElement == null) {
            return null;
        }
        if (referenceElement.getReferenceNameElement() instanceof PsiIdentifier) {
            return this.myConstructorCall;
        }
        return null;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiConstructorCall constructorCall = (PsiConstructorCall)element;
        PsiMethod method = constructorCall.resolveConstructor();
        PsiExpressionList argumentList = constructorCall.getArgumentList();
        List<PsiClass> targetClasses = this.getTargetClasses((PsiElement)constructorCall);
        if (targetClasses.isEmpty()) {
            return false;
        }
        PsiClass targetClass = targetClasses.get(0);
        return !CreateFromUsageUtils.shouldCreateConstructor(targetClass, argumentList, method);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiElement element = CreateConstructorFromCallFix.getElement((PsiElement)this.myConstructorCall);
        PsiFile targetFile = CreateConstructorFromCallFix.getTargetFile((PsiElement)this.myConstructorCall);
        if (targetFile != null && !targetFile.getManager().isInProject((PsiElement)targetFile)) {
            return false;
        }
        if (CreateFromUsageUtils.shouldShowTag(offset, element, (PsiElement)this.myConstructorCall)) {
            this.setText(QuickFixBundle.message("create.constructor.from.new.text", new Object[0]));
            return true;
        }
        return false;
    }

    private static PsiJavaCodeReferenceElement getReferenceElement(PsiConstructorCall constructorCall) {
        if (constructorCall instanceof PsiNewExpression) {
            return ((PsiNewExpression)constructorCall).getClassOrAnonymousClassReference();
        }
        return null;
    }

    private static PsiElement getElement(PsiElement targetElement) {
        if (targetElement instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement referenceElement = CreateConstructorFromCallFix.getReferenceElement((PsiConstructorCall)((PsiNewExpression)targetElement));
            if (referenceElement == null) {
                return null;
            }
            return referenceElement.getReferenceNameElement();
        }
        if (targetElement instanceof PsiEnumConstant) {
            return targetElement;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constructor.from.new.family", new Object[0]);
        if (string == null) {
            CreateConstructorFromCallFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromCallFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorFromCallFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

